<?php
// vim: ts=2 sw=2
include_once "db.php";
include_once "base_controller.php";

class AlarmController extends BaseController {
  protected function signinRequired() {
    return true;
  }
  protected function authKeyRequired() {
    return true;
  }
  protected function sameHostAuthFree() {
    return true;
  }

  protected function doAjaxPost() {
    $response = array();

    if (!isset($_POST['action']) || empty($_POST['action']))
      $this->renderAjaxError($response, L("no action specified"));

    $action = trim($_POST['action']);
    $error = null;
    if ($action == 'add')
      $error = $this->addAlarm();
    else if ($action == 'delete')
      $error = $this->deleteAlarm();
    else if($action == 'ackn')
      $error = $this->ackAlarm();
    else if($action == 'noteadd')
      $error = $this->addNote();
    else
      $error = L(sprintf("%s is not supported", $action));
  
    if (is_null($error))
      $this->renderAjaxSuccess2($response);
    else
      $this->renderAjaxError($response, $error);
  }

  protected function addAlarm() {
    if (empty($_POST['uuid']))
      return L("Alarm component's uuid is missing");
    $uuid = trim($_POST['uuid']);

    if (empty($_POST['priority']))
      return L("Alarm priority is missing");
    $priority = intval($_POST['priority']);
    if ($priority == 0)
      return L("Alarm priority is not a integer");

    if (empty($_POST['value']))
      return L("Alarm value is missing");
    $value = trim($_POST['value']);

    if (empty($_POST['text']))
      return L("Alarm text is missing");
    $text = trim($_POST['text']);

    //NOTE: we use the default date generated in sqlite, so no need to process date param here

    $tags = null;
    if (isset($_POST['tags']) && !empty($_POST['tags'])) {
      $tags = explode(",", $_POST['tags']);
      foreach($tags as &$tag) {
        $tag = trim($tag);
      }
      $tags = implode(",", $tags);
    }

    $cls = null;
    if (isset($_POST['class'])) {
      $cls = intval($_POST['class']);
    }

    $state = null;
    if (isset($_POST['state'])) {
      $state = intval($_POST['state']);
    }

    $model = new Alarms();
    return $model->createAlarm($uuid, $priority, $value, $text, $tags, $cls, $state);
  }

  protected function deleteAlarm() {
    if (empty($_POST['id']))
      return L("Alarm id is missing");

    $id_list = explode(",", $_POST['id']);
    foreach($id_list as &$id) {
      $id = trim($id);
      $idval = intval($id);
      if ($idval == 0)
        return L(sprintf("Invalid Alarm id: %s", $id));
    }
    
    $model = new Alarms();
    return $model->deleteAlarm($id_list); 
  }

  protected function ackAlarm() {
    if (empty($_POST['id']))
      return L("Alarm id is missing");

    $id_list = explode(",", $_POST['id']);
    foreach($id_list as &$id) {
      $id = trim($id);
      $idval = intval($id);
      if ($idval == 0)
        return L(sprintf("Invalid Alarm id: %s", $id));
    }

    if (empty($_POST['ackn_user']))
      return L("Acknowledge user name is missing");

    $user = trim($_POST['ackn_user']);
    
    $model = new Alarms();
    return $model->ackAlarm($id_list, $user);    
  }

  protected function addNote() {
    if (empty($_POST['id']))
      return L("Alarm id is missing");

    $id_list = explode(",", $_POST['id']);
    foreach($id_list as &$id) {
      $id = trim($id);
      $idval = intval($id);
      if ($idval == 0)
        return L(sprintf("Invalid Alarm id: %s", $id));
    }

    if (empty($_POST['ackn_user']))
      return L("Note user name is missing");
    $user = trim($_POST['ackn_user']);
    if (strlen($user) == 0) 
      return L("Note user name is empty");

    if (empty($_POST['text']))
      return L("Note text is missing");
    $text = trim($_POST['text']);

    $model = new Alarms();
    return $model->createNote($id_list, $user, $text);
  }
}

$controller = new AlarmController();
$controller->run();

?>
