<?php
//vim: ts=2 sw=2

include_once "utils.php";
include_once "backup_restore.php";

class RemoteRestoreController {
  public function run() {
    sync();
    $name = $_GET['name'];
    $cptPath = $_GET['cptPath'];
    $withHistoryDB = $_GET['withHistoryDB'] != '0';
    $type = $_GET['type'];
    $confirm = $_GET['confirm'] == '1';
    $clear = $_GET['clear'] == '1';

    if (!$clear) {
        $rootPath = $_SERVER['DOCUMENT_ROOT'];
        $realCptPath = build_file_path($rootPath, $cptPath);
        $errCode = 1000;
        $error = doRestore($name, $realCptPath, $withHistoryDB, $type, false, $confirm, $errCode);
        error_log("restore errCode: " . $errCode);
        if (empty($error) || $errCode != 1001) {
            $clear = true;
        }
        if (!empty($error)) {
            $error = $errCode . "-" . $error;
            error_log("restore error: " . $error);
        }
        else
            setupIndex($rootPath, $realCptPath, true);
    }
    if ($confirm || $clear) {
      cleanupGhostScripts();
      sync();
    }

    die($error);
  }
}

$controller = new RemoteRestoreController();
$controller->run();

?>
