<?php
//vim: ts=2 sw=2

include_once "utils.php";
include_once "backup_restore.php";

class RemoteBackupController {
  public function run() {
    sync();
    $name = $_GET['name'];
    $cptPath = $_GET['cptPath'];
    if (array_key_exists('type', $_GET))
      $type = $_GET['type'];
    else
      $type = "sdcard";
    $backupHistoryDB = strcmp($_GET['backupHistoryDB'], '1') == 0;

    $rootPath = $_SERVER['DOCUMENT_ROOT'];

    $cptFullPath = build_file_path($rootPath, $cptPath);
    if (file_exists(realpath($cptFullPath)))
    {
        $cptFullPath = realpath($cptFullPath);
        if (!startsWith($cptFullPath, $rootPath)) {
            error_log("invalid backup path");
            die(L("invalid backup path"));
        }
    }
    else
        error_log("no cpt folder found, ignore it");
    
    $error = doBackup($name, $cptFullPath, $backupHistoryDB, $type);

    if (!empty($error))
      error_log("backup error: " . $error);

    cleanupGhostScripts();
    sync();

    die($error);
  }
}

$controller = new RemoteBackupController();
$controller->run();

?>
