<?php
// vim: ts=2 sw=2

include_once "utils.php";

class FeatureControl {

    public static function instance() {
      static $inst = NULL;
      if ($inst === NULL) {
        $inst = new FeatureControl();
      }
      return $inst;
    }
    
    private function __construct() {
      // error_log("FeatureControl is created");
    }
    
    public function isEnabled($feature) {
      $platformName = platformName();
      if ($feature == "Graphic")
        return $platformName != "FW";

      if ($feature == "Dashboard")
        return in_array($platformName, array("FS", "FG+", "FW"));
       
      if (in_array($feature, array("UIControl", "PortConfig", "ChangeSysPassword")))
        return in_array($platformName, array("FS", "FG+"));
      
      if ($feature == "FirmwareUpgrade")
        return $platformName == "FS";

      return true;
    }
    
};

?>
