<?php
//vim: ts=2 sw=2

class DeviceConfigFile {
    protected $configs = NULL;
    protected $conf_file_name = "/mnt/sedona/easyio.config";
    
    public function load($file_name=NULL) {
      if (!is_null($file_name))
        $this->conf_file_name = $file_name;

      if (!file_exists($this->conf_file_name))
      {
        //error_log("can not find ini file:" . $this->conf_file_name);
        return false;
      }

      $this->configs = $this->parse_conf_file($this->conf_file_name);
      if (!$this->configs)
      {
        error_log("can not parse config file:" . $this->conf_file_name);
        return false;
      }
      return true;
    }
    
    protected function parse_conf_file($file_path) {
      $result = array();
      $content = file_get_contents($file_path);
      if (!$content) {
        error_log("can not open confile file:" . $file_path);
        return $result;
      }
      
      $lines = explode("\n", $content);
      if (count($lines) == 0) {
        error_log("the config file is empty");
        return $result;
      }

      foreach($lines as $line) {
        $line = trim($line);
        if (empty($line))
            continue;

        $parts = explode(":", $line, 2);
        if (count($parts) != 2) {
          error_log("invalid config line: " . $line);
          continue;
        }
        
        $result[$parts[0]] = $parts[1];
      }
      return $result;
    }

    public function value($key, $defaultVal) {
      if (!$this->configs)
          return $defaultVal;
      
      if (!in_array($key, array_keys($this->configs)))
          return $defaultVal;
      
      return $this->configs[$key];
    }
    
    public function keys() {
      return array_keys($this->configs);
    }
    
    // public function setValue($section, $key, $value) {
    //     if (!$this->configs)
    //         $this->configs = array();
    //     
    //     if (is_null($section)) {
    //       $this->configs[$key] = $value;
    //     } else {
    //       if (!in_array($section, array_keys($this->configs)))
    //           $this->configs[$section] = array();
    //
    //       $this->configs[$section][$key] = $value;
    //     }
    // }
}

?>
