/*
 * Decompiled with CFR 0.152.
 */
package sedona.util;

import java.util.StringTokenizer;

public class Version
implements Comparable {
    public static Version NULL = new Version("0");
    private int[] versions;

    public static Version parse(String string) {
        if (string == null) {
            return null;
        }
        return new Version(string);
    }

    public Version(String string) {
        try {
            int[] nArray = new int[16];
            int n = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            while (stringTokenizer.hasMoreTokens()) {
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                if (n2 < 0) {
                    throw new IllegalArgumentException();
                }
                nArray[n++] = n2;
            }
            this.versions = new int[n];
            System.arraycopy(nArray, 0, this.versions, 0, n);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid version string \"" + string + "\"");
        }
    }

    public Version(int[] nArray, int n) {
        this.versions = new int[n];
        System.arraycopy(nArray, 0, this.versions, 0, n);
    }

    public int major() {
        if (this.versions.length < 1) {
            return -1;
        }
        return this.versions[0];
    }

    public int minor() {
        if (this.versions.length < 2) {
            return -1;
        }
        return this.versions[1];
    }

    public int build() {
        if (this.versions.length < 3) {
            return -1;
        }
        return this.versions[2];
    }

    public int patch() {
        if (this.versions.length < 4) {
            return -1;
        }
        return this.versions[3];
    }

    public int get(int n) {
        return this.versions[n];
    }

    public int size() {
        return this.versions.length;
    }

    public boolean isNull() {
        if (this.versions.length == 1) {
            return this.versions[0] == 0;
        }
        return false;
    }

    public int compareTo(Object object) {
        Version version = (Version)object;
        int n = this.versions.length;
        int n2 = version.versions.length;
        for (int i = 0; i < n && i < n2; ++i) {
            if (this.versions[i] > version.versions[i]) {
                return 1;
            }
            if (this.versions[i] >= version.versions[i]) continue;
            return -1;
        }
        if (n == n2) {
            return 0;
        }
        if (n > n2) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (object instanceof Version) {
            Version version = (Version)object;
            if (this.versions.length != version.versions.length) {
                return false;
            }
            for (int i = 0; i < this.versions.length; ++i) {
                if (this.versions[i] == version.versions[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.toString(this.versions.length);
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n && i < this.versions.length; ++i) {
            if (i > 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(this.versions[i]);
        }
        return stringBuffer.toString();
    }
}

