/*
 * Decompiled with CFR 0.152.
 */
package sedona.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class Abstime
implements Comparable {
    private DateFormat format = new SimpleDateFormat("HH:mm:ss dd-MMM-yy z");
    private static final int[] daysInMonth = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    static final TimeZone defaultTimeZone = TimeZone.getDefault();
    static final TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");
    private long millis;
    private int bits0;
    private int bits1;
    private TimeZone timeZone;

    public static Abstime now() {
        return new Abstime(System.currentTimeMillis(), defaultTimeZone);
    }

    public static Abstime make(long l) {
        return new Abstime(l, defaultTimeZone);
    }

    public static Abstime make(long l, TimeZone timeZone) {
        return new Abstime(l, timeZone);
    }

    public static Abstime parse(String string) {
        Abstime abstime = new Abstime(0L, defaultTimeZone);
        abstime.decode(string);
        return abstime;
    }

    private Abstime(long l, TimeZone timeZone) {
        this.millis = l;
        this.timeZone = timeZone;
        this.bits1 = 0;
        this.bits0 = 0;
    }

    public long getMillis() {
        return this.millis;
    }

    public final int getYear() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return this.bits0 >> 16 & 0xFFFF;
    }

    public final int getMonth() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return this.bits1 >> 25 & 0xF;
    }

    public final int getDay() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return this.bits1 >> 20 & 0x1F;
    }

    public final int getHour() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return this.bits1 >> 15 & 0x1F;
    }

    public final int getMinute() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return this.bits1 >> 9 & 0x3F;
    }

    public final int getSecond() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return this.bits1 >> 3 & 0x3F;
    }

    public final int getMillisecond() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return this.bits0 & 0xFFFF;
    }

    public final int getWeekday() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return this.bits1 & 7;
    }

    public final long getTimeOfDayMillis() {
        return (long)(this.getHour() * 60 * 60) * 1000L + (long)(this.getMinute() * 60) * 1000L + (long)this.getSecond() * 1000L + (long)this.getMillisecond();
    }

    public String toString() {
        if (this.millis == 0L) {
            return "null";
        }
        return this.format.format(new Date(this.millis));
    }

    public final TimeZone getTimeZone() {
        return this.timeZone;
    }

    public int getTimeZoneOffset() {
        if (!this.inDaylightTime()) {
            return this.timeZone.getRawOffset();
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.timeZone);
        gregorianCalendar.setTime(new Date(this.millis));
        return gregorianCalendar.get(15) + gregorianCalendar.get(16);
    }

    public boolean inDaylightTime() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return (this.bits1 >> 29 & 1) != 0;
    }

    public Abstime toLocalTime() {
        if (this.timeZone.equals(defaultTimeZone)) {
            return this;
        }
        return new Abstime(this.millis, defaultTimeZone);
    }

    public Abstime toUtcTime() {
        if (this.timeZone.equals(utcTimeZone)) {
            return this;
        }
        return new Abstime(this.millis, utcTimeZone);
    }

    public int compareTo(Object object) {
        Abstime abstime = (Abstime)object;
        if (this.millis < abstime.millis) {
            return -1;
        }
        if (this.millis == abstime.millis) {
            return 0;
        }
        return 1;
    }

    public boolean isBefore(Abstime abstime) {
        return this.compareTo(abstime) < 0;
    }

    public boolean isAfter(Abstime abstime) {
        return this.compareTo(abstime) > 0;
    }

    public int hashCode() {
        return (int)(this.millis ^ this.millis >> 32);
    }

    public boolean dateEquals(Abstime abstime) {
        return abstime.getYear() == this.getYear() && abstime.getMonth() == this.getMonth() && abstime.getDay() == this.getDay();
    }

    public boolean timeEquals(Abstime abstime) {
        return abstime.getTimeOfDayMillis() == this.getTimeOfDayMillis();
    }

    public boolean isLeapDay() {
        return this.getMonth() == 2 && this.getDay() == 29;
    }

    public static boolean isLeapYear(int n) {
        if (n >= 1582) {
            return n % 4 == 0 && (n % 100 != 0 || n % 400 == 0);
        }
        return n % 4 == 0;
    }

    public static int getDaysInMonth(int n, int n2) {
        Abstime.checkMonth(n2);
        if (n2 == 2) {
            return Abstime.isLeapYear(n) ? 29 : 28;
        }
        return daysInMonth[n2 - 1];
    }

    public static int getDaysInYear(int n) {
        return Abstime.isLeapYear(n) ? 366 : 365;
    }

    public String encode() {
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append(this.getYear()).append('-');
        int n = this.getMonth();
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n).append('-');
        int n2 = this.getDay();
        if (n2 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n2).append('T');
        int n3 = this.getHour();
        if (n3 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n3).append(':');
        int n4 = this.getMinute();
        if (n4 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n4).append(':');
        int n5 = this.getSecond();
        if (n5 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n5).append('.');
        int n6 = this.getMillisecond();
        if (n6 < 10) {
            stringBuffer.append('0');
        }
        if (n6 < 100) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n6);
        int n7 = this.getTimeZoneOffset();
        if (n7 == 0) {
            stringBuffer.append('Z');
        } else {
            int n8 = Math.abs(n7 / 3600000);
            int n9 = Math.abs(n7 % 3600000 / 60000);
            if (n7 < 0) {
                stringBuffer.append('-');
            } else {
                stringBuffer.append('+');
            }
            if (n8 < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n8);
            stringBuffer.append(':');
            if (n9 < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n9);
        }
        return stringBuffer.toString();
    }

    private void decode(String string) throws RuntimeException {
        char[] cArray = string.toCharArray();
        try {
            char c;
            int n = 0;
            int n2 = (cArray[n++] - 48) * 1000 + (cArray[n++] - 48) * 100 + (cArray[n++] - 48) * 10 + (cArray[n++] - 48) * 1;
            if (cArray[n++] != '-') {
                throw new Exception();
            }
            int n3 = (cArray[n++] - 48) * 10 + (cArray[n++] - 48) * 1;
            if (cArray[n++] != '-') {
                throw new Exception();
            }
            int n4 = (cArray[n++] - 48) * 10 + (cArray[n++] - 48) * 1;
            if (cArray[n++] != 'T') {
                throw new Exception();
            }
            int n5 = (cArray[n++] - 48) * 10 + (cArray[n++] - 48) * 1;
            if (cArray[n++] != ':') {
                throw new Exception();
            }
            int n6 = (cArray[n++] - 48) * 10 + (cArray[n++] - 48) * 1;
            if (cArray[n++] != ':') {
                throw new Exception();
            }
            int n7 = (cArray[n++] - 48) * 10 + (cArray[n++] - 48) * 1;
            int n8 = 0;
            if (cArray[n] == '.') {
                int n9 = ++n;
                n8 = (cArray[n9] - 48) * 100;
                if ('0' <= cArray[++n] && cArray[n] <= '9') {
                    n8 += (cArray[n++] - 48) * 10;
                }
                if ('0' <= cArray[n] && cArray[n] <= '9') {
                    n8 += (cArray[n++] - 48) * 1;
                }
                while (n < cArray.length && '0' <= cArray[n] && cArray[n] <= '9') {
                    ++n;
                }
            }
            int n10 = 0;
            if ((c = cArray[n++]) != 'Z') {
                if (c != '+' && c != '-') {
                    throw new Exception();
                }
                int n11 = cArray[n++] - 48;
                if (n < cArray.length && cArray[n] != ':') {
                    n11 = n11 * 10 + (cArray[n++] - 48);
                }
                int n12 = 0;
                if (n < cArray.length) {
                    if (cArray[n++] != ':') {
                        throw new Exception();
                    }
                    n12 = 10 * (cArray[n++] - 48) + (cArray[n++] - 48);
                }
                n10 = n11 * 3600000 + n12 * 60000;
                if (c == '-') {
                    n10 *= -1;
                }
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar(n2, n3 - 1, n4, n5, n6, n7);
            gregorianCalendar.set(14, n8);
            ((Calendar)gregorianCalendar).setTimeZone(new SimpleTimeZone(n10, "Offset"));
            this.millis = gregorianCalendar.getTime().getTime();
            this.timeZone = this.timeZone;
            this.bits1 = 0;
            this.bits0 = 0;
        }
        catch (Exception exception) {
            throw new RuntimeException("Invalid abstime: " + string);
        }
    }

    private static long toMillis(int n, int n2, int n3, int n4, int n5, int n6, int n7, TimeZone timeZone) {
        Abstime.checkMonth(n2);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.set(n, n2 - 1, n3, n4, n5, n6);
        gregorianCalendar.set(14, n7);
        return gregorianCalendar.getTime().getTime();
    }

    private static int checkMonth(int n) {
        if (n < 1 || n > 12) {
            throw new IllegalArgumentException("Month must be 1 to 12");
        }
        return n;
    }

    private void millisToFields() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.timeZone);
        Date date = new Date(this.millis);
        gregorianCalendar.setTime(date);
        int n = gregorianCalendar.get(1);
        this.bits0 |= (n & 0xFFFF) << 16;
        n = gregorianCalendar.get(14);
        this.bits0 |= (n & 0xFFFF) << 0;
        n = gregorianCalendar.get(2) + 1;
        this.bits1 |= (n & 0xF) << 25;
        n = gregorianCalendar.get(5);
        this.bits1 |= (n & 0x1F) << 20;
        n = gregorianCalendar.get(11);
        this.bits1 |= (n & 0x1F) << 15;
        n = gregorianCalendar.get(12);
        this.bits1 |= (n & 0x3F) << 9;
        n = gregorianCalendar.get(13);
        this.bits1 |= (n & 0x3F) << 3;
        n = gregorianCalendar.get(7) - 1;
        this.bits1 |= (n & 7) << 0;
        if (this.timeZone.inDaylightTime(date)) {
            this.bits1 |= 0x20000000;
        }
    }
}

