/*
 * Decompiled with CFR 0.152.
 */
package sedona.manifest;

import java.util.Arrays;
import java.util.zip.CRC32;
import sedona.Facets;
import sedona.Value;
import sedona.manifest.KitManifest;
import sedona.manifest.SlotManifest;
import sedona.manifest.TypeManifest;

public class KitChecksum {
    CRC32 crc = new CRC32();

    public int compute(KitManifest kitManifest) {
        this.crc.reset();
        this.update(kitManifest);
        return (int)this.crc.getValue();
    }

    private void update(KitManifest kitManifest) {
        int n;
        this.update(kitManifest.name);
        this.update(kitManifest.types.length);
        for (n = 0; n < kitManifest.types.length; ++n) {
            this.update(kitManifest.types[n]);
        }
        for (n = 0; n < kitManifest.depends.length; ++n) {
            this.update(kitManifest.depends[n].toString());
        }
    }

    private void update(TypeManifest typeManifest) {
        this.update(typeManifest.id);
        this.update(typeManifest.name);
        this.update(typeManifest.facets);
        this.update(typeManifest.slots.length);
        this.update(typeManifest.base);
        for (int i = 0; i < typeManifest.slots.length; ++i) {
            this.update(typeManifest.slots[i]);
        }
    }

    private void update(SlotManifest slotManifest) {
        this.update(slotManifest.declaredId);
        this.update(slotManifest.name);
        this.update(slotManifest.facets);
        this.update(slotManifest.type);
        this.update(slotManifest.flags);
        this.update(slotManifest.def);
    }

    private void update(Facets facets) {
        Object[] objectArray = facets.keys();
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            Value value = facets.get((String)object);
            this.update((String)object);
            this.update(value);
        }
    }

    private void update(Value value) {
        if (value != null) {
            this.update(value.encodeString());
        }
    }

    private void update(String string) {
        if (string == null) {
            string = "<<null>>";
        }
        try {
            this.crc.update(string.getBytes("UTF-8"));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    private void update(int n) {
        this.crc.update(n >>> 24 & 0xFF);
        this.crc.update(n >>> 16 & 0xFF);
        this.crc.update(n >>> 8 & 0xFF);
        this.crc.update(n >>> 0 & 0xFF);
    }
}

