/*
 * Decompiled with CFR 0.152.
 */
package sedona.kit;

import java.io.File;
import sedona.util.TextUtil;
import sedona.util.Version;

public class KitFile
implements Comparable {
    public final File file;
    public final String name;
    public final int checksum;
    public final Version version;

    public static boolean isKitFile(File file) {
        return !file.isDirectory() && file.getName().endsWith(".kit");
    }

    public KitFile(File file) {
        String string = file.getName();
        if (!string.endsWith(".kit")) {
            throw new IllegalArgumentException("Not a .kit file: " + file);
        }
        String[] stringArray = TextUtil.split(string = string.substring(0, string.length() - 4), '-');
        if (stringArray.length != 3) {
            throw new IllegalArgumentException("Invalid kit filename: " + file);
        }
        this.file = file;
        this.name = stringArray[0];
        this.checksum = (int)Long.parseLong(stringArray[1], 16);
        this.version = new Version(stringArray[2]);
    }

    public boolean exists() {
        return this.file.exists();
    }

    public int compareTo(Object object) {
        return this.toString().compareTo(object.toString());
    }

    public String toString() {
        return this.file.getName();
    }

    public static KitFile best(KitFile kitFile, KitFile kitFile2) {
        if (kitFile == null) {
            return kitFile2;
        }
        if (kitFile2 == null) {
            return kitFile;
        }
        int n = kitFile.version.compareTo(kitFile2.version);
        if (n > 0) {
            return kitFile;
        }
        if (n < 0) {
            return kitFile2;
        }
        return kitFile.file.lastModified() > kitFile2.file.lastModified() ? kitFile : kitFile2;
    }
}

