/*
 * Decompiled with CFR 0.152.
 */
package sedona.dasp;

import java.util.Properties;
import sedona.dasp.DaspMessage;
import sedona.dasp.DaspSession;
import sedona.dasp.DaspSocket;

final class ReceiveWindow {
    private static int verifies;
    static final int max = 31;
    private final DaspSession session;
    private int seqNum = -1;
    private int seqMore = -1;
    private boolean acked;

    ReceiveWindow(DaspSession daspSession) {
        this.session = daspSession;
    }

    final synchronized boolean unacked() {
        return !this.acked;
    }

    final synchronized void setAckHeaders(DaspMessage daspMessage) {
        int n = daspMessage.payload.length;
        if (n + 8 <= this.session.idealMax) {
            daspMessage.ack = this.seqNum;
            this.acked = true;
            if (this.seqMore > 1 && n + 11 <= this.session.idealMax) {
                daspMessage.ackMore = ReceiveWindow.toAckMore(this.seqMore, this.session.idealMax - n - 10);
            }
        }
    }

    static byte[] toAckMore(int n, int n2) {
        if (n <= 255 || n2 <= 1) {
            return new byte[]{(byte)(n >>> 0)};
        }
        if (n <= 65535 || n2 <= 2) {
            return new byte[]{(byte)(n >>> 8), (byte)(n >>> 0)};
        }
        if (n <= 0xFFFFFF || n2 <= 3) {
            return new byte[]{(byte)(n >>> 16), (byte)(n >>> 8), (byte)(n >>> 0)};
        }
        return new byte[]{(byte)(n >>> 24), (byte)(n >>> 16), (byte)(n >>> 8), (byte)(n >>> 0)};
    }

    final synchronized void init(int n) {
        if (this.seqNum >= 0) {
            throw new IllegalStateException();
        }
        this.seqNum = n - 1 & 0xFFFF;
        this.seqMore = 1;
        this.acked = false;
    }

    final synchronized boolean receive(int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalStateException("" + n);
        }
        if (this.seqNum < 0) {
            throw new IllegalStateException();
        }
        int n2 = this.seqNum;
        int n3 = n2 + 31;
        if (n3 <= 65535) {
            if (n <= n2 || n > n3) {
                this.acked = false;
                return false;
            }
        } else if (n <= n2 && n > (n3 -= 65535)) {
            this.acked = false;
            return false;
        }
        if (n == this.seqNum + 1 || n == 0 && this.seqNum == 65535) {
            do {
                ++this.seqNum;
                this.seqMore = this.seqMore >> 1 & Integer.MAX_VALUE;
            } while ((this.seqMore & 2) != 0);
            this.seqNum &= 0xFFFF;
            this.seqMore |= 1;
        } else {
            int n4 = 1 << (n - n2 & 0xFFFF);
            if ((this.seqMore & n4) != 0) {
                return false;
            }
            this.seqMore |= n4;
        }
        this.acked = false;
        return true;
    }

    public static void main(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        DaspSocket daspSocket = DaspSocket.open(-1, null, 14);
        DaspSession daspSession = new DaspSession(daspSocket.interfaces[0], 0, null, 0, true, new Properties());
        ReceiveWindow receiveWindow = new ReceiveWindow(daspSession);
        receiveWindow.test();
        long l2 = System.currentTimeMillis();
        System.out.println("  ReceiveWindow Success: " + verifies + " verifies [" + (l2 - l) + "ms]");
        daspSocket.close();
    }

    private void test() {
        int n;
        int n2;
        int n3;
        this.verify(-1, -1);
        this.seqNum = -1;
        this.init(1);
        int n4 = 0;
        for (n3 = 1; n3 <= 70000; ++n3) {
            n2 = n3 - 1 & 0xFFFF;
            n4 = n3 & 0xFFFF;
            n = n3 + 32 & 0xFFFF;
            this.verify(this.receive(n4), "num=" + n4);
            this.verify(!this.receive(n2), "prev=" + n2);
            this.verify(!this.receive(n), "big=" + n);
            this.verify(n4, 1);
        }
        for (n3 = 1; n3 <= 70000; ++n3) {
            n4 = n3 & 0xFFFF;
            n2 = n4 + 2 & 0xFFFF;
            n = n4 + 4 & 0xFFFF;
            this.seqNum = n4;
            this.seqMore = 1;
            this.verify(this.receive(n2));
            this.verify(n4, 5);
            this.verify(this.receive(n));
            this.verify(n4, 21);
            n4 = n4 + 1 & 0xFFFF;
            this.verify(this.receive(n4));
            this.verify(n2, 5);
            this.verify(!this.receive(n2));
            this.verify(!this.receive(n));
            n4 = n4 + 2 & 0xFFFF;
            this.verify(this.receive(n4));
            this.verify(n, 1);
            this.verify(!this.receive(n2));
            this.verify(!this.receive(n));
            this.verify(!this.receive(n4));
        }
        for (n3 = 1; n3 <= 70000; ++n3) {
            this.seqNum = n4 = n3 & 0xFFFF;
            this.seqMore = 1;
            this.verify(n4, 1);
            n2 = 0;
            for (n = 31; n > 1; --n) {
                int n5 = n4 + n & 0xFFFF;
                this.verify(this.receive(n5));
                this.verify(n4, (n2 |= 1 << n) | 1);
            }
            this.verify(this.receive(n4 + 1 & 0xFFFF));
            this.verify(n4 + 31 & 0xFFFF, 1);
        }
    }

    private void verify(int n, int n2) {
        if (this.seqNum != n) {
            throw new RuntimeException(this.seqNum + " != " + n);
        }
        if (this.seqMore != n2) {
            throw new RuntimeException("0x" + Integer.toHexString(this.seqMore) + " != 0x" + Integer.toHexString(n2));
        }
        ++verifies;
    }

    private void verify(boolean bl) {
        this.verify(bl, "");
    }

    private void verify(boolean bl, String string) {
        if (!bl) {
            throw new RuntimeException(string);
        }
        ++verifies;
    }
}

