/*
 * Decompiled with CFR 0.152.
 */
package sedona;

import sedona.manifest.KitManifest;
import sedona.manifest.ManifestDb;
import sedona.util.TextUtil;
import sedona.util.Version;

public class KitPart {
    public final String name;
    public final int checksum;
    public final String key;
    public final Version version;

    public static KitPart forLocalKit(String string) throws Exception {
        KitManifest kitManifest = ManifestDb.loadForLocalKit(string);
        if (kitManifest == null) {
            return null;
        }
        return kitManifest.part();
    }

    public static KitPart parse(String string) {
        try {
            int n = string.indexOf(45);
            String string2 = string.substring(0, n);
            int n2 = (int)Long.parseLong(string.substring(n + 1), 16);
            return new KitPart(string2, n2);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid KitPart format: " + string);
        }
    }

    public KitPart(String string, int n) {
        this(string, n, null);
    }

    public KitPart(String string, int n, Version version) {
        this.name = string;
        this.checksum = n;
        this.key = string + "-" + TextUtil.intToHexString(n);
        this.version = version;
    }

    public String toString() {
        return this.key;
    }
}

