/*
 * Decompiled with CFR 0.152.
 */
package sedona;

import java.io.IOException;
import sedona.Buf;
import sedona.Value;

public final class Int
extends Value {
    static final Int[] predefined = new Int[256];
    static final Int ZERO;
    public final int val;

    public static Int make(int n) {
        if (0 <= n && n < predefined.length) {
            return predefined[n];
        }
        return new Int(n);
    }

    private Int(int n) {
        this.val = n;
    }

    @Override
    public int typeId() {
        return 4;
    }

    public int hashCode() {
        return this.val;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Int) {
            return this.val == ((Int)object).val;
        }
        return false;
    }

    @Override
    public String encodeString() {
        return String.valueOf(this.val);
    }

    @Override
    public Value decodeString(String string) {
        return Int.make(Integer.decode(string));
    }

    @Override
    public void encodeBinary(Buf buf) {
        buf.i4(this.val);
    }

    @Override
    public Value decodeBinary(Buf buf) throws IOException {
        return Int.make(buf.i4());
    }

    static {
        for (int i = 0; i < predefined.length; ++i) {
            Int.predefined[i] = new Int(i);
        }
        ZERO = predefined[0];
    }
}

