/*
 * Decompiled with CFR 0.152.
 */
package sedonac.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import sedona.Buf;
import sedona.KitPart;
import sedona.util.Version;

public class SCodeParser {
    Buf buf;
    public boolean bigEndian = true;
    public int majorVer;
    public int minorVer;
    public int blockSize;
    public int blockIndexSize;
    public int refSize;
    public int imageSize;
    public int dataSize;
    public int mainMethod;
    public int scodeFlags;
    public KitPart[] kits;

    public KitPart[] parse(File file) throws IOException {
        return this.parse(Buf.readFrom((File)file));
    }

    public KitPart[] parse(Buf buf) throws IOException {
        this.buf = buf;
        buf.pos = 0;
        if (buf.i4() != 1590737415) {
            buf.pos = 0;
            this.bigEndian = false;
            buf.bigEndian = false;
            if (buf.i4() != 1590737415) {
                throw new IOException("Invalid magic for scode");
            }
        }
        this.majorVer = buf.u1();
        this.minorVer = buf.u1();
        if (this.majorVer == 1 && this.minorVer == 5) {
            this.blockIndexSize = 2;
        } else if (this.majorVer == 2 && this.minorVer == 0) {
            this.blockIndexSize = 4;
        } else {
            throw new IOException("Unsupported scode version " + this.majorVer + "." + this.minorVer);
        }
        this.blockSize = buf.u1();
        this.refSize = buf.u1();
        this.imageSize = buf.i4();
        this.dataSize = buf.i4();
        this.mainMethod = this.blockIndexSize == 2 ? buf.u2() : buf.i4();
        int n = this.blockIndexSize == 2 ? buf.u2() : buf.i4();
        int n2 = this.blockIndexSize == 2 ? buf.u2() : buf.i4();
        int n3 = buf.u1();
        this.scodeFlags = buf.u1();
        KitPart[] kitPartArray = new KitPart[n3];
        for (int i = 0; i < n3; ++i) {
            buf.pos = n2 * this.blockSize + i * this.blockIndexSize;
            kitPartArray[i] = this.parseKit(this.blockIndexSize == 2 ? buf.u2() : buf.i4());
        }
        this.kits = kitPartArray;
        return kitPartArray;
    }

    private KitPart parseKit(int n) throws IOException {
        this.buf.pos = n * this.blockSize;
        int n2 = this.buf.u1();
        int n3 = this.buf.u1();
        if (this.blockIndexSize == 4) {
            this.buf.skipBytes(2);
        }
        String string = this.parseStr(this.blockIndexSize == 2 ? this.buf.u2() : this.buf.i4());
        String string2 = this.parseStr(this.blockIndexSize == 2 ? this.buf.u2() : this.buf.i4());
        if (this.blockIndexSize == 2) {
            this.buf.u2();
        }
        int n4 = this.buf.i4();
        return new KitPart(string, n4, Version.parse((String)string2));
    }

    private String parseStr(int n) throws IOException {
        int n2 = n * this.blockSize;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (this.buf.bytes[n2 + n3] != 0) {
            stringBuffer.append((char)this.buf.bytes[n2 + n3]);
            ++n3;
        }
        return stringBuffer.toString();
    }

    public void dump() {
        PrintWriter printWriter = new PrintWriter(System.out);
        this.dump(printWriter);
        printWriter.flush();
    }

    public void dump(PrintWriter printWriter) {
        printWriter.println("  majorVer:   " + this.majorVer);
        printWriter.println("  minorVer :  " + this.minorVer);
        printWriter.println("  endian:     " + (this.bigEndian ? "big" : "little"));
        printWriter.println("  blockSize:  " + this.blockSize);
        printWriter.println("  blockIndexSize:  " + this.blockIndexSize);
        printWriter.println("  refSize:    " + this.refSize);
        printWriter.println("  imageSize:  " + this.imageSize);
        printWriter.println("  dataSize:   " + this.dataSize);
        printWriter.println("  scodeFlags: 0x" + Integer.toHexString(this.scodeFlags));
        printWriter.println("    debug:    " + ((this.scodeFlags & 1) != 0));
        printWriter.println("    test:     " + ((this.scodeFlags & 2) != 0));
        printWriter.println("  kits:");
        for (int i = 0; i < this.kits.length; ++i) {
            printWriter.println("    " + this.kits[i] + " " + this.kits[i].version);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.out.println("usage: SCodeParser <file>");
            return;
        }
        SCodeParser sCodeParser = new SCodeParser();
        sCodeParser.parse(new File(stringArray[0]));
        sCodeParser.dump();
    }
}

