/*
 * Decompiled with CFR 0.152.
 */
package sedonac.translate;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import sedonac.Compiler;
import sedonac.ast.Block;
import sedonac.ast.Expr;
import sedonac.ast.FieldDef;
import sedonac.ast.MethodDef;
import sedonac.ast.ParamDef;
import sedonac.ast.SlotDef;
import sedonac.ast.Stmt;
import sedonac.ast.TypeDef;
import sedonac.namespace.Field;
import sedonac.namespace.Slot;
import sedonac.namespace.StubType;
import sedonac.namespace.Type;
import sedonac.translate.AbstractTranslator;

public class CTranslator
extends AbstractTranslator {
    public CTranslator(Compiler compiler, TypeDef typeDef) {
        super(compiler, typeDef);
    }

    @Override
    public File toFile() {
        return new File(this.outDir, this.qname(this.type) + ".c");
    }

    @Override
    public void doTranslate() {
        this.w("#include \"").w(this.qname(this.type)).w(".h\"").nl();
        this.includes();
        this.nl();
        this.w("extern bool approx(float a, float b);").nl();
        this.w("extern void doAssert(bool cond, const char* file, int line);").nl();
        this.w("#define assert(c) doAssert((c), __FILE__, __LINE__)").nl();
        this.nl();
        this.staticFields();
        this.nl();
        MethodDef[] methodDefArray = this.type.methodDefs();
        for (int i = 0; i < methodDefArray.length; ++i) {
            this.method(methodDefArray[i]);
        }
        if (this.type.qname.equals("sys::Obj")) {
            this.nl();
            this.w("bool approx(float a, float b)").nl();
            this.w("{").nl();
            this.w("  return a < b ? b-a < 0.001f : a-b < 0.001f;").nl();
            this.w("}").nl();
            this.nl();
            this.w("static int successes = 0;").nl();
            this.w("static int failures = 0;").nl();
            this.w("void doAssert(bool cond, const char* file, int line)").nl();
            this.w("{").nl();
            this.w("  if (cond) successes++;").nl();
            this.w("  else failures++;").nl();
            this.w("}").nl();
            this.nl();
            this.w("int main(int argc, char** argv)").nl();
            this.w("{").nl();
            this.w("  sys_FieldTest__staticInit();").nl();
            this.w("  sys_Sys_main();").nl();
            this.w("  printf(\"-- successes = %d\\n\", successes);").nl();
            this.w("  printf(\"-- failures  = %d\\n\", failures);").nl();
            this.w("}").nl();
        }
    }

    public void includes() {
        Type[] typeArray = this.findIncludes();
        for (int i = 0; i < typeArray.length; ++i) {
            this.w("#include \"").w(this.qname(typeArray[i])).w(".h\"").nl();
        }
    }

    public Type[] findIncludes() {
        HashMap hashMap = new HashMap();
        SlotDef[] slotDefArray = this.type.slotDefs();
        for (int i = 0; i < slotDefArray.length; ++i) {
            SlotDef slotDef = slotDefArray[i];
            if (slotDef.isField()) {
                this.findIncludes(hashMap, (FieldDef)slotDef);
                continue;
            }
            this.findIncludes(hashMap, (MethodDef)slotDef);
        }
        return hashMap.values().toArray(new Type[hashMap.size()]);
    }

    public void findIncludes(HashMap hashMap, FieldDef fieldDef) {
        this.addInclude(hashMap, fieldDef.type);
    }

    public void findIncludes(HashMap hashMap, MethodDef methodDef) {
        this.addInclude(hashMap, methodDef.ret);
        for (int i = 0; i < methodDef.params.length; ++i) {
            this.addInclude(hashMap, methodDef.params[i].type);
        }
    }

    public void addInclude(HashMap hashMap, Type type) {
        if (type.isPrimitive()) {
            return;
        }
        if (type.isArray()) {
            this.addInclude(hashMap, type.arrayOf());
            return;
        }
        if (type.qname().equals(this.type.qname)) {
            return;
        }
        hashMap.put(type.qname(), type);
    }

    public void staticFields() {
        FieldDef[] fieldDefArray = this.type.fieldDefs();
        for (int i = 0; i < fieldDefArray.length; ++i) {
            FieldDef fieldDef = fieldDefArray[i];
            if (!fieldDef.isStatic()) continue;
            this.fieldSig(fieldDef);
            this.w(";").nl();
        }
    }

    public void fieldSig(FieldDef fieldDef) {
        this.w(this.toType(fieldDef.type, fieldDef.isInline()));
        this.w(" ").w(this.qname(fieldDef));
        if (fieldDef.type.isArray() && fieldDef.isInline()) {
            this.w("[").w(fieldDef.type.arrayLength()).w("]");
        }
    }

    public void method(MethodDef methodDef) {
        this.methodSig(methodDef).nl();
        this.block(methodDef.code);
        this.nl();
    }

    public CTranslator methodSig(MethodDef methodDef) {
        this.wtype(methodDef.ret).w(" ").w(this.qname(methodDef)).w("(");
        for (int i = 0; i < methodDef.params.length; ++i) {
            ParamDef paramDef = methodDef.params[i];
            if (i > 0) {
                this.w(", ");
            }
            this.wtype(paramDef.type).w(" ").w(paramDef.name);
        }
        this.w(")");
        return this;
    }

    @Override
    public void block(Block block) {
        this.indent().w("{").nl();
        ++this.indent;
        this.localDefs(block);
        this.stmts(block.stmts);
        --this.indent;
        this.indent().w("}").nl();
    }

    public void localDefs(Block block) {
        Stmt.LocalDef[] localDefArray = this.findLocalDefs(block);
        for (int i = 0; i < localDefArray.length; ++i) {
            Stmt.LocalDef localDef = localDefArray[i];
            this.indent().wtype(localDef.type).w(" ").w(localDef.name).w(";").nl();
        }
        if (localDefArray.length > 0) {
            this.nl();
        }
    }

    public Stmt.LocalDef[] findLocalDefs(Block block) {
        ArrayList<Stmt.LocalDef> arrayList = new ArrayList<Stmt.LocalDef>();
        HashMap<String, Stmt.LocalDef> hashMap = new HashMap<String, Stmt.LocalDef>();
        for (int i = 0; i < block.stmts.size(); ++i) {
            Stmt stmt = (Stmt)block.stmts.get(i);
            Stmt.LocalDef localDef = null;
            if (stmt instanceof Stmt.LocalDef) {
                localDef = (Stmt.LocalDef)stmt;
            } else if (stmt instanceof Stmt.For) {
                Stmt.For for_ = (Stmt.For)stmt;
                if (for_.init instanceof Stmt.LocalDef) {
                    localDef = (Stmt.LocalDef)for_.init;
                }
            }
            if (localDef == null) continue;
            int n = 1;
            while (hashMap.containsKey(localDef.name)) {
                localDef.name = localDef.name + n;
                ++n;
            }
            arrayList.add(localDef);
            hashMap.put(localDef.name, localDef);
        }
        return arrayList.toArray(new Stmt.LocalDef[arrayList.size()]);
    }

    @Override
    public void localDef(Stmt.LocalDef localDef, boolean bl) {
        if (localDef.init != null) {
            if (bl) {
                this.indent();
            }
            this.w(localDef.name).w(" = ");
            this.expr(localDef.init, true);
            if (bl) {
                this.w(";").nl();
            }
        }
    }

    @Override
    public void trueLiteral() {
        this.w("TRUE");
    }

    @Override
    public void falseLiteral() {
        this.w("FALSE");
    }

    @Override
    public void nullLiteral() {
        this.w("NULL");
    }

    @Override
    public void binary(Expr.Binary binary, boolean bl) {
        if (binary.id == 29 && binary.lhs.type.isFloat()) {
            this.w("approx(");
            this.expr(binary.lhs, true);
            this.w(", ");
            this.expr(binary.rhs, true);
            this.w(")");
        } else {
            super.binary(binary, bl);
        }
    }

    @Override
    public void field(Expr.Field field) {
        Field field2 = field.field;
        this.w("(");
        if (field2.isStatic()) {
            if (field2.isInline() && !field2.type().isArray()) {
                this.w("(&").w(this.qname(field2)).w(")");
            } else {
                this.w(this.qname(field2));
            }
        } else {
            this.expr(field.target);
            this.w("->");
            this.w(field.name);
        }
        this.w(")");
    }

    @Override
    public void call(Expr.Call call) {
        if (call.target != null && call.target.id != 70) {
            throw new IllegalStateException("Call targets not implemented: " + call);
        }
        this.w(this.qname(call.method));
        this.callArgs(call);
    }

    @Override
    public void assignNarrow(Type type, Expr expr) {
        if (type.isByte()) {
            this.w("(uint8_t)(");
            this.expr(expr);
            this.w(")");
        } else if (type.isShort()) {
            this.w("(uint16_t)(");
            this.expr(expr);
            this.w(")");
        } else {
            this.expr(expr);
        }
    }

    public String qname(Type type) {
        return type.kit().name() + "_" + type.name();
    }

    public String qname(Slot slot) {
        return this.qname(slot.parent()) + "_" + slot.name();
    }

    @Override
    public String toType(Type type) {
        return this.toType(type, false);
    }

    public String toType(Type type, boolean bl) {
        String string = this.toInlineType(type);
        if (type.isRef() && !bl) {
            string = string + "*";
        }
        return string;
    }

    public String toInlineType(Type type) {
        if (type.isArray()) {
            return this.toType(type.arrayOf());
        }
        if (type.isPrimitive()) {
            if (type.isBool()) {
                return "bool";
            }
            if (type.isByte()) {
                return "uint8_t";
            }
            if (type.isShort()) {
                return "uint16_t";
            }
            if (type.isInt()) {
                return "int32_t";
            }
            return type.signature();
        }
        if (type instanceof StubType) {
            return "sys_" + type.name();
        }
        return this.qname(type);
    }
}

