/*
 * Decompiled with CFR 0.152.
 */
package sedonac.test;

import sedona.Buf;
import sedonac.Compiler;
import sedonac.parser.Token;
import sedonac.parser.Tokenizer;
import sedonac.test.Test;

public class TokenizerTest
extends Test {
    public void test() {
        this.verifyId("a");
        this.verifyId("x010");
        this.verifyInt("0", 0);
        this.verifyInt("2", 2);
        this.verifyInt("123", 123);
        this.verifyInt("123456789", 123456789);
        this.verifyInt("0xab", 171);
        this.verifyInt("0x1234ABCD", 305441741);
        this.verifyInt("0xffffffff", -1);
        this.verifyInt("0xf0ffffff", -251658241);
        this.verifyInt("0x7fffffff", Integer.MAX_VALUE);
        this.verifyInt("2147483647", Integer.MAX_VALUE);
        this.verifyInt("'x'", 120);
        this.verifyInt("'!'", 33);
        this.verifyInt("'\n'", 10);
        this.verifyInt("'\r'", 13);
        this.verifyInt("'\t'", 9);
        this.verifyInt("'\u0000'", 0);
        this.verifyInt("'\\\\'", 92);
        this.verifyInt("'\"'", 34);
        this.verifyInt("'\\''", 39);
        this.verifyBad("0x1aabbccdd");
        this.verifyBad("0xaabbccdd_00112233");
        this.verifyBad("2147483649");
        this.verifyLong("0L", 0L);
        this.verifyLong("66l", 66L);
        this.verifyLong("1234567890L", 1234567890L);
        this.verifyLong("1234567890_000L", 1234567890000L);
        this.verifyLong("0xaabbccddl", 2864434397L);
        this.verifyLong("0xaabbccdd_00112233L", -6144092017055948237L);
        this.verifyBad("398387493938383983954943943L");
        this.verifyBad("0x1_aabbccdd_00112233L");
        this.verifyFloat("0f", 0.0f);
        this.verifyFloat("0e0", 0.0f);
        this.verifyFloat("0e10000", 0.0f);
        this.verifyFloat("2f", 2.0f);
        this.verifyFloat("0.0", 0.0f);
        this.verifyFloat("0.0e0", 0.0f);
        this.verifyFloat("0.2", 0.2f);
        this.verifyFloat("2e-1", 0.2f);
        this.verifyFloat("0.2e-1", 0.02f);
        this.verifyFloat("200f", 200.0f);
        this.verifyFloat("2e2", 200.0f);
        this.verifyFloat("2e+2", 200.0f);
        this.verifyFloat("12345.0088", 12345.009f);
        this.verifyFloat("1_0e__1__", 100.0f);
        this.verifyFloat("1e2f", 100.0f);
        this.verifyFloat("1.2e1", 12.0f);
        this.verifyDouble("0d", 0.0);
        this.verifyDouble("0e0d", 0.0);
        this.verifyDouble("0e100d", 0.0);
        this.verifyDouble("2D", 2.0);
        this.verifyDouble("0.0d", 0.0);
        this.verifyDouble("0.0e0d", 0.0);
        this.verifyDouble("0.2d", 0.2);
        this.verifyDouble("2e-1d", 0.2);
        this.verifyDouble("200D", 200.0);
        this.verifyDouble("2e2d", 200.0);
        this.verifyDouble("2e+2d", 200.0);
        this.verifyDouble("12345.0088D", 12345.0088);
        this.verifyDouble("1.23450088e4D", 12345.0088);
        this.verifyTime("0ns", 0L);
        this.verifyTime("0min", 0L);
        this.verifyTime("0ns", 0L);
        this.verifyTime("5ns", 5L);
        this.verifyTime("1ms", 1000000L);
        this.verifyTime("1sec", 1000000000L);
        this.verifyTime("1min", 60000000000L);
        this.verifyTime("1hr", 3600000000000L);
        this.verifyTime("0.5ms", 500000L);
        this.verifyTime("3.2ms", 3200000L);
        this.verifyTime("0.001sec", 1000000L);
        this.verifyTime("0.25min", 15000000000L);
        this.verifyTime("24hr", 86400000000000L);
        this.verifyTime("876000hr", 3153600000000000000L);
        this.verifyTime("1days", 86400000000000L);
        this.verifyTime("0.5days", 43200000000000L);
        this.verifyTime("30days", 2592000000000000L);
        this.verifyTime("36500days", 3153600000000000000L);
        this.verifyStr("", "");
        this.verifyStr("x", "x");
        this.verifyStr("\\\"hi\\\"", "\"hi\"");
        this.verifyStr("\\\\", "\\");
        this.verifyStr("hello world", "hello world");
        this.verifyStr("hello\\nworld", "hello\nworld");
        this.verifyStr("{\\t\\n\\r\\0}", "{\t\n\r\u0000}");
        this.verifyBuf("0x[]", new byte[0]);
        this.verifyBuf("0x[ ]", new byte[0]);
        this.verifyBuf("0x[00]", new byte[]{0});
        this.verifyBuf("0x[0001]", new byte[]{0, 1});
        this.verifyBuf("0x[0001]", new byte[]{0, 1});
        this.verifyBuf("0x[cafe BABE]", new byte[]{-54, -2, -70, -66});
        this.verifyBuf("0x[0123 4567 89ab cd ef]", new byte[]{1, 35, 69, 103, -119, -85, -51, -17});
        this.verifySymbol(10, ".");
        this.verifySymbol(11, ",");
        this.verifySymbol(12, ";");
        this.verifySymbol(13, ":");
        this.verifySymbol(14, "+");
        this.verifySymbol(15, "-");
        this.verifySymbol(16, "*");
        this.verifySymbol(17, "/");
        this.verifySymbol(18, "%");
        this.verifySymbol(19, "&");
        this.verifySymbol(20, "|");
        this.verifySymbol(21, "&&");
        this.verifySymbol(22, "||");
        this.verifySymbol(24, "^");
        this.verifySymbol(25, "?");
        this.verifySymbol(26, "!");
        this.verifySymbol(27, "~");
        this.verifySymbol(29, "<<");
        this.verifySymbol(30, ">>");
        this.verifySymbol(31, "==");
        this.verifySymbol(32, "!=");
        this.verifySymbol(33, ">");
        this.verifySymbol(34, ">=");
        this.verifySymbol(35, "<");
        this.verifySymbol(36, "<=");
        this.verifySymbol(37, "++");
        this.verifySymbol(38, "--");
        this.verifySymbol(39, "->");
        this.verifySymbol(40, "{");
        this.verifySymbol(41, "}");
        this.verifySymbol(42, "[");
        this.verifySymbol(43, "]");
        this.verifySymbol(44, "(");
        this.verifySymbol(45, ")");
        this.verifySymbol(46, "=");
        this.verifyEq(this.tokenize((String)"class")[0].type, 107);
        this.verifyEq(this.tokenize((String)"int")[0].type, 127);
        this.verifyEq(this.tokenize((String)"while")[0].type, 147);
        this.verifyTokens("8 /* 1 2 3 */ 6f", new int[]{3, 5});
        this.verifyTokens("hi // 1 2 \n \"3\"+u", new int[]{1, 7, 14, 1});
    }

    void verifyBad(String string) {
        Exception exception = null;
        try {
            Token token = this.tokenize(string)[0];
            System.out.println("ERROR: " + token);
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        this.verify(exception != null);
    }

    void verifyId(String string) {
        Token token = this.tokenize(string)[0];
        this.verifyEq(token.type, 1);
        this.verifyEq(token.value, string);
    }

    void verifyStr(String string, String string2) {
        Token token = this.tokenize("\"" + string + "\"")[0];
        this.verifyEq(token.type, 7);
        this.verifyEq(token.value, string2);
    }

    void verifyInt(String string, int n) {
        Token token = this.tokenize(string)[0];
        this.verifyEq(token.type, 3);
        this.verifyEq(token.value, new Integer(n));
    }

    void verifyLong(String string, long l) {
        Token token = this.tokenize(string)[0];
        this.verifyEq(token.type, 4);
        this.verifyEq(token.value, new Long(l));
    }

    void verifyFloat(String string, float f) {
        Token token = this.tokenize(string)[0];
        this.verifyEq(token.type, 5);
        this.verifyEq(token.value, new Float(f));
    }

    void verifyDouble(String string, double d) {
        Token token = this.tokenize(string)[0];
        this.verifyEq(token.type, 6);
        this.verifyEq(token.value, new Double(d));
    }

    void verifyTime(String string, long l) {
        Token token = this.tokenize(string)[0];
        this.verifyEq(token.type, 8);
        this.verifyEq(token.value, new Long(l));
    }

    void verifyBuf(String string, byte[] byArray) {
        Token[] tokenArray = this.tokenize(string);
        Token token = tokenArray[0];
        this.verifyEq(token.type, 9);
        Buf buf = (Buf)token.value;
        this.verifyEq(buf.size, byArray.length);
        for (int i = 0; i < buf.size; ++i) {
            this.verifyEq(buf.bytes[i], byArray[i]);
        }
    }

    void verifySymbol(int n, String string) {
        Token token = this.tokenize(string)[0];
        this.verifyEq(token.type, n);
        this.verifyEq(token.toString(), string);
    }

    void verifyTokens(String string, int[] nArray) {
        Token[] tokenArray = this.tokenize(string);
        this.verifyEq(tokenArray.length - 1, nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            this.verifyEq(tokenArray[i].type, nArray[i]);
        }
        this.verifyEq(tokenArray[tokenArray.length - 1].type, 0);
    }

    Token[] tokenize(String string) {
        return new Tokenizer(new Compiler(), "test", string.toCharArray()).tokenize();
    }
}

