/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.util.HashMap;
import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.ast.KitDef;
import sedonac.ast.MethodDef;
import sedonac.ast.NativeDef;
import sedonac.ast.SlotDef;
import sedonac.namespace.NativeId;

public class ResolveNatives
extends CompilerStep {
    public ResolveNatives(Compiler compiler) {
        super(compiler);
    }

    @Override
    public void run() {
        Object object;
        MethodDef[] methodDefArray;
        int n;
        KitDef kitDef = this.compiler.ast;
        String string = kitDef.name + "::";
        NativeDef[] nativeDefArray = kitDef.natives;
        if (nativeDefArray == null) {
            nativeDefArray = new NativeDef[]{};
        }
        this.log.debug("  ResolveNatives [" + nativeDefArray.length + "]");
        HashMap<NativeId, NativeId> hashMap = new HashMap<NativeId, NativeId>();
        boolean[] blArray = new boolean[nativeDefArray.length];
        for (n = 0; n < nativeDefArray.length; ++n) {
            methodDefArray = nativeDefArray[n];
            String string2 = methodDefArray.qname;
            object = methodDefArray.id;
            if (hashMap.get(object) != null) {
                this.err("Duplicate native id '" + object + "'", methodDefArray.loc);
                blArray[n] = true;
                continue;
            }
            hashMap.put((NativeId)object, (NativeId)object);
            if (!string2.startsWith(string)) {
                this.err("Invalid kit for native method '" + string2 + "'", methodDefArray.loc);
                blArray[n] = true;
                continue;
            }
            MethodDef methodDef = (MethodDef)this.ns.resolveMethod(string2);
            if (methodDef == null) continue;
            if (!methodDef.isNative()) {
                this.err("Method is not native '" + string2 + "'", methodDefArray.loc);
                blArray[n] = true;
                continue;
            }
            if (methodDef.nativeId != null) {
                this.err("Native method '" + string2 + "' assigned multiple ids", methodDefArray.loc);
                blArray[n] = true;
                continue;
            }
            methodDef.nativeId = object;
            blArray[n] = true;
        }
        for (n = 0; n < nativeDefArray.length; ++n) {
            if (blArray[n]) continue;
            this.err("Native method not found '" + nativeDefArray[n].qname + "'", nativeDefArray[n].loc);
        }
        for (n = 0; n < kitDef.types.length; ++n) {
            methodDefArray = kitDef.types[n].methodDefs();
            for (int i = 0; i < methodDefArray.length; ++i) {
                object = methodDefArray[i];
                if (!((SlotDef)object).isNative() || ((MethodDef)object).nativeId != null) continue;
                this.err("Native method not assigned id '" + ((MethodDef)object).qname + "'", ((MethodDef)object).loc);
            }
        }
    }
}

