/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.util.ArrayList;
import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.Location;
import sedonac.ast.Expr;
import sedonac.namespace.Type;

public class ConstFolding
extends CompilerStep {
    private static final int INT = 1;
    private static final int LONG = 2;
    private static final int FLOAT = 3;
    private static final int DOUBLE = 4;

    public ConstFolding(Compiler compiler) {
        super(compiler);
    }

    @Override
    public void run() {
        this.log.debug("  ConstFolding");
        this.walkAst(3);
        this.quitIfErrors();
    }

    @Override
    public Expr expr(Expr expr) {
        try {
            if (expr instanceof Expr.Unary) {
                return this.fold((Expr.Unary)expr);
            }
            if (expr instanceof Expr.Interpolation) {
                return this.fold((Expr.Interpolation)expr);
            }
            if (expr instanceof Expr.Cast) {
                return this.fold((Expr.Cast)expr);
            }
            if (!this.compiler.optimize) {
                return expr;
            }
            if (expr instanceof Expr.Binary) {
                return this.fold((Expr.Binary)expr);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return expr;
    }

    private Expr fold(Expr.Unary unary) {
        if (!unary.operand.isLiteral()) {
            return unary;
        }
        Expr.Literal literal = (Expr.Literal)unary.operand;
        if (unary.id == 20) {
            return literal.negate();
        }
        return unary;
    }

    private Expr fold(Expr.Interpolation interpolation) {
        if (!this.compiler.optimize && interpolation.callOk) {
            return interpolation;
        }
        ArrayList<Expr> arrayList = new ArrayList<Expr>();
        arrayList.add(interpolation.first());
        for (int i = 1; i < interpolation.parts.size(); ++i) {
            int n = arrayList.size() - 1;
            Expr expr = (Expr)arrayList.get(n);
            Expr expr2 = (Expr)interpolation.parts.get(i);
            if (expr.id == 9 && expr2.id == 9) {
                String string = expr.toLiteral().asString() + expr2.toLiteral().asString();
                arrayList.set(n, new Expr.Literal(expr.loc, this.ns, 9, (Object)string));
                continue;
            }
            arrayList.add(expr2);
        }
        interpolation.parts = arrayList;
        return arrayList.size() == 1 ? (Expr)arrayList.get(0) : interpolation;
    }

    private Expr fold(Expr.Cast cast) {
        if (!cast.target.isLiteral()) {
            return cast;
        }
        if (cast.type.isInteger()) {
            if (!this.compiler.optimize && (cast.type.isByte() || cast.type.isShort())) {
                return cast;
            }
            Integer n = new Integer(((Number)cast.target.toLiteral().value).intValue());
            return new Expr.Literal(cast.loc, this.ns, 3, (Object)n);
        }
        if (cast.type.isLong()) {
            Long l = new Long(((Number)cast.target.toLiteral().value).longValue());
            return new Expr.Literal(cast.loc, this.ns, 4, (Object)l);
        }
        if (cast.type.isFloat()) {
            Float f = new Float(((Number)cast.target.toLiteral().value).floatValue());
            return new Expr.Literal(cast.loc, this.ns, 5, (Object)f);
        }
        if (cast.type.isDouble()) {
            Double d = new Double(((Number)cast.target.toLiteral().value).doubleValue());
            return new Expr.Literal(cast.loc, this.ns, 6, (Object)d);
        }
        return cast;
    }

    private Expr fold(Expr.Binary binary) {
        Expr expr = binary.lhs;
        Expr expr2 = binary.rhs;
        if (expr.type != expr2.type && !binary.op.isShift()) {
            return binary;
        }
        if (expr.isLiteral() && expr2.isLiteral()) {
            return this.foldLiterals(binary);
        }
        if (expr2.isLiteral() && ((Expr.Literal)expr2).isZero()) {
            return this.foldZero(binary);
        }
        return binary;
    }

    private Expr foldLiterals(Expr.Binary binary) {
        if (!binary.lhs.isLiteral() || !binary.rhs.isLiteral()) {
            throw new IllegalStateException();
        }
        Location location = binary.loc;
        int n = binary.lhs.id;
        Type type = binary.lhs.type;
        Number number = (Number)((Expr.Literal)binary.rhs).value;
        Number number2 = (Number)((Expr.Literal)binary.lhs).value;
        switch (binary.id) {
            case 43: {
                return new Expr.Literal(location, n, type, this.add(number2, number));
            }
            case 40: {
                return new Expr.Literal(location, n, type, this.mul(number2, number));
            }
            case 41: {
                return new Expr.Literal(location, n, type, this.div(number2, number));
            }
            case 42: {
                return new Expr.Literal(location, n, type, this.mod(number2, number));
            }
            case 44: {
                return new Expr.Literal(location, n, type, this.sub(number2, number));
            }
            case 35: {
                return new Expr.Literal(location, n, type, this.bitOr(number2, number));
            }
            case 36: {
                return new Expr.Literal(location, n, type, this.bitXor(number2, number));
            }
            case 37: {
                return new Expr.Literal(location, n, type, this.bitAnd(number2, number));
            }
            case 38: {
                return new Expr.Literal(location, n, type, this.lshift(number2, number));
            }
            case 39: {
                return new Expr.Literal(location, n, type, this.rshift(number2, number));
            }
        }
        return binary;
    }

    private Object add(Number number, Number number2) {
        switch (this.valType(number)) {
            case 1: {
                return new Integer(number.intValue() + number2.intValue());
            }
            case 2: {
                return new Long(number.longValue() + number2.longValue());
            }
            case 3: {
                return new Float(number.floatValue() + number2.floatValue());
            }
            case 4: {
                return new Double(number.doubleValue() + number2.doubleValue());
            }
        }
        throw new RuntimeException();
    }

    private Object mul(Number number, Number number2) {
        switch (this.valType(number)) {
            case 1: {
                return new Integer(number.intValue() * number2.intValue());
            }
            case 2: {
                return new Long(number.longValue() * number2.longValue());
            }
            case 3: {
                return new Float(number.floatValue() * number2.floatValue());
            }
            case 4: {
                return new Double(number.doubleValue() * number2.doubleValue());
            }
        }
        throw new RuntimeException();
    }

    private Object div(Number number, Number number2) {
        switch (this.valType(number)) {
            case 1: {
                return new Integer(number.intValue() / number2.intValue());
            }
            case 2: {
                return new Long(number.longValue() / number2.longValue());
            }
            case 3: {
                return new Float(number.floatValue() / number2.floatValue());
            }
            case 4: {
                return new Double(number.doubleValue() / number2.doubleValue());
            }
        }
        throw new RuntimeException();
    }

    private Object mod(Number number, Number number2) {
        switch (this.valType(number)) {
            case 1: {
                return new Integer(number.intValue() % number2.intValue());
            }
            case 2: {
                return new Long(number.longValue() % number2.longValue());
            }
            case 3: {
                return new Float(number.floatValue() % number2.floatValue());
            }
            case 4: {
                return new Double(number.doubleValue() % number2.doubleValue());
            }
        }
        throw new RuntimeException();
    }

    private Object sub(Number number, Number number2) {
        switch (this.valType(number)) {
            case 1: {
                return new Integer(number.intValue() - number2.intValue());
            }
            case 2: {
                return new Long(number.longValue() - number2.longValue());
            }
            case 3: {
                return new Float(number.floatValue() - number2.floatValue());
            }
            case 4: {
                return new Double(number.doubleValue() - number2.doubleValue());
            }
        }
        throw new RuntimeException();
    }

    private Object bitOr(Number number, Number number2) {
        switch (this.valType(number)) {
            case 1: {
                return new Integer(number.intValue() | number2.intValue());
            }
            case 2: {
                return new Long(number.longValue() | number2.longValue());
            }
        }
        throw new RuntimeException();
    }

    private Object bitAnd(Number number, Number number2) {
        switch (this.valType(number)) {
            case 1: {
                return new Integer(number.intValue() & number2.intValue());
            }
            case 2: {
                return new Long(number.longValue() & number2.longValue());
            }
        }
        throw new RuntimeException();
    }

    private Object bitXor(Number number, Number number2) {
        switch (this.valType(number)) {
            case 1: {
                return new Integer(number.intValue() ^ number2.intValue());
            }
            case 2: {
                return new Long(number.longValue() ^ number2.longValue());
            }
        }
        throw new RuntimeException();
    }

    private Object lshift(Number number, Number number2) {
        switch (this.valType(number)) {
            case 1: {
                return new Integer(number.intValue() << number2.intValue());
            }
            case 2: {
                return new Long(number.longValue() << number2.intValue());
            }
        }
        throw new RuntimeException();
    }

    private Object rshift(Number number, Number number2) {
        switch (this.valType(number)) {
            case 1: {
                return new Integer(number.intValue() >> number2.intValue());
            }
            case 2: {
                return new Long(number.longValue() >> number2.intValue());
            }
        }
        throw new RuntimeException();
    }

    private Expr foldZero(Expr.Binary binary) {
        switch (binary.id) {
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 43: 
            case 44: {
                return binary.lhs;
            }
        }
        switch (binary.id) {
            case 37: 
            case 40: {
                return binary.rhs;
            }
        }
        if (binary.id == 41) {
            throw this.err("Divide by zero", binary.loc);
        }
        return binary;
    }

    private int valType(Object object) {
        if (object instanceof Integer) {
            return 1;
        }
        if (object instanceof Long) {
            return 2;
        }
        if (object instanceof Float) {
            return 3;
        }
        if (object instanceof Double) {
            return 4;
        }
        return -1;
    }
}

