/*
 * Decompiled with CFR 0.152.
 */
package sedonac.parser;

import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import sedona.Buf;
import sedona.util.TextUtil;
import sedonac.Compiler;
import sedonac.CompilerException;
import sedonac.CompilerSupport;
import sedonac.Location;
import sedonac.parser.Token;

public class Tokenizer
extends CompilerSupport {
    static final byte[] charMap;
    static final int ID_START = 1;
    static final int ID_CHAR = 2;
    static final int SPACE = 4;
    static final int DIGIT = 8;
    static final int HEX = 16;
    String filename;
    char[] buf;
    int pos;
    int cur;
    int peek;
    int line;
    int col;
    boolean doc;
    Token last = new Token(new Location(null, 0, 0), 0);

    public static char[] readFile(File file) {
        Location location = new Location(file);
        try {
            return Tokenizer.readFile(location, new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new CompilerException("Source file not found", location, fileNotFoundException);
        }
    }

    public static char[] readFile(Location location, InputStream inputStream) {
        BufferedReader bufferedReader = null;
        try {
            String string;
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            while ((string = bufferedReader.readLine()) != null) {
                charArrayWriter.write(string);
                charArrayWriter.write(10);
            }
            char[] cArray = charArrayWriter.toCharArray();
            return cArray;
        }
        catch (IOException iOException) {
            throw new CompilerException("Cannot read source file", location, iOException);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public Tokenizer(Compiler compiler, String string, char[] cArray) {
        super(compiler);
        this.filename = string;
        this.buf = cArray;
        this.pos = 0;
        this.line = 1;
        this.col = -1;
        this.doc = compiler != null ? compiler.doc : false;
        this.consume();
        this.consume();
    }

    public Token[] tokenize() {
        ArrayList<Token> arrayList = new ArrayList<Token>(1024);
        while (true) {
            Token token;
            if ((token = this.next(arrayList)) == null) {
                continue;
            }
            arrayList.add(token);
            if (token.type == 0) break;
        }
        return arrayList.toArray(new Token[arrayList.size()]);
    }

    private Token next(ArrayList arrayList) {
        while (true) {
            if (this.isSpace(this.cur)) {
                this.consume();
                continue;
            }
            if (this.cur == 47 && this.peek == 47) {
                this.lineComment();
                continue;
            }
            if (this.cur == 47 && this.peek == 42) {
                this.blockComment();
                continue;
            }
            if (this.cur != 42 || this.peek != 42) break;
            if (this.doc) {
                return this.docComment();
            }
            this.lineComment();
        }
        if (this.isIdStart(this.cur)) {
            return this.idOrKeyword();
        }
        if (this.isDigit(this.cur)) {
            return this.numberLiteral();
        }
        if (this.cur == 39) {
            return this.charLiteral();
        }
        if (this.cur == 34) {
            this.strLiteral(arrayList);
            return null;
        }
        Token token = this.symbol();
        if (token != null) {
            return token;
        }
        if (this.cur < 0) {
            return new Token(this.location(), 0);
        }
        throw this.err("Unexpected token '" + (char)this.cur + "'");
    }

    private Token idOrKeyword() {
        Location location = this.location();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((char)this.cur);
        this.consume();
        while (this.isIdChar(this.cur)) {
            stringBuffer.append((char)this.consume());
        }
        String string = stringBuffer.toString();
        int n = Token.fromKeyword(string);
        if (n > 0) {
            return new Token(location, n);
        }
        return new Token(location, 1, string);
    }

    private Token numberLiteral() {
        Location location = this.location();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.cur == 48 && this.peek == 120) {
            this.consume();
            this.consume();
            if (this.cur == 91) {
                return this.bufLiteral(location);
            }
            bl2 = true;
            if (!this.isDigit(this.cur) && !this.isHex(this.cur)) {
                throw this.err("Invalid hex literal");
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (this.isDigit(this.cur) || this.cur == 46 || this.cur == 95 || this.cur == 69 || this.cur == 101 || bl2 && this.isHex(this.cur)) {
            if (this.cur == 95) {
                this.consume();
                continue;
            }
            if (this.cur == 46) {
                bl = true;
            }
            if (!(bl2 || this.cur != 69 && this.cur != 101)) {
                bl = true;
                stringBuffer.append((char)this.consume()).append(this.exponentialPart());
                break;
            }
            stringBuffer.append((char)this.consume());
        }
        String string = stringBuffer.toString();
        long l = -1L;
        if (this.cur == 110 && this.peek == 115) {
            this.consume();
            this.consume();
            l = 1L;
        }
        if (this.cur == 109 && this.peek == 115) {
            this.consume();
            this.consume();
            l = 1000000L;
        }
        if (this.cur == 115 && this.peek == 101) {
            this.consume();
            this.consume();
            if (this.cur != 99) {
                throw this.err("Expected 'sec' in Time literal");
            }
            this.consume();
            l = 1000000000L;
        }
        if (this.cur == 109 && this.peek == 105) {
            this.consume();
            this.consume();
            if (this.cur != 110) {
                throw this.err("Expected 'min' in Time literal");
            }
            this.consume();
            l = 60000000000L;
        }
        if (this.cur == 104 && this.peek == 114) {
            this.consume();
            this.consume();
            l = 3600000000000L;
        }
        if (this.cur == 100 && this.peek == 97) {
            this.consume();
            this.consume();
            if (this.cur != 121 || this.peek != 115) {
                throw this.err("Expected 'days' in Time literal");
            }
            this.consume();
            this.consume();
            l = 86400000000000L;
        }
        switch (this.cur) {
            case 70: 
            case 102: {
                this.consume();
                bl = true;
                break;
            }
            case 68: 
            case 100: {
                this.consume();
                bl = true;
                bl3 = true;
                break;
            }
            case 76: 
            case 108: {
                this.consume();
                bl3 = true;
                if (!bl) break;
                throw this.err("Type mismatch. Cannot convert from floating point number to long: " + string + "L", this.location());
            }
        }
        try {
            long l2;
            if (l >= 0L) {
                if (bl) {
                    l = (long)((double)l * Double.parseDouble(string));
                    return new Token(location, 8, new Long(l));
                }
                return new Token(location, 8, new Long(l *= Long.parseLong(string)));
            }
            if (bl) {
                if (bl3) {
                    return new Token(location, 6, new Double(string));
                }
                return new Token(location, 5, new Float(string));
            }
            if (bl2) {
                if (string.length() > 16 || !bl3 && string.length() > 8) {
                    throw this.err("Invalid range for int/long: 0x" + string, this.location());
                }
                l2 = TextUtil.parseHexLong((String)string);
                if (!bl3 && l2 > 0xFFFFFFFFL) {
                    throw this.err("Invalid range for int: 0x" + string, this.location());
                }
            } else {
                l2 = Long.parseLong(string);
                if (!(bl3 || l2 >= Integer.MIN_VALUE && 0x80000000L >= l2)) {
                    throw this.err("Invalid range for int: " + string, this.location());
                }
            }
            if (bl3) {
                return new Token(location, 4, new Long(l2));
            }
            return new Token(location, 3, new Integer((int)l2));
        }
        catch (CompilerException compilerException) {
            throw compilerException;
        }
        catch (Exception exception) {
            throw this.err("Invalid number: " + string, this.location());
        }
    }

    private String exponentialPart() {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.cur == 95) {
            this.consume();
        }
        if (this.cur == 43 || this.cur == 45) {
            stringBuffer.append((char)this.consume());
        }
        while (this.cur == 95 || this.isDigit(this.cur)) {
            if (this.cur == 95) {
                this.consume();
                continue;
            }
            stringBuffer.append((char)this.consume());
        }
        return stringBuffer.toString();
    }

    private Token charLiteral() {
        int n;
        Location location = this.location();
        this.consume();
        if (this.cur == 92) {
            n = this.escape();
        } else {
            n = this.cur;
            this.consume();
        }
        if (this.cur != 39) {
            throw this.err("Invalid character literal " + this.cur);
        }
        this.consume();
        return new Token(location, 3, new Integer(n));
    }

    private void strLiteral(ArrayList arrayList) {
        Location location = this.location();
        this.consume();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        while (true) {
            if (this.cur == 34) break;
            if (this.cur == 10) {
                throw this.err("Unexpected end of string literal");
            }
            if (this.cur == 36) {
                if (!bl) {
                    bl = true;
                    arrayList.add(new Token(this.location(), 44));
                }
                if (!this.strInterpolation(location, arrayList, stringBuffer.toString())) {
                    arrayList.add(new Token(this.location(), 45));
                    return;
                }
                stringBuffer.setLength(0);
                location = this.location();
                continue;
            }
            if (this.cur == 92) {
                stringBuffer.append((char)this.escape());
                continue;
            }
            stringBuffer.append((char)this.cur);
            this.consume();
        }
        this.consume();
        arrayList.add(new Token(location, 7, stringBuffer.toString()));
        if (bl) {
            arrayList.add(new Token(this.location(), 45));
        }
    }

    private boolean strInterpolation(Location location, ArrayList arrayList, String string) {
        this.consume();
        arrayList.add(new Token(location, 7, string));
        arrayList.add(new Token(this.location(), 14));
        if (this.cur == 123) {
            arrayList.add(new Token(this.location(), 44));
            this.consume();
            while (true) {
                if (this.cur == 34) {
                    throw this.err("Unexpected end of string, missing }");
                }
                Token token = this.next(arrayList);
                if (token.type == 41) break;
                arrayList.add(token);
            }
            arrayList.add(new Token(this.location(), 45));
        } else {
            Token token = this.next(arrayList);
            if (token.type != 1) {
                throw this.err("Expected identifier after $");
            }
            arrayList.add(token);
            while (this.cur == 46) {
                arrayList.add(this.next(arrayList));
                token = this.next(arrayList);
                if (token.type != 1) {
                    throw this.err("Expected identifier");
                }
                arrayList.add(token);
            }
        }
        if (this.cur == 34) {
            this.consume();
            return false;
        }
        arrayList.add(new Token(this.location(), 14));
        return true;
    }

    private int escape() {
        if (this.cur != 92) {
            throw new IllegalStateException();
        }
        this.consume();
        switch (this.cur) {
            case 48: {
                this.consume();
                return 0;
            }
            case 110: {
                this.consume();
                return 10;
            }
            case 114: {
                this.consume();
                return 13;
            }
            case 116: {
                this.consume();
                return 9;
            }
            case 34: {
                this.consume();
                return 34;
            }
            case 39: {
                this.consume();
                return 39;
            }
            case 92: {
                this.consume();
                return 92;
            }
            case 36: {
                this.consume();
                return 36;
            }
        }
        throw this.err("Invalid escape sequence " + (char)this.cur);
    }

    private Token bufLiteral(Location location) {
        Buf buf = new Buf();
        if (this.consume() != 91) {
            throw new IllegalStateException();
        }
        while (this.cur != 93) {
            if (this.isSpace(this.cur)) {
                this.consume();
                continue;
            }
            if (this.cur == 47 && this.peek == 47) {
                this.lineComment();
                continue;
            }
            if (this.cur == 47 && this.peek == 42) {
                this.blockComment();
                continue;
            }
            if (this.cur == 42 && this.peek == 42) {
                this.lineComment();
                continue;
            }
            int n = this.nibble() << 4 | this.nibble();
            buf.write(n);
        }
        this.consume();
        return new Token(location, 9, buf);
    }

    private int nibble() {
        if (this.isDigit(this.cur) || this.isHex(this.cur)) {
            return TextUtil.hexCharToInt((char)((char)this.consume()));
        }
        throw this.err("Expected hex digit");
    }

    private Token symbol() {
        Location location = this.location();
        switch (this.cur) {
            case 46: {
                this.consume();
                return new Token(location, 10);
            }
            case 44: {
                this.consume();
                return new Token(location, 11);
            }
            case 59: {
                this.consume();
                return new Token(location, 12);
            }
            case 58: {
                this.consume();
                if (this.cur == 58) {
                    this.consume();
                    return new Token(location, 23);
                }
                return new Token(location, 13);
            }
            case 43: {
                this.consume();
                if (this.cur == 43) {
                    this.consume();
                    return new Token(location, 37);
                }
                if (this.cur == 61) {
                    this.consume();
                    return new Token(location, 47);
                }
                return new Token(location, 14);
            }
            case 45: {
                this.consume();
                if (this.cur == 45) {
                    this.consume();
                    return new Token(location, 38);
                }
                if (this.cur == 61) {
                    this.consume();
                    return new Token(location, 48);
                }
                if (this.cur == 62) {
                    this.consume();
                    return new Token(location, 39);
                }
                return new Token(location, 15);
            }
            case 42: {
                this.consume();
                if (this.cur == 61) {
                    this.consume();
                    return new Token(location, 49);
                }
                return new Token(location, 16);
            }
            case 47: {
                this.consume();
                if (this.cur == 61) {
                    this.consume();
                    return new Token(location, 50);
                }
                return new Token(location, 17);
            }
            case 37: {
                this.consume();
                if (this.cur == 61) {
                    this.consume();
                    return new Token(location, 51);
                }
                return new Token(location, 18);
            }
            case 38: {
                this.consume();
                if (this.cur == 38) {
                    this.consume();
                    return new Token(location, 21);
                }
                if (this.cur == 61) {
                    this.consume();
                    return new Token(location, 52);
                }
                return new Token(location, 19);
            }
            case 124: {
                this.consume();
                if (this.cur == 124) {
                    this.consume();
                    return new Token(location, 22);
                }
                if (this.cur == 61) {
                    this.consume();
                    return new Token(location, 53);
                }
                return new Token(location, 20);
            }
            case 94: {
                this.consume();
                if (this.cur == 61) {
                    this.consume();
                    return new Token(location, 54);
                }
                return new Token(location, 24);
            }
            case 63: {
                this.consume();
                if (this.cur == 46) {
                    this.consume();
                    return new Token(location, 57);
                }
                if (this.cur == 58) {
                    this.consume();
                    return new Token(location, 58);
                }
                return new Token(location, 25);
            }
            case 33: {
                this.consume();
                if (this.cur == 61) {
                    this.consume();
                    return new Token(location, 32);
                }
                return new Token(location, 26);
            }
            case 126: {
                this.consume();
                return new Token(location, 27);
            }
            case 60: {
                this.consume();
                if (this.cur == 60) {
                    this.consume();
                    if (this.cur == 61) {
                        this.consume();
                        return new Token(location, 55);
                    }
                    return new Token(location, 29);
                }
                if (this.cur == 61) {
                    this.consume();
                    return new Token(location, 36);
                }
                return new Token(location, 35);
            }
            case 62: {
                this.consume();
                if (this.cur == 62) {
                    this.consume();
                    if (this.cur == 61) {
                        this.consume();
                        return new Token(location, 56);
                    }
                    return new Token(location, 30);
                }
                if (this.cur == 61) {
                    this.consume();
                    return new Token(location, 34);
                }
                return new Token(location, 33);
            }
            case 123: {
                this.consume();
                return new Token(location, 40);
            }
            case 125: {
                this.consume();
                return new Token(location, 41);
            }
            case 91: {
                this.consume();
                return new Token(location, 42);
            }
            case 93: {
                this.consume();
                return new Token(location, 43);
            }
            case 40: {
                this.consume();
                return new Token(location, 44);
            }
            case 41: {
                this.consume();
                return new Token(location, 45);
            }
            case 61: {
                this.consume();
                if (this.cur == 61) {
                    this.consume();
                    return new Token(location, 31);
                }
                return new Token(location, 46);
            }
            case 64: {
                this.consume();
                return new Token(location, 28);
            }
        }
        return null;
    }

    private void lineComment() {
        this.consume();
        this.consume();
        while (this.cur != 10 && this.cur > 0) {
            this.consume();
        }
        this.consume();
    }

    private void blockComment() {
        int n = 1;
        this.consume();
        this.consume();
        while (this.cur > 0 && (this.cur != 42 || this.peek != 47 || --n > 0)) {
            if (this.cur == 47 && this.peek == 42) {
                ++n;
            }
            this.consume();
        }
        this.consume();
        this.consume();
    }

    private Token docComment() {
        Location location = this.location();
        while (this.cur == 42) {
            this.consume();
        }
        if (this.cur == 32) {
            this.consume();
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (this.cur > 0) {
            int n = this.cur;
            stringBuffer.append((char)n);
            this.consume();
            if (n != 10) continue;
            while (this.cur == 32 || this.cur == 9) {
                this.consume();
            }
            if (this.cur != 42 || this.peek != 42) break;
            while (this.cur == 42) {
                this.consume();
            }
            if (this.cur != 32 && this.cur != 9) continue;
            this.consume();
        }
        String string = stringBuffer.toString().trim();
        return new Token(location, 2, string);
    }

    @Override
    public CompilerException err(String string) {
        return super.err(string, this.location());
    }

    private Location location() {
        return new Location(this.filename, this.line, this.col);
    }

    private int consume() {
        if (this.cur < 0) {
            throw this.err("Unexpected end of file");
        }
        int n = this.cur;
        this.cur = this.peek;
        int n2 = this.peek = this.pos < this.buf.length ? this.buf[this.pos++] : -1;
        if (this.cur == 10) {
            ++this.line;
            this.col = 0;
        } else {
            ++this.col;
        }
        return n;
    }

    boolean isIdStart(int n) {
        return n > 0 && n < 128 ? (charMap[n] & 1) != 0 : false;
    }

    boolean isIdChar(int n) {
        return n > 0 && n < 128 ? (charMap[n] & 2) != 0 : false;
    }

    boolean isDigit(int n) {
        return n > 0 && n < 128 ? (charMap[n] & 8) != 0 : false;
    }

    boolean isHex(int n) {
        return n > 0 && n < 128 ? (charMap[n] & 0x10) != 0 : false;
    }

    boolean isSpace(int n) {
        return n > 0 && n < 128 ? (charMap[n] & 4) != 0 : false;
    }

    public static void main(String[] stringArray) throws Exception {
        try {
            File file = new File(stringArray[0]);
            Tokenizer tokenizer = new Tokenizer(new Compiler(), file.getName(), Tokenizer.readFile(file));
            Token[] tokenArray = tokenizer.tokenize();
            for (int i = 0; i < tokenArray.length; ++i) {
                Token token = tokenArray[i];
                if (token.type != 0) {
                    String string = token.toString();
                    if (token.type == 1) {
                        string = "@" + string;
                    }
                    System.out.println(TextUtil.padRight((String)(token.loc + ": "), (int)20) + string);
                    continue;
                }
                break;
            }
        }
        catch (CompilerException compilerException) {
            System.out.println(compilerException.toLogString());
        }
    }

    static {
        int n;
        charMap = new byte[128];
        for (n = 65; n <= 90; ++n) {
            Tokenizer.charMap[n] = 3;
        }
        for (n = 97; n <= 122; ++n) {
            Tokenizer.charMap[n] = 3;
        }
        for (n = 48; n <= 57; ++n) {
            Tokenizer.charMap[n] = 10;
        }
        n = 97;
        while (n <= 102) {
            int n2 = n++;
            charMap[n2] = (byte)(charMap[n2] | 0x10);
        }
        n = 65;
        while (n <= 70) {
            int n3 = n++;
            charMap[n3] = (byte)(charMap[n3] | 0x10);
        }
        Tokenizer.charMap[95] = 3;
        Tokenizer.charMap[32] = 4;
        Tokenizer.charMap[9] = 4;
        Tokenizer.charMap[10] = 4;
    }
}

