/*
 * Decompiled with CFR 0.152.
 */
package sedonac.jasm;

import sedona.Facets;
import sedonac.ir.IrField;
import sedonac.ir.IrMethod;
import sedonac.ir.IrSlot;
import sedonac.ir.IrType;
import sedonac.jasm.Assembler;
import sedonac.jasm.AttributeInfo;
import sedonac.jasm.Code;
import sedonac.jasm.FieldInfo;
import sedonac.jasm.JavaClass;
import sedonac.jasm.JavaKitAsm;
import sedonac.jasm.JavaMethodAsm;
import sedonac.jasm.MethodInfo;
import sedonac.jasm.OpCodes;
import sedonac.namespace.Field;
import sedonac.namespace.Method;
import sedonac.namespace.Type;

public class JavaClassAsm
extends Assembler
implements OpCodes {
    JavaKitAsm parent;
    IrType ir;
    IrMethod sInit;
    int assertRef;
    int contextRef;

    JavaClassAsm(JavaKitAsm javaKitAsm, IrType irType) {
        super(JavaClassAsm.jname(irType, false), JavaClassAsm.jname(irType.base(), false), JavaClassAsm.toClassFlags(irType), JavaClassAsm.toInterfaces(irType));
        this.parent = javaKitAsm;
        this.ir = irType;
    }

    static int toClassFlags(IrType irType) {
        int n = 1;
        if (irType.isAbstract()) {
            n |= 0x400;
        }
        return n;
    }

    static String[] toInterfaces(IrType irType) {
        if (irType.qname().equals("sys::Kit")) {
            return new String[]{"sedona/vm/IKit"};
        }
        if (irType.qname().equals("sys::Type")) {
            return new String[]{"sedona/vm/IType"};
        }
        if (irType.qname().equals("sys::Slot")) {
            return new String[]{"sedona/vm/ISlot"};
        }
        if (irType.qname().equals("sys::Component")) {
            return new String[]{"sedona/vm/IComponent"};
        }
        return null;
    }

    public JavaClass assemble() {
        String string;
        Object object;
        for (int i = 0; i < this.ir.declared.length; ++i) {
            object = this.ir.declared[i];
            if (object instanceof IrMethod) {
                this.assembleMethod((IrMethod)object);
                continue;
            }
            this.assembleField((IrField)object);
        }
        this.assembleConstructor();
        this.assembleClassInit();
        if (this.ir.qname.equals("sys::Kit")) {
            this.assembleKitSpecials();
        }
        if (this.ir.qname.equals("sys::Type")) {
            this.assembleTypeSpecials();
        }
        if (this.ir.qname.equals("sys::Slot")) {
            this.assembleSlotSpecials();
        }
        if (this.ir.qname.equals("sys::Component")) {
            this.assembleCompSpecials();
        }
        if (this.ir.qname.equals("sys::Sys")) {
            this.assembleSysSpecials();
        }
        if (this.ir.facets.getb("javaPeer", false)) {
            this.addField(new FieldInfo((Assembler)this, "peer", "Ljava/lang/Object;", 1));
        }
        if ((string = this.ir.loc.toFileName()) != null) {
            this.addAttribute(new AttributeInfo((Assembler)this, "SourceFile", string));
        }
        object = new JavaClass();
        ((JavaClass)object).kitName = this.ir.kit().name();
        ((JavaClass)object).name = this.ir.name();
        ((JavaClass)object).qname = this.ir.qname();
        ((JavaClass)object).classfile = this.compile();
        return object;
    }

    void assembleField(IrField irField) {
        this.addField(new FieldInfo((Assembler)this, irField.name, JavaClassAsm.jsig(irField.type), JavaClassAsm.jflags(irField.flags, irField.facets)));
    }

    void assembleMethod(IrMethod irMethod) {
        if (irMethod.isNative()) {
            return;
        }
        String string = irMethod.name;
        if (irMethod.isStaticInit()) {
            this.sInit = irMethod;
        }
        int n = JavaClassAsm.jflags(irMethod.flags, irMethod.facets);
        if (irMethod.isInstanceInit()) {
            n |= 1;
        }
        if (this.ir.isStr()) {
            n |= 8;
        }
        MethodInfo methodInfo = this.addMethod(new MethodInfo((Assembler)this, string, JavaClassAsm.jsig(irMethod), n));
        if (irMethod.code != null) {
            methodInfo.addAttribute(new JavaMethodAsm(this, irMethod).assemble());
        }
    }

    void assembleConstructor() {
        Code code = new Code(this);
        code.add(42);
        code.add(183, this.cp.method(this.superClass, "<init>", "()V"));
        this.assembleInitFields(code, false);
        code.add(177);
        code.maxLocals = 8;
        code.maxStack = 8;
        MethodInfo methodInfo = this.addMethod(new MethodInfo((Assembler)this, "<init>", "()V", 1));
        methodInfo.addAttribute(code);
    }

    void assembleClassInit() {
        Code code = new Code(this);
        code.maxLocals = 8;
        code.maxStack = 8;
        this.assembleInitFields(code, true);
        code.add(177);
        MethodInfo methodInfo = this.addMethod(new MethodInfo((Assembler)this, "<clinit>", "()V", 9));
        methodInfo.addAttribute(code);
    }

    void assembleInitFields(Code code, boolean bl) {
        for (int i = 0; i < this.ir.declared.length; ++i) {
            IrField irField;
            IrSlot irSlot = this.ir.declared[i];
            if (!irSlot.isField() || (irField = (IrField)irSlot).isStatic() != bl) continue;
            this.assembleInitField(code, irField);
        }
    }

    void assembleInitField(final Code code, final IrField irField) {
        this.assembleInitField(code, irField, false, new Runnable(){

            @Override
            public void run() {
                code.addIntConst(irField.type().arrayLength().val());
            }
        });
    }

    void assembleInitField(Code code, IrField irField, boolean bl, Runnable runnable) {
        Type type;
        if (irField.isDefine() && irField.type().qname().equals("sys::Log")) {
            this.parent.logs.add(irField);
            return;
        }
        if (irField.isDefine() && irField.type.isArray()) {
            this.assembleArrayLiteral(code, irField);
            return;
        }
        if (!irField.isInline()) {
            return;
        }
        if (irField.isConst()) {
            if (irField.qname().equals("sys::Kit.types")) {
                return;
            }
            if (irField.qname().equals("sys::Type.slots")) {
                return;
            }
            throw new IllegalStateException("Unexpected const field: " + irField.qname() + ": " + irField.type());
        }
        if (irField.ctorLengthParam >= 0 && !bl) {
            return;
        }
        if (!irField.isStatic()) {
            code.add(42);
        }
        if ((type = irField.type()).isArray()) {
            Type type2 = type.arrayOf();
            if (type2.isArray()) {
                throw new IllegalStateException("multi-dimension arrays not supported");
            }
            runnable.run();
            JavaClassAsm.assembleNewArray(code, type2);
            if (irField.arrayInit) {
                this.arrayInit(code, type2, runnable);
            }
        } else if (type.isStr()) {
            code.addIntConst(irField.ctorLengthArg.toIntLiteral());
            code.add(184, this.cp.method("sedona/vm/StrRef", "make", "(I)Lsedona/vm/StrRef;"));
        } else {
            int n = this.cp.cls(JavaClassAsm.jname(type, false));
            code.add(187, n);
            code.add(89);
            code.add(183, this.cp.method(n, "<init>", "()V"));
        }
        if (irField.isStatic()) {
            code.add(179, this.fieldRef(irField));
        } else {
            code.add(181, this.fieldRef(irField));
        }
    }

    static void assembleNewArray(Code code, Type type) {
        if (type.isRef()) {
            code.add(189, code.cp.cls(JavaClassAsm.jname(type, true)));
        } else {
            switch (type.id()) {
                case 1: {
                    code.add(188, 4);
                    break;
                }
                case 2: {
                    code.add(188, 8);
                    break;
                }
                case 3: {
                    code.add(188, 9);
                    break;
                }
                case 4: {
                    code.add(188, 10);
                    break;
                }
                case 5: {
                    code.add(188, 11);
                    break;
                }
                case 6: {
                    code.add(188, 6);
                    break;
                }
                case 7: {
                    code.add(188, 7);
                    break;
                }
                default: {
                    throw new IllegalStateException("assembleInitField: " + type);
                }
            }
        }
    }

    void arrayInit(Code code, Type type, Runnable runnable) {
        int n = this.cp.cls(JavaClassAsm.jname(type, false));
        int n2 = this.cp.method(n, "<init>", "()V");
        code.add(77);
        runnable.run();
        code.add(62);
        int n3 = code.add(29);
        code.add(4);
        code.add(100);
        code.add(62);
        code.add(44);
        code.add(29);
        code.add(187, n);
        code.add(89);
        code.add(183, n2);
        code.add(83);
        code.add(29);
        code.branch(154, n3);
        code.add(44);
    }

    void assembleArrayLiteral(Code code, IrField irField) {
        Type type = irField.type.arrayOf();
        Object[] objectArray = irField.define.asArray();
        code.addIntConst(objectArray.length);
        JavaClassAsm.assembleNewArray(code, type);
        block8: for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            code.add(89);
            code.addIntConst(i);
            if (type.isStr()) {
                this.parent.loadStr(code, (String)object);
                code.add(83);
                continue;
            }
            switch (type.id()) {
                case 2: {
                    code.addIntConst((Integer)object);
                    code.add(84);
                    continue block8;
                }
                case 3: {
                    code.addIntConst((Integer)object);
                    code.add(86);
                    continue block8;
                }
                case 4: {
                    code.addIntConst((Integer)object);
                    code.add(79);
                    continue block8;
                }
                case 5: {
                    code.addLongConst((Long)object);
                    code.add(80);
                    continue block8;
                }
                case 6: {
                    code.addFloatConst(((Float)object).floatValue());
                    code.add(81);
                    continue block8;
                }
                case 7: {
                    code.addDoubleConst((Double)object);
                    code.add(82);
                    continue block8;
                }
                default: {
                    throw new IllegalStateException(((Object)type).toString());
                }
            }
        }
        code.add(179, this.fieldRef(irField));
    }

    void assembleKitSpecials() {
        this.addGetter("id", "()I", "id", "B");
        this.addGetter("name", "()Ljava/lang/String;", "_name", "Ljava/lang/String;");
        this.addGetter("types", "()[Lsedona/vm/IType;", "types", "[Lsedona/vm/sys/Type;");
        this.addField(new FieldInfo((Assembler)this, "_name", "Ljava/lang/String;", 1));
    }

    void assembleTypeSpecials() {
        this.addGetter("kit", "()Lsedona/vm/IKit;", "kit", "Lsedona/vm/sys/Kit;");
        this.addGetter("id", "()I", "id", "B");
        this.addGetter("name", "()Ljava/lang/String;", "_name", "Ljava/lang/String;");
        this.addGetter("base", "()Lsedona/vm/IType;", "base", "Lsedona/vm/sys/Type;");
        this.addGetter("slots", "()[Lsedona/vm/ISlot;", "slots", "[Lsedona/vm/sys/Slot;");
        this.addField(new FieldInfo((Assembler)this, "_name", "Ljava/lang/String;", 1));
    }

    void assembleSlotSpecials() {
        this.addGetter("id", "()I", "id", "B");
        this.addGetter("name", "()Ljava/lang/String;", "_name", "Ljava/lang/String;");
        this.addGetter("type", "()Lsedona/vm/IType;", "type", "Lsedona/vm/sys/Type;");
        this.addGetter("flags", "()I", "flags", "B");
        this.addField(new FieldInfo((Assembler)this, "_name", "Ljava/lang/String;", 1));
        this.addField(new FieldInfo((Assembler)this, "accessor", "Lsedona/vm/SlotAccessor;", 1));
        this.addGetter("accessor", "()Lsedona/vm/SlotAccessor;", "accessor", "Lsedona/vm/SlotAccessor;");
    }

    void assembleCompSpecials() {
        Code code = new Code(this);
        code.maxLocals = 2;
        code.maxStack = 2;
        code.add(42);
        code.add(180, this.cp.field("sedona/vm/sys/Component", "type", "Lsedona/vm/sys/Type;"));
        code.add(176);
        this.addMethod(new MethodInfo((Assembler)this, "type", "()Lsedona/vm/IType;", 17, code));
        code = new Code(this);
        code.maxLocals = 2;
        code.maxStack = 2;
        code.add(42);
        code.add(180, this.cp.field("sedona/vm/sys/Component", "slots", "[Lsedona/Value;"));
        code.add(176);
        this.addMethod(new MethodInfo((Assembler)this, "slots", "()[Lsedona/Value;", 17, code));
        code = new Code(this);
        code.maxLocals = 2;
        code.maxStack = 2;
        code.add(42);
        code.add(43);
        code.add(181, this.cp.field("sedona/vm/sys/Component", "slots", "[Lsedona/Value;"));
        code.add(177);
        this.addMethod(new MethodInfo((Assembler)this, "slots", "([Lsedona/Value;)V", 17, code));
        this.addField(new FieldInfo((Assembler)this, "slots", "[Lsedona/Value;", 2));
    }

    void assembleSysSpecials() {
        this.addField(new FieldInfo((Assembler)this, "context", "Lsedona/vm/Context;", 9));
    }

    public int contextRef() {
        if (this.contextRef == 0) {
            this.contextRef = this.cp.field("sedona/vm/sys/Sys", "context", "Lsedona/vm/Context;");
        }
        return this.contextRef;
    }

    void addGetter(String string, String string2, String string3, String string4) {
        Code code = new Code(this);
        code.maxLocals = 2;
        code.maxStack = 2;
        code.add(42);
        code.add(180, this.cp.field(this.thisClass, string3, string4));
        if (string2.equals("()I")) {
            code.add(172);
        } else {
            code.add(176);
        }
        this.addMethod(new MethodInfo((Assembler)this, string, string2, 17, code));
    }

    public int assertRef() {
        if (this.assertRef == 0) {
            this.assertRef = this.cp.method("sedona/vm/VmUtil", "assertOp", "(Z)V");
        }
        return this.assertRef;
    }

    public static String[] jnames(Type[] typeArray) {
        String[] stringArray = new String[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            stringArray[i] = JavaClassAsm.jname(typeArray[i], false);
        }
        return stringArray;
    }

    public static String jname(Type type, boolean bl) {
        if (type == null) {
            return null;
        }
        if (type.isPrimitive()) {
            switch (type.id()) {
                case 0: {
                    return "V";
                }
                case 1: {
                    return "B";
                }
                case 2: {
                    return "B";
                }
                case 3: {
                    return "S";
                }
                case 4: {
                    return "I";
                }
                case 5: {
                    return "J";
                }
                case 6: {
                    return "F";
                }
                case 7: {
                    return "D";
                }
            }
        }
        if (type.isObj()) {
            return "java/lang/Object";
        }
        if (type.isStr()) {
            return bl ? "sedona/vm/StrRef" : "sedona/vm/sys/Str";
        }
        if (type.isArray()) {
            return "[" + JavaClassAsm.jsig(type.arrayOf());
        }
        return JavaClassAsm.jname(type.kit().name(), type.name());
    }

    public static String jname(String string, String string2) {
        return "sedona/vm/" + string + "/" + string2;
    }

    public static String jsig(Type type) {
        String string = JavaClassAsm.jname(type, true);
        if (string.charAt(0) == '[' || string.length() < 5) {
            return string;
        }
        return "L" + string + ";";
    }

    public static String jsig(Method method) {
        Type[] typeArray = method.paramTypes();
        Type type = method.parent();
        boolean bl = method.isStatic();
        boolean bl2 = JavaClassAsm.isJavaNative(method);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        if ((type.isStr() || bl2) && !bl) {
            stringBuffer.append(JavaClassAsm.jsig(type, bl2));
        }
        for (int i = 0; i < typeArray.length; ++i) {
            stringBuffer.append(JavaClassAsm.jsig(typeArray[i], bl2));
        }
        if (bl2) {
            stringBuffer.append("Lsedona/vm/Context;");
        }
        stringBuffer.append(')');
        stringBuffer.append(JavaClassAsm.jsig(method.returnType(), bl2));
        return stringBuffer.toString();
    }

    private static String jsig(Type type, boolean bl) {
        String string = JavaClassAsm.jsig(type);
        if (bl && string.startsWith("L") && !type.isStr()) {
            return "Ljava/lang/Object;";
        }
        return string;
    }

    public int fieldRef(Field field) {
        return JavaClassAsm.fieldRef(this, field);
    }

    public static int fieldRef(Assembler assembler, Field field) {
        int n = assembler.cp.cls(JavaClassAsm.jname(field.parent(), false));
        int n2 = assembler.cp.nt(field.name(), JavaClassAsm.jsig(field.type()));
        return assembler.cp.field(n, n2);
    }

    public int methodRef(Method method) {
        String string = JavaClassAsm.jname(method.parent(), false);
        if (JavaClassAsm.isJavaNative(method)) {
            string = string + "_n";
        }
        int n = this.cp.cls(string);
        int n2 = this.cp.nt(method.name(), JavaClassAsm.jsig(method));
        return this.cp.method(n, n2);
    }

    public static int jflags(int n, Facets facets) {
        int n2 = 1;
        if ((n & 1) != 0) {
            n2 |= 0x400;
        }
        if ((n & 0x1000) != 0) {
            n2 |= 8;
        }
        return n2;
    }

    public static boolean isJavaNative(Method method) {
        return method.isNative() || method.parent().isStr() || method.facets().getb("javaNative");
    }

    public static void echo(Code code, String string) {
        code.add(18, code.cp.string(string));
        code.add(184, code.cp.method("sedona/vm/VmUtil", "echo", "(Ljava/lang/Object;)V"));
    }
}

