/*
 * Decompiled with CFR 0.152.
 */
package sedonac.ir;

import java.util.ArrayList;
import java.util.HashMap;
import sedona.Facets;
import sedonac.Location;
import sedonac.ir.IrAddressable;
import sedonac.ir.IrField;
import sedonac.ir.IrKit;
import sedonac.ir.IrSlot;
import sedonac.ir.IrVTable;
import sedonac.ir.IrWriter;
import sedonac.namespace.ArrayType;
import sedonac.namespace.Kit;
import sedonac.namespace.Slot;
import sedonac.namespace.Type;
import sedonac.namespace.TypeUtil;

public class IrType
implements Type,
IrAddressable {
    public final IrKit kit;
    public final int flags;
    public final String name;
    public final String qname;
    public final Facets facets;
    public int id;
    public int blockIndex;
    public Location loc;
    public Type base;
    public IrSlot[] declared;
    public IrSlot[] reflectiveSlots;
    public ArrayList slots;
    public HashMap slotsByName;
    public int sizeof = -1;
    public IrVTable vtable;

    public IrType(IrKit irKit, int n, String string, Facets facets) {
        this.kit = irKit;
        this.flags = n;
        this.name = string;
        this.qname = irKit.name + "::" + string;
        this.id = TypeUtil.predefinedId(this.qname);
        this.facets = facets;
    }

    @Override
    public Kit kit() {
        return this.kit;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String qname() {
        return this.qname;
    }

    @Override
    public Facets facets() {
        return this.facets;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isRef() {
        return true;
    }

    @Override
    public boolean isNullable() {
        return true;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public Type arrayOf() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrayType.Len arrayLength() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String signature() {
        return this.qname;
    }

    @Override
    public int sizeof() {
        return this.sizeof;
    }

    @Override
    public Type base() {
        return this.base;
    }

    @Override
    public boolean is(Type type) {
        return TypeUtil.is(this, type);
    }

    @Override
    public boolean equals(Object object) {
        return TypeUtil.equals(this, object);
    }

    @Override
    public String toString() {
        return this.signature();
    }

    @Override
    public boolean isObj() {
        return this.qname.equals("sys::Obj");
    }

    @Override
    public boolean isComponent() {
        return this.qname.equals("sys::Component");
    }

    @Override
    public boolean isaComponent() {
        return TypeUtil.isaComponent(this);
    }

    @Override
    public boolean isVirtual() {
        return this.qname.equals("sys::Virtual");
    }

    @Override
    public boolean isaVirtual() {
        return TypeUtil.isaVirtual(this);
    }

    @Override
    public boolean isBuf() {
        return this.qname.equals("sys::Buf");
    }

    @Override
    public boolean isLog() {
        return this.qname.equals("sys::Log");
    }

    @Override
    public boolean isStr() {
        return this.qname.equals("sys::Str");
    }

    @Override
    public boolean isType() {
        return this.qname.equals("sys::Type");
    }

    @Override
    public boolean isBool() {
        return false;
    }

    @Override
    public boolean isByte() {
        return false;
    }

    @Override
    public boolean isFloat() {
        return false;
    }

    @Override
    public boolean isInt() {
        return false;
    }

    @Override
    public boolean isLong() {
        return false;
    }

    @Override
    public boolean isDouble() {
        return false;
    }

    @Override
    public boolean isShort() {
        return false;
    }

    @Override
    public boolean isVoid() {
        return false;
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public boolean isWide() {
        return false;
    }

    @Override
    public boolean isReflective() {
        return TypeUtil.isReflective(this);
    }

    @Override
    public int id() {
        if (this.id < 0) {
            throw new IllegalStateException(this.qname);
        }
        return this.id;
    }

    @Override
    public Slot[] slots() {
        return this.slots.toArray(new Slot[this.slots.size()]);
    }

    @Override
    public Slot[] declared() {
        return this.declared;
    }

    @Override
    public Slot slot(String string) {
        return (Slot)this.slotsByName.get(string);
    }

    @Override
    public void addSlot(Slot slot) {
        String string = slot.name();
        if (this.slotsByName.containsKey(string)) {
            throw new IllegalStateException(slot.qname());
        }
        this.slots.add(slot);
        this.slotsByName.put(string, slot);
    }

    @Override
    public int flags() {
        return this.flags;
    }

    @Override
    public boolean isAbstract() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isFinal() {
        return (this.flags & 4) != 0;
    }

    @Override
    public boolean isConst() {
        return (this.flags & 2) != 0;
    }

    @Override
    public boolean isInternal() {
        return (this.flags & 8) != 0;
    }

    @Override
    public boolean isPublic() {
        return (this.flags & 0x10) != 0;
    }

    public IrField[] instanceFields() {
        ArrayList<IrSlot> arrayList = new ArrayList<IrSlot>();
        for (int i = 0; i < this.declared.length; ++i) {
            IrSlot irSlot = this.declared[i];
            if (!irSlot.isField() || irSlot.isStatic()) continue;
            arrayList.add(irSlot);
        }
        return arrayList.toArray(new IrField[arrayList.size()]);
    }

    @Override
    public int getBlockIndex() {
        return this.blockIndex;
    }

    @Override
    public void setBlockIndex(int n) {
        this.blockIndex = n;
    }

    @Override
    public boolean alignBlockIndex() {
        return true;
    }

    public void dump() {
        IrWriter irWriter = new IrWriter(System.out);
        irWriter.writeType(this);
        irWriter.flush();
    }
}

