/*
 * Decompiled with CFR 0.152.
 */
package sedonac.ir;

import sedona.Buf;
import sedona.util.TextUtil;
import sedonac.Location;
import sedonac.ir.IrField;
import sedonac.ir.IrMethod;
import sedonac.ir.IrSlot;
import sedonac.ir.IrType;
import sedonac.namespace.Slot;
import sedonac.namespace.Type;
import sedonac.scode.SCode;

public class IrOp {
    public static final int STATIC_FIELD = 1;
    public static final int IGNORE_JAVA = 2;
    public int index;
    public int opcode;
    public String arg;
    public Object resolvedArg;
    public int pos;
    public Location loc;
    public Type type;
    public int flags;

    public IrOp(int n, String string) {
        this.opcode = n;
        this.arg = string;
    }

    public IrOp(int n, Type type) {
        this.opcode = n;
        this.arg = type.qname();
        this.resolvedArg = type;
    }

    public IrOp(int n, Slot slot) {
        this.opcode = n;
        this.arg = slot.qname();
        this.resolvedArg = slot;
    }

    public IrOp(int n, int n2) {
        this.opcode = n;
        this.arg = String.valueOf(n2);
    }

    public IrOp(int n) {
        this.opcode = n;
    }

    public IrOp() {
    }

    public int argType() {
        return SCode.argType(this.opcode);
    }

    public boolean isJump() {
        return this.argType() == 14 || this.argType() == 15;
    }

    public boolean isFieldOp() {
        return this.argType() == 12;
    }

    public int argToInt() {
        return Integer.parseInt(this.arg);
    }

    public long argToLong() {
        if (!this.arg.endsWith("L")) {
            throw new IllegalStateException(this + " doesn't end with L");
        }
        return Long.parseLong(this.arg.substring(0, this.arg.length() - 1));
    }

    public float argToFloat() {
        if (this.arg.equals("null")) {
            return Float.NaN;
        }
        if (!this.arg.endsWith("F")) {
            throw new IllegalStateException(this + " doesn't end with F");
        }
        return Float.parseFloat(this.arg.substring(0, this.arg.length() - 1));
    }

    public double argToDouble() {
        if (this.arg.equals("null")) {
            return Double.NaN;
        }
        if (!this.arg.endsWith("D")) {
            throw new IllegalStateException(this + " doesn't end with D");
        }
        return Double.parseDouble(this.arg.substring(0, this.arg.length() - 1));
    }

    public String argToStr() {
        if (!this.arg.startsWith("\"")) {
            throw new IllegalStateException(this + " isn't quoted");
        }
        return TextUtil.fromLiteral((String)this.arg.substring(1, this.arg.length() - 1));
    }

    public Buf argToBuf() {
        return Buf.fromString((String)this.arg);
    }

    public Type argToType() {
        return (Type)this.resolvedArg;
    }

    public IrType argToIrType() {
        return (IrType)this.resolvedArg;
    }

    public Slot argToSlot() {
        return (Slot)this.resolvedArg;
    }

    public IrSlot argToIrSlot() {
        return (IrSlot)this.resolvedArg;
    }

    public IrField argToField() {
        return (IrField)this.resolvedArg;
    }

    public IrMethod argToMethod() {
        return (IrMethod)this.resolvedArg;
    }

    public String opcodeName() {
        return SCode.name(this.opcode);
    }

    public String toString() {
        String string = this.opcodeName();
        if (this.arg != null) {
            string = string + " " + this.arg;
        }
        return string;
    }
}

