/*
 * Decompiled with CFR 0.152.
 */
package sedonac.ast;

import sedonac.Location;
import sedonac.ast.AstVisitor;
import sedonac.ast.FacetDef;
import sedonac.ast.FacetsNode;
import sedonac.ast.TypeDef;
import sedonac.namespace.Slot;
import sedonac.namespace.Type;
import sedonac.namespace.TypeUtil;

public abstract class SlotDef
extends FacetsNode
implements Slot {
    public final TypeDef parent;
    public final String name;
    public final String qname;
    public final int flags;
    private int rtFlags;
    public boolean synthetic;
    public String doc;
    public int declaredId = -1;
    public Slot overrides;

    public SlotDef(Location location, TypeDef typeDef, int n, String string, FacetDef[] facetDefArray) {
        super(location, facetDefArray);
        this.parent = typeDef;
        this.flags = n;
        this.name = string;
        this.qname = typeDef.qname + "." + string;
        this.rtFlags = -1;
    }

    @Override
    public Type parent() {
        return this.parent;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String qname() {
        return this.qname;
    }

    @Override
    public boolean isInherited(Type type) {
        return TypeUtil.isInherited(this, type);
    }

    @Override
    public boolean isReflective() {
        return this.isAction() || this.isProperty();
    }

    @Override
    public int flags() {
        return this.flags;
    }

    @Override
    public boolean isAbstract() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isAction() {
        return (this.flags & 2) != 0;
    }

    @Override
    public boolean isConst() {
        return (this.flags & 4) != 0;
    }

    @Override
    public boolean isDefine() {
        return (this.flags & 8) != 0;
    }

    @Override
    public boolean isInline() {
        return (this.flags & 0x10) != 0;
    }

    @Override
    public boolean isInternal() {
        return (this.flags & 0x20) != 0;
    }

    @Override
    public boolean isNative() {
        return (this.flags & 0x40) != 0;
    }

    @Override
    public boolean isOverride() {
        return (this.flags & 0x80) != 0;
    }

    @Override
    public boolean isPrivate() {
        return (this.flags & 0x200) != 0;
    }

    @Override
    public boolean isProperty() {
        return (this.flags & 0x400) != 0;
    }

    @Override
    public boolean isProtected() {
        return (this.flags & 0x800) != 0;
    }

    @Override
    public boolean isPublic() {
        return (this.flags & 0x100) != 0;
    }

    @Override
    public boolean isStatic() {
        return (this.flags & 0x1000) != 0;
    }

    @Override
    public boolean isVirtual() {
        return (this.flags & 0x2000) != 0;
    }

    @Override
    public int rtFlags() {
        if (this.rtFlags == -1) {
            throw new IllegalStateException("rtFlags not resolved yet");
        }
        return this.rtFlags;
    }

    @Override
    public boolean isRtAction() {
        return (this.rtFlags() & 1) != 0;
    }

    @Override
    public boolean isRtConfig() {
        return (this.rtFlags() & 2) != 0;
    }

    public void setRtFlags(int n) {
        this.rtFlags = n;
    }

    public abstract void walk(AstVisitor var1, int var2);
}

