/*
 * Decompiled with CFR 0.152.
 */
package sedonac.ast;

import sedonac.Location;
import sedonac.ast.AstVisitor;
import sedonac.ast.AstWriter;
import sedonac.ast.Block;
import sedonac.ast.FacetDef;
import sedonac.ast.ParamDef;
import sedonac.ast.SlotDef;
import sedonac.ast.TypeDef;
import sedonac.namespace.Method;
import sedonac.namespace.Namespace;
import sedonac.namespace.NativeId;
import sedonac.namespace.Type;
import sedonac.namespace.TypeUtil;

public class MethodDef
extends SlotDef
implements Method {
    public ParamDef[] params;
    public Type ret;
    public Block code;
    public int maxLocals;
    public NativeId nativeId;
    public int initStmtIndex = 0;

    public MethodDef(Location location, TypeDef typeDef, int n, String string, FacetDef[] facetDefArray, Type type, ParamDef[] paramDefArray, Block block) {
        super(location, typeDef, n, string, facetDefArray);
        this.ret = type;
        this.params = paramDefArray;
        this.code = block;
    }

    @Override
    public boolean isField() {
        return false;
    }

    @Override
    public boolean isMethod() {
        return true;
    }

    @Override
    public Type returnType() {
        return this.ret;
    }

    @Override
    public Type[] paramTypes() {
        Type[] typeArray = new Type[this.params.length];
        for (int i = 0; i < this.params.length; ++i) {
            typeArray[i] = this.params[i].type;
        }
        return typeArray;
    }

    public Type actionType(Namespace namespace) {
        if (this.params.length == 0) {
            return namespace.voidType;
        }
        return this.params[0].type;
    }

    @Override
    public int numParams() {
        return TypeUtil.numParams(this);
    }

    @Override
    public boolean isInstanceInit() {
        return this.name.equals("_iInit");
    }

    @Override
    public boolean isStaticInit() {
        return this.name.equals("_sInit");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isStatic()) {
            stringBuffer.append("static ");
        }
        stringBuffer.append(this.ret).append(' ').append(this.name).append('(');
        for (int i = 0; i < this.params.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.params[i]);
        }
        return stringBuffer.append(')').toString();
    }

    @Override
    public void walk(AstVisitor astVisitor, int n) {
        astVisitor.enterMethod(this);
        this.walkFacets(astVisitor, n);
        this.ret = astVisitor.type(this.ret);
        for (int i = 0; i < this.params.length; ++i) {
            this.params[i].walk(astVisitor);
        }
        if (n >= 3 && this.code != null) {
            this.code.walk(astVisitor);
        }
        astVisitor.exitMethod(this);
    }

    @Override
    public void write(AstWriter astWriter) {
        astWriter.indent().w(this).nl();
        if (this.code != null) {
            this.code.write(astWriter);
        }
    }
}

