/*
 * Decompiled with CFR 0.152.
 */
package sedonac.asm;

import java.util.ArrayList;
import java.util.Stack;
import sedona.Env;
import sedona.util.TextUtil;
import sedonac.CompilerSupport;
import sedonac.Location;
import sedonac.asm.TypeAsm;
import sedonac.ast.Block;
import sedonac.ast.Expr;
import sedonac.ast.ParamDef;
import sedonac.ast.Stmt;
import sedonac.ir.IrOp;
import sedonac.namespace.ArrayType;
import sedonac.namespace.Field;
import sedonac.namespace.Method;
import sedonac.namespace.Slot;
import sedonac.namespace.Type;

public class CodeAsm
extends CompilerSupport {
    public TypeAsm parent;
    public Type self;
    public Location loc;
    public ArrayList code = new ArrayList();
    public Stack loopStack = new Stack();
    ArrayList gotos;

    public CodeAsm(TypeAsm typeAsm) {
        super(typeAsm.compiler);
        this.parent = typeAsm;
        this.self = typeAsm.ast;
    }

    public IrOp[] assemble(Block block) {
        this.block(block);
        this.finish();
        return this.code.toArray(new IrOp[this.code.size()]);
    }

    private void block(Block block) {
        this.loc = block.loc;
        for (int i = 0; i < block.stmts.size(); ++i) {
            this.stmt((Stmt)block.stmts.get(i));
        }
    }

    private void stmt(Stmt stmt) {
        this.loc = stmt.loc;
        stmt.mark = this.mark();
        switch (stmt.id) {
            case 1: {
                this.exprStmt((Stmt.ExprStmt)stmt);
                break;
            }
            case 2: {
                this.localDefStmt((Stmt.LocalDef)stmt);
                break;
            }
            case 4: {
                this.ifStmt((Stmt.If)stmt);
                break;
            }
            case 3: {
                this.returnStmt((Stmt.Return)stmt);
                break;
            }
            case 5: {
                this.forStmt((Stmt.For)stmt);
                break;
            }
            case 6: {
                this.foreachStmt((Stmt.Foreach)stmt);
                break;
            }
            case 7: {
                this.whileStmt((Stmt.While)stmt);
                break;
            }
            case 8: {
                this.doWhileStmt((Stmt.DoWhile)stmt);
                break;
            }
            case 9: {
                this.breakStmt((Stmt.Break)stmt);
                break;
            }
            case 10: {
                this.continueStmt((Stmt.Continue)stmt);
                break;
            }
            case 11: {
                this.assertStmt((Stmt.Assert)stmt);
                break;
            }
            case 12: {
                this.gotoStmt((Stmt.Goto)stmt);
                break;
            }
            case 13: {
                this.switchStmt((Stmt.Switch)stmt);
                break;
            }
            default: {
                throw this.err("CodeAsm not done: " + stmt.getClass().getName(), stmt.loc);
            }
        }
    }

    private void exprStmt(Stmt.ExprStmt exprStmt) {
        Expr expr = exprStmt.expr;
        if (expr.id == 65) {
            Expr.Call call = (Expr.Call)expr;
            String string = call.method.qname();
            if (string.equals("sys::Log.error") || string.equals("sys::Log.warning") || string.equals("sys::Log.message") || string.equals("sys::Log.trace")) {
                this.logStmt(call);
                return;
            }
        }
        this.expr(expr);
    }

    private void localDefStmt(Stmt.LocalDef localDef) {
        if (localDef.init != null) {
            this.expr(localDef.init);
            this.storeLocal(localDef);
        }
    }

    private void returnStmt(Stmt.Return return_) {
        for (int i = 0; i < return_.foreachDepth; ++i) {
            this.op(135);
        }
        if (return_.expr == null) {
            this.op(226);
        } else {
            this.expr(return_.expr);
            if (return_.expr.type.isWide()) {
                this.op(228);
            } else {
                this.op(227);
            }
        }
    }

    private void ifStmt(Stmt.If if_) {
        int n;
        IrOp irOp = null;
        Cond cond = new Cond();
        if (if_.cond instanceof Expr.Cond) {
            this.cond((Expr.Cond)if_.cond, cond);
        } else {
            this.expr(if_.cond);
            cond.falseJumps.add(this.jump(144));
        }
        for (n = 0; n < cond.trueJumps.size(); ++n) {
            this.backpatch((IrOp)cond.trueJumps.get(n));
        }
        this.block(if_.trueBlock);
        if (if_.falseBlock != null && !if_.trueBlock.isExit()) {
            irOp = this.jump(142);
        }
        for (n = 0; n < cond.falseJumps.size(); ++n) {
            this.backpatch((IrOp)cond.falseJumps.get(n));
        }
        if (if_.falseBlock != null) {
            this.block(if_.falseBlock);
        }
        if (irOp != null) {
            this.backpatch(irOp);
        }
    }

    private void whileStmt(Stmt.While while_) {
        int n;
        Loop loop = new Loop(while_);
        this.loopStack.push(loop);
        int n2 = this.mark();
        this.expr(while_.cond);
        IrOp irOp = this.jump(144);
        this.block(while_.block);
        this.jump(142, n2);
        int n3 = this.mark();
        this.backpatch(irOp, n3);
        for (n = 0; n < loop.continues.size(); ++n) {
            this.backpatch((IrOp)loop.continues.get(n), n2);
        }
        for (n = 0; n < loop.breaks.size(); ++n) {
            this.backpatch((IrOp)loop.breaks.get(n), n3);
        }
        this.loopStack.pop();
    }

    private void doWhileStmt(Stmt.DoWhile doWhile) {
        int n;
        Loop loop = new Loop(doWhile);
        this.loopStack.push(loop);
        int n2 = this.mark();
        this.block(doWhile.block);
        int n3 = this.mark();
        this.expr(doWhile.cond);
        this.jump(143, n2);
        int n4 = this.mark();
        for (n = 0; n < loop.continues.size(); ++n) {
            this.backpatch((IrOp)loop.continues.get(n), n3);
        }
        for (n = 0; n < loop.breaks.size(); ++n) {
            this.backpatch((IrOp)loop.breaks.get(n), n4);
        }
        this.loopStack.pop();
    }

    private void forStmt(Stmt.For for_) {
        int n;
        Loop loop = new Loop(for_);
        this.loopStack.push(loop);
        if (for_.init != null) {
            this.stmt(for_.init);
        }
        IrOp irOp = null;
        int n2 = this.mark();
        if (for_.cond != null) {
            this.expr(for_.cond);
            irOp = this.jump(144);
        }
        this.block(for_.block);
        int n3 = this.mark();
        if (for_.update != null) {
            this.expr(for_.update);
        }
        this.jump(142, n2);
        int n4 = this.mark();
        if (irOp != null) {
            this.backpatch(irOp, n4);
        }
        for (n = 0; n < loop.continues.size(); ++n) {
            this.backpatch((IrOp)loop.continues.get(n), n3);
        }
        for (n = 0; n < loop.breaks.size(); ++n) {
            this.backpatch((IrOp)loop.breaks.get(n), n4);
        }
        this.loopStack.pop();
    }

    private void foreachStmt(Stmt.Foreach foreach) {
        int n;
        Loop loop = new Loop(foreach);
        this.loopStack.push(loop);
        ArrayType arrayType = (ArrayType)foreach.array.type;
        this.expr(foreach.array);
        if (foreach.length == null) {
            ArrayType.Len len;
            if (arrayType.len instanceof ArrayType.LiteralLen) {
                len = (ArrayType.LiteralLen)arrayType.len;
                this.loadInt(len.val);
            } else {
                len = (ArrayType.DefineLen)arrayType.len;
                this.op(28, ((ArrayType.DefineLen)len).field);
            }
        } else {
            this.expr(foreach.length);
        }
        this.loadInt(-1);
        int n2 = this.mark();
        IrOp irOp = this.jump(145);
        this.loadArray(arrayType);
        this.storeLocal(foreach.local);
        this.block(foreach.block);
        this.jump(142, n2);
        this.backpatch(irOp);
        int n3 = this.mark();
        this.op(135);
        for (n = 0; n < loop.continues.size(); ++n) {
            this.backpatch((IrOp)loop.continues.get(n), n2);
        }
        for (n = 0; n < loop.breaks.size(); ++n) {
            this.backpatch((IrOp)loop.breaks.get(n), n3);
        }
        this.loopStack.pop();
    }

    private void breakStmt(Stmt.Break break_) {
        if (this.loopStack.size() == 0) {
            throw this.err("Break outside of loop", break_.loc);
        }
        Loop loop = (Loop)this.loopStack.peek();
        IrOp irOp = this.jump(142);
        loop.breaks.add(irOp);
    }

    private void continueStmt(Stmt.Continue continue_) {
        if (this.loopStack.size() == 0) {
            throw this.err("Continue outside of loop", continue_.loc);
        }
        Loop loop = (Loop)this.loopStack.peek();
        if (13 == loop.stmt.id) {
            throw this.err("continue outside of loop", continue_.loc);
        }
        IrOp irOp = this.jump(142);
        loop.continues.add(irOp);
    }

    private void assertStmt(Stmt.Assert assert_) {
        this.expr(assert_.cond);
        this.op(234, assert_.loc.line);
    }

    private void gotoStmt(Stmt.Goto goto_) {
        goto_.op = this.op(142);
        if (this.gotos == null) {
            this.gotos = new ArrayList();
        }
        this.gotos.add(goto_);
    }

    private void switchStmt(Stmt.Switch switch_) {
        int n;
        int n2;
        Loop loop = new Loop(switch_);
        this.loopStack.push(loop);
        Stmt.Case[] caseArray = switch_.cases;
        int[] nArray = this.calculateRange(switch_);
        int n3 = caseArray.length;
        int n4 = nArray[0];
        int n5 = nArray[1];
        int n6 = n5 - n4 + 1;
        if (n6 > 30 && n3 * 3 < n6) {
            this.err("Switch cases too sparse: only " + n3 + " cases from " + n4 + " to " + n5 + "; use if/else", switch_.loc);
            return;
        }
        this.expr(switch_.cond);
        if (n4 != 0) {
            this.op(CodeAsm.loadIntOp(n4));
            this.op(67);
        }
        IrOp irOp = this.op(235);
        int[] nArray2 = new int[n6];
        int n7 = this.mark();
        IrOp irOp2 = null;
        if (switch_.defaultBlock != null) {
            this.block(switch_.defaultBlock);
            if (!switch_.defaultBlock.isExit()) {
                irOp2 = this.jump(142);
            }
        } else {
            irOp2 = this.jump(142);
        }
        IrOp[] irOpArray = new IrOp[n3];
        for (n2 = 0; n2 < caseArray.length; ++n2) {
            Stmt.Case case_ = caseArray[n2];
            n = case_.label.toIntLiteral();
            nArray2[n - n4] = this.mark();
            if (case_.block != null) {
                this.block(case_.block);
            }
            if (n2 != caseArray.length - 1 || case_.block.stmts()[case_.block.stmts().length - 1].id == 9) continue;
            this.op(142, n7);
        }
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            if (nArray2[n2] != 0) continue;
            nArray2[n2] = n7;
        }
        n2 = this.mark();
        if (irOp2 != null) {
            this.backpatch(irOp2, n2);
        }
        for (int i = 0; i < loop.breaks.size(); ++i) {
            this.backpatch((IrOp)loop.breaks.get(i), n2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < nArray2.length; ++n) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(nArray2[n]);
        }
        irOp.arg = stringBuffer.toString();
        this.loopStack.pop();
    }

    private int[] calculateRange(Stmt.Switch switch_) {
        if (switch_.cases.length == 0) {
            return new int[]{0, 0};
        }
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        for (int i = 0; i < switch_.cases.length; ++i) {
            int n3 = switch_.cases[i].label.toIntLiteral();
            if (n3 < n) {
                n = n3;
            }
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return new int[]{n, n2};
    }

    @Override
    public Expr expr(Expr expr) {
        this.loc = expr.loc;
        switch (expr.id) {
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                this.op(CodeAsm.loadLiteral((Expr.Literal)expr));
                break;
            }
            case 4: {
                this.loadLong(((Expr.Literal)expr).asLong());
                break;
            }
            case 7: {
                this.loadLong(((Expr.Literal)expr).asLong());
                break;
            }
            case 5: {
                this.loadFloat(((Expr.Literal)expr).asFloat());
                break;
            }
            case 6: {
                this.loadDouble(((Expr.Literal)expr).asDouble());
                break;
            }
            case 20: {
                this.unary(expr, 72, 92, 105, 116);
                break;
            }
            case 22: {
                this.unary(expr, 71, 91);
                break;
            }
            case 21: {
                this.unary(expr, 131, -1);
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                this.increment((Expr.Unary)expr);
                break;
            }
            case 27: {
                this.or((Expr.Cond)expr, null);
                break;
            }
            case 28: {
                this.and((Expr.Cond)expr, null);
                break;
            }
            case 29: {
                this.binary(expr, 57, 77, 95, 106, 129);
                break;
            }
            case 30: {
                this.binary(expr, 58, 78, 96, 107, 130);
                break;
            }
            case 31: {
                this.binary(expr, 59, 79, 97, 108);
                break;
            }
            case 32: {
                this.binary(expr, 60, 80, 98, 109);
                break;
            }
            case 33: {
                this.binary(expr, 61, 81, 99, 110);
                break;
            }
            case 34: {
                this.binary(expr, 62, 82, 100, 111);
                break;
            }
            case 35: {
                this.binary(expr, 68, 88);
                break;
            }
            case 36: {
                this.binary(expr, 69, 89);
                break;
            }
            case 37: {
                this.binary(expr, 70, 90);
                break;
            }
            case 38: {
                this.binary(expr, 73, 93);
                break;
            }
            case 39: {
                this.binary(expr, 74, 94);
                break;
            }
            case 40: {
                this.binary(expr, 63, 83, 101, 112);
                break;
            }
            case 41: {
                this.binary(expr, 64, 84, 102, 113);
                break;
            }
            case 42: {
                this.binary(expr, 65, 85);
                break;
            }
            case 43: {
                this.binary(expr, 66, 86, 103, 114);
                break;
            }
            case 44: {
                this.binary(expr, 67, 87, 104, 115);
                break;
            }
            case 45: {
                this.assign((Expr.Binary)expr);
                break;
            }
            case 51: {
                this.assign(expr, 68, 88);
                break;
            }
            case 52: {
                this.assign(expr, 69, 89);
                break;
            }
            case 53: {
                this.assign(expr, 70, 90);
                break;
            }
            case 54: {
                this.assign(expr, 73, 93);
                break;
            }
            case 55: {
                this.assign(expr, 74, 94);
                break;
            }
            case 48: {
                this.assign(expr, 63, 83, 101, 112);
                break;
            }
            case 49: {
                this.assign(expr, 64, 84, 102, 113);
                break;
            }
            case 50: {
                this.assign(expr, 65, 85);
                break;
            }
            case 46: {
                this.assign(expr, 66, 86, 103, 114);
                break;
            }
            case 47: {
                this.assign(expr, 67, 87, 104, 115);
                break;
            }
            case 56: {
                this.elvis((Expr.Binary)expr);
                break;
            }
            case 57: {
                this.ternary((Expr.Ternary)expr);
                break;
            }
            case 59: {
                this.loadParam(((Expr.Param)expr).def);
                break;
            }
            case 60: {
                this.loadLocal(((Expr.Local)expr).def);
                break;
            }
            case 61: {
                this.op((int)29).type = this.self;
                break;
            }
            case 62: {
                this.op((int)29).type = this.self.base();
                break;
            }
            case 63: {
                this.loadField((Expr.Field)expr, false);
                break;
            }
            case 64: {
                this.loadIndex((Expr.Index)expr, false);
                break;
            }
            case 65: {
                this.call((Expr.Call)expr);
                break;
            }
            case 66: {
                this.cast((Expr.Cast)expr);
                break;
            }
            case 67: {
                this.initArray((Expr.InitArray)expr);
                break;
            }
            case 68: {
                this.initVirt((Expr.InitVirt)expr);
                break;
            }
            case 69: {
                this.initComp((Expr.InitComp)expr);
                break;
            }
            case 70: {
                break;
            }
            case 71: {
                this.call((Expr.Call)expr);
                break;
            }
            case 73: {
                this.newExpr((Expr.New)expr);
                break;
            }
            case 74: {
                this.deleteExpr((Expr.Delete)expr);
                break;
            }
            default: {
                throw this.err("CodeAsm not done: " + expr.id + " " + expr.toString(), expr.loc);
            }
        }
        return expr;
    }

    public static IrOp loadLiteral(Expr.Literal literal) {
        switch (literal.id) {
            case 1: {
                return CodeAsm.loadIntOp(1);
            }
            case 2: {
                return CodeAsm.loadIntOp(0);
            }
            case 3: {
                return CodeAsm.loadIntOp(literal.asInt());
            }
            case 4: {
                return CodeAsm.loadLongOp(literal.asLong());
            }
            case 5: {
                return CodeAsm.loadFloatOp(literal.asFloat());
            }
            case 6: {
                return CodeAsm.loadDoubleOp(literal.asDouble());
            }
            case 7: {
                return CodeAsm.loadLongOp(literal.asLong());
            }
            case 9: {
                return new IrOp(24, literal.toCodeString());
            }
            case 10: {
                return new IrOp(25, literal.toCodeString());
            }
            case 8: {
                return CodeAsm.loadNull(literal);
            }
            case 11: {
                return new IrOp(26, (Type)literal.value);
            }
            case 12: {
                return new IrOp(27, (Slot)literal.value);
            }
            case 14: {
                return new IrOp(233, literal.toCodeString());
            }
        }
        throw new IllegalStateException(literal.toString());
    }

    public static IrOp loadNull(Expr.Literal literal) {
        if (literal.type.isRef()) {
            return new IrOp(16);
        }
        if (literal.type.isBool()) {
            return new IrOp(17);
        }
        if (literal.type.isFloat()) {
            return new IrOp(18);
        }
        if (literal.type.isDouble()) {
            return new IrOp(19);
        }
        throw new IllegalStateException("Invalid type for null: " + literal.type + " [" + literal.loc + "]");
    }

    public static IrOp loadIntOp(int n) {
        switch (n) {
            case -1: {
                return new IrOp(1);
            }
            case 0: {
                return new IrOp(2);
            }
            case 1: {
                return new IrOp(3);
            }
            case 2: {
                return new IrOp(4);
            }
            case 3: {
                return new IrOp(5);
            }
            case 4: {
                return new IrOp(6);
            }
            case 5: {
                return new IrOp(7);
            }
        }
        if (0 <= n && n <= 255) {
            return new IrOp(8, n);
        }
        if (0 <= n && n <= 65535) {
            return new IrOp(9, n);
        }
        return new IrOp(20, n);
    }

    private void loadInt(int n) {
        this.op(CodeAsm.loadIntOp(n));
    }

    public static IrOp loadLongOp(long l) {
        if (l == 0L) {
            return new IrOp(10);
        }
        if (l == 1L) {
            return new IrOp(11);
        }
        return new IrOp(22, l + "L");
    }

    private void loadLong(long l) {
        if (l == 0L) {
            this.op(10);
            return;
        }
        if (l == 1L) {
            this.op(11);
            return;
        }
        if (-1L <= l && l <= 65535L) {
            this.loadInt((int)l);
            this.op(118);
        } else {
            this.op(CodeAsm.loadLongOp(l));
        }
    }

    public static IrOp loadFloatOp(float f) {
        if (f == 0.0f) {
            return new IrOp(12);
        }
        if (f == 1.0f) {
            return new IrOp(13);
        }
        return new IrOp(21, Env.floatFormat((float)f) + "F");
    }

    private void loadFloat(float f) {
        if (f == 0.0f) {
            this.op(12);
            return;
        }
        if (f == 1.0f) {
            this.op(13);
            return;
        }
        int n = Math.round(f);
        if ((float)n == f && -1 <= n && n <= 65535) {
            this.loadInt(n);
            this.op(117);
        } else {
            this.op(CodeAsm.loadFloatOp(f));
        }
    }

    public static IrOp loadDoubleOp(double d) {
        if (d == 0.0) {
            return new IrOp(14);
        }
        if (d == 1.0) {
            return new IrOp(15);
        }
        return new IrOp(23, Env.doubleFormat((double)d) + "D");
    }

    private void loadDouble(double d) {
        if (d == 0.0) {
            this.op(14);
            return;
        }
        if (d == 1.0) {
            this.op(15);
            return;
        }
        long l = Math.round(d);
        if ((double)l == d && -1L <= l && l <= 65535L) {
            this.loadInt((int)l);
            this.op(119);
        } else {
            this.op(CodeAsm.loadDoubleOp(d));
        }
    }

    private void unary(Expr expr, int n, int n2) {
        this.unary(expr, n, n2, -1, -1);
    }

    private void unary(Expr expr, int n, int n2, int n3, int n4) {
        Expr.Unary unary = (Expr.Unary)expr;
        Type type = unary.operand.type;
        this.expr(unary.operand);
        if (type.isInteger() || type.isBool()) {
            this.op(n);
            return;
        }
        if (type.isLong()) {
            if (n2 > 0) {
                this.op(n2);
                return;
            }
        } else if (type.isFloat()) {
            if (n3 > 0) {
                this.op(n3);
                return;
            }
        } else if (type.isDouble() && n4 > 0) {
            this.op(n4);
            return;
        }
        throw this.err("Invalid unary type: " + ((Object)type).toString(), expr.loc);
    }

    private void binary(Expr expr, int n, int n2) {
        this.binary(expr, n, n2, -1, -1, -1);
    }

    private void binary(Expr expr, int n, int n2, int n3, int n4) {
        this.binary(expr, n, n2, n3, n4, -1);
    }

    private void binary(Expr expr, int n, int n2, int n3, int n4, int n5) {
        Expr.Binary binary = (Expr.Binary)expr;
        Type type = binary.lhs.type;
        this.expr(binary.lhs);
        this.expr(binary.rhs);
        if (type.isArray() && this.pointerArithmetic(binary)) {
            return;
        }
        if (type.isInteger() || type.isBool()) {
            this.op(n);
            return;
        }
        if (type.isLong()) {
            if (n2 > 0) {
                this.op(n2);
                return;
            }
        } else if (type.isFloat()) {
            if (n3 > 0) {
                this.op(n3);
                return;
            }
        } else if (type.isDouble()) {
            if (n4 > 0) {
                this.op(n4);
                return;
            }
        } else if (type.isRef() && n5 > 0) {
            this.op(n5);
            return;
        }
        throw this.err("Invalid operation " + expr, expr.loc);
    }

    private boolean pointerArithmetic(Expr.Binary binary) {
        switch (binary.id) {
            case 43: {
                break;
            }
            case 44: {
                this.op(72);
                break;
            }
            default: {
                return false;
            }
        }
        Type type = binary.type.arrayOf();
        if (type.isRef()) {
            if (type.isConst()) {
                throw new IllegalStateException("Const array ptr arithmetic not supported");
            }
            this.op(207);
        } else {
            switch (type.sizeof()) {
                case 1: {
                    this.op(171);
                    break;
                }
                case 2: {
                    this.op(180);
                    break;
                }
                case 4: {
                    this.op(189);
                    break;
                }
                case 8: {
                    this.op(198);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return true;
    }

    private void cond(Expr.Cond cond, Cond cond2) {
        switch (cond.id) {
            case 27: {
                this.or(cond, cond2);
                break;
            }
            case 28: {
                this.and(cond, cond2);
                break;
            }
            default: {
                throw new IllegalStateException(cond.toString());
            }
        }
    }

    private void or(Expr.Cond cond, Cond cond2) {
        boolean bl;
        boolean bl2 = bl = cond2 == null;
        if (bl) {
            cond2 = new Cond();
        }
        for (int i = 0; i < cond.operands.size(); ++i) {
            Expr expr = (Expr)cond.operands.get(i);
            this.expr(expr);
            if (i < cond.operands.size() - 1) {
                cond2.trueJumps.add(this.jump(143));
                continue;
            }
            cond2.falseJumps.add(this.jump(144));
        }
        if (bl) {
            this.condEnd(cond2);
        }
    }

    private void and(Expr.Cond cond, Cond cond2) {
        boolean bl;
        boolean bl2 = bl = cond2 == null;
        if (bl) {
            cond2 = new Cond();
        }
        for (int i = 0; i < cond.operands.size(); ++i) {
            Expr expr = (Expr)cond.operands.get(i);
            this.expr(expr);
            cond2.falseJumps.add(this.jump(144));
        }
        if (bl) {
            this.condEnd(cond2);
        }
    }

    private void condEnd(Cond cond) {
        for (int i = 0; i < cond.trueJumps.size(); ++i) {
            this.backpatch((IrOp)cond.trueJumps.get(i));
        }
        this.op(3);
        IrOp irOp = this.jump(142);
        for (int i = 0; i < cond.falseJumps.size(); ++i) {
            this.backpatch((IrOp)cond.falseJumps.get(i));
        }
        this.op(2);
        this.backpatch(irOp);
    }

    private void assign(Expr.Binary binary) {
        switch (binary.lhs.id) {
            case 59: {
                this.assignParam(binary);
                break;
            }
            case 60: {
                this.assignLocal(binary);
                break;
            }
            case 63: {
                this.assignField(binary);
                break;
            }
            case 64: {
                this.assignIndex(binary);
                break;
            }
            default: {
                throw this.err("CodeAsm IllegalState: " + binary.lhs.getClass() + "; " + binary, binary.loc);
            }
        }
    }

    private void assign(Expr expr, int n, int n2) {
        this.assign(expr, n, n2, -1, -1);
    }

    private void assign(Expr expr, int n, int n2, int n3, int n4) {
        Expr.Binary binary = (Expr.Binary)expr;
        Expr expr2 = binary.lhs;
        Expr expr3 = binary.rhs;
        Type type = expr2.type;
        boolean bl = type.isWide();
        boolean bl2 = expr.leave;
        switch (expr2.id) {
            case 59: {
                this.loadParam(((Expr.Param)expr2).def);
                break;
            }
            case 60: {
                this.loadLocal(((Expr.Local)expr2).def);
                break;
            }
            case 63: {
                this.loadField((Expr.Field)expr2, true);
                break;
            }
            case 64: {
                this.loadIndex((Expr.Index)expr2, true);
                break;
            }
            default: {
                throw this.err("CodeAsm IllegalState: " + expr, expr.loc);
            }
        }
        this.expr(expr3);
        if (type.isArray()) {
            throw this.err("Pointer arthimetic not supported yet", expr.loc);
        }
        if (type.isInteger() || type.isBool()) {
            this.op(n);
        } else if (type.isLong() && n2 > 0) {
            this.op(n2);
        } else if (type.isFloat() && n3 > 0) {
            this.op(n3);
        } else if (type.isDouble() && n4 > 0) {
            this.op(n4);
        } else {
            throw this.err("CodeAsm IllegalState: " + expr, expr.loc);
        }
        if (bl2) {
            switch (expr2.id) {
                case 59: {
                    IrOp irOp = this.op(bl ? 137 : 136);
                    break;
                }
                case 60: {
                    IrOp irOp = this.op(bl ? 137 : 136);
                    break;
                }
                case 63: {
                    IrOp irOp = this.op(bl ? 140 : 138);
                    break;
                }
                case 64: {
                    IrOp irOp = this.op(bl ? 141 : 139);
                    break;
                }
                default: {
                    throw this.err("CodeAsm IllegalState: " + expr, expr.loc);
                }
            }
            irOp.flags = this.dupDownFlags(expr2);
        }
        switch (expr2.id) {
            case 59: {
                this.storeParam(((Expr.Param)expr2).def);
                break;
            }
            case 60: {
                this.storeLocal(((Expr.Local)expr2).def);
                break;
            }
            case 63: {
                this.storeField((Expr.Field)expr2);
                break;
            }
            case 64: {
                this.storeIndex((ArrayType)((Expr.Index)expr2).target.type);
                break;
            }
            default: {
                throw this.err("CodeAsm IllegalState: " + expr, expr.loc);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void increment(Expr.Unary unary) {
        IrOp irOp;
        Expr expr = unary.operand;
        boolean bl = unary.type.isWide();
        boolean bl2 = unary.leave;
        if (!bl2) {
            if (unary.id == 25) {
                unary.id = 23;
            }
            if (unary.id == 26) {
                unary.id = 24;
            }
        }
        boolean bl3 = unary.id == 25 || unary.id == 26;
        switch (expr.id) {
            case 59: {
                this.loadParam(((Expr.Param)expr).def);
                break;
            }
            case 60: {
                this.loadLocal(((Expr.Local)expr).def);
                break;
            }
            case 63: {
                this.loadField((Expr.Field)expr, true);
                break;
            }
            case 64: {
                this.loadIndex((Expr.Index)expr, true);
                break;
            }
            default: {
                throw this.err("CodeAsm IllegalState: " + unary, unary.loc);
            }
        }
        if (bl3) {
            switch (expr.id) {
                case 59: {
                    irOp = this.op(bl ? 137 : 136);
                    break;
                }
                case 60: {
                    irOp = this.op(bl ? 137 : 136);
                    break;
                }
                case 63: {
                    irOp = this.op(bl ? 140 : 138);
                    break;
                }
                case 64: {
                    irOp = this.op(bl ? 141 : 139);
                    break;
                }
                default: {
                    throw this.err("CodeAsm IllegalState: " + unary, unary.loc);
                }
            }
            irOp.flags = this.dupDownFlags(expr);
        }
        if (unary.id == 23 || unary.id == 25) {
            if (unary.type.isInteger()) {
                this.op(75);
            } else if (unary.type.isLong()) {
                this.op(11);
                this.op(86);
            } else if (unary.type.isFloat()) {
                this.op(13);
                this.op(103);
            } else {
                if (!unary.type.isDouble()) throw this.err("Invalid increment type: " + unary.type, unary.loc);
                this.op(15);
                this.op(114);
            }
        } else if (unary.type.isInteger()) {
            this.op(76);
        } else if (unary.type.isLong()) {
            this.op(11);
            this.op(87);
        } else if (unary.type.isFloat()) {
            this.op(13);
            this.op(104);
        } else {
            if (!unary.type.isDouble()) throw this.err("Invalid decrement type: " + unary.type, unary.loc);
            this.op(15);
            this.op(115);
        }
        if (bl2 && !bl3) {
            switch (expr.id) {
                case 59: {
                    irOp = this.op(bl ? 137 : 136);
                    break;
                }
                case 60: {
                    irOp = this.op(bl ? 137 : 136);
                    break;
                }
                case 63: {
                    irOp = this.op(bl ? 140 : 138);
                    break;
                }
                case 64: {
                    irOp = this.op(bl ? 141 : 139);
                    break;
                }
                default: {
                    throw this.err("CodeAsm IllegalState: " + unary, unary.loc);
                }
            }
            irOp.flags = this.dupDownFlags(expr);
        }
        switch (expr.id) {
            case 59: {
                this.storeParam(((Expr.Param)expr).def);
                return;
            }
            case 60: {
                this.storeLocal(((Expr.Local)expr).def);
                return;
            }
            case 63: {
                this.storeField((Expr.Field)expr);
                return;
            }
            case 64: {
                this.storeIndex((ArrayType)((Expr.Index)expr).target.type);
                return;
            }
            default: {
                throw this.err("CodeAsm IllegalState: " + unary, unary.loc);
            }
        }
    }

    int dupDownFlags(Expr expr) {
        if (expr.id == 63 && ((Expr.Field)expr).field.isStatic()) {
            return 1;
        }
        return 0;
    }

    private void loadParam(ParamDef paramDef) {
        IrOp irOp = null;
        if (paramDef.type.isWide()) {
            irOp = this.op(34, paramDef.index);
        } else {
            switch (paramDef.index) {
                case 0: {
                    irOp = this.op(29);
                    break;
                }
                case 1: {
                    irOp = this.op(30);
                    break;
                }
                case 2: {
                    irOp = this.op(31);
                    break;
                }
                case 3: {
                    irOp = this.op(32);
                    break;
                }
                default: {
                    irOp = this.op(33, paramDef.index);
                }
            }
        }
        irOp.type = paramDef.type;
    }

    private void storeParam(ParamDef paramDef) {
        IrOp irOp = paramDef.type.isWide() ? this.op(36, paramDef.index) : this.op(35, paramDef.index);
        irOp.type = paramDef.type;
    }

    private void assignParam(Expr.Binary binary) {
        boolean bl = binary.type.isWide();
        this.expr(binary.rhs);
        if (binary.leave) {
            this.op(bl ? 137 : 136);
        }
        this.storeParam(((Expr.Param)binary.lhs).def);
    }

    private void loadLocal(Stmt.LocalDef localDef) {
        IrOp irOp = null;
        if (localDef.type.isWide()) {
            irOp = this.op(46, localDef.index);
        } else {
            switch (localDef.index) {
                case 0: {
                    irOp = this.op(37);
                    break;
                }
                case 1: {
                    irOp = this.op(38);
                    break;
                }
                case 2: {
                    irOp = this.op(39);
                    break;
                }
                case 3: {
                    irOp = this.op(40);
                    break;
                }
                case 4: {
                    irOp = this.op(41);
                    break;
                }
                case 5: {
                    irOp = this.op(42);
                    break;
                }
                case 6: {
                    irOp = this.op(43);
                    break;
                }
                case 7: {
                    irOp = this.op(44);
                    break;
                }
                default: {
                    irOp = this.op(45, localDef.index);
                }
            }
        }
        irOp.type = localDef.type;
    }

    private void storeLocal(Stmt.LocalDef localDef) {
        IrOp irOp = null;
        if (localDef.type.isWide()) {
            irOp = this.op(56, localDef.index);
        } else {
            switch (localDef.index) {
                case 0: {
                    irOp = this.op(47);
                    break;
                }
                case 1: {
                    irOp = this.op(48);
                    break;
                }
                case 2: {
                    irOp = this.op(49);
                    break;
                }
                case 3: {
                    irOp = this.op(50);
                    break;
                }
                case 4: {
                    irOp = this.op(51);
                    break;
                }
                case 5: {
                    irOp = this.op(52);
                    break;
                }
                case 6: {
                    irOp = this.op(53);
                    break;
                }
                case 7: {
                    irOp = this.op(54);
                    break;
                }
                default: {
                    irOp = this.op(55, localDef.index);
                }
            }
        }
        irOp.type = localDef.type;
    }

    private void assignLocal(Expr.Binary binary) {
        boolean bl = binary.type.isWide();
        this.expr(binary.rhs);
        if (binary.leave) {
            this.op(bl ? 137 : 136);
        }
        this.storeLocal(((Expr.Local)binary.lhs).def);
    }

    private void loadField(Expr.Field field, boolean bl) {
        Field field2 = field.field;
        Type type = field2.type();
        String string = field.field.qname();
        boolean bl2 = type.isWide();
        if (field2.isDefine()) {
            this.op(28, field2);
            return;
        }
        if (field2.isConst() && field2.isStatic()) {
            if (!type.isRef()) {
                throw this.err("static const can only be used with ref fields", field.loc);
            }
            this.op(210, field2);
            return;
        }
        if (field2.isStatic()) {
            this.op(162);
        } else {
            this.expr(field.target);
        }
        if (bl) {
            this.op(136);
        }
        IrOp irOp = this.preSafeNav(field);
        if (type.isRef()) {
            if (field2.isInline()) {
                this.op(212, field2);
            } else if (field2.isConst()) {
                this.op(208, field2);
            } else {
                this.op(199, field2);
            }
        } else {
            switch (type.sizeof()) {
                case 1: {
                    this.op(163, field2);
                    break;
                }
                case 2: {
                    this.op(172, field2);
                    break;
                }
                case 4: {
                    this.op(181, field2);
                    break;
                }
                case 8: {
                    this.op(190, field2);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        this.postSafeNav(field, irOp);
    }

    private void storeField(Expr.Field field) {
        Field field2 = field.field;
        Type type = field2.type();
        String string = field.field.qname();
        if (field2.isDefine()) {
            throw this.err("Cannot store to a define field", field.loc);
        }
        if (type.isRef()) {
            if (field2.isInline() || field2.isConst()) {
                throw new IllegalStateException();
            }
            this.op(203, field2);
        } else {
            switch (type.sizeof()) {
                case 1: {
                    this.op(167, field2);
                    break;
                }
                case 2: {
                    this.op(176, field2);
                    break;
                }
                case 4: {
                    this.op(185, field2);
                    break;
                }
                case 8: {
                    this.op(194, field2);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    private void assignField(Expr.Binary binary) {
        Expr.Field field = (Expr.Field)binary.lhs;
        Field field2 = field.field;
        boolean bl = field2.type().isWide();
        if (field2.isStatic()) {
            this.op(162);
        } else {
            this.expr(field.target);
        }
        this.expr(binary.rhs);
        if (binary.leave) {
            IrOp irOp = this.op(bl ? 140 : 138);
            irOp.flags = this.dupDownFlags(field);
        }
        this.storeField(field);
    }

    private void loadIndex(Expr.Index index, boolean bl) {
        this.expr(index.target);
        this.expr(index.index);
        if (bl) {
            this.op(137);
        }
        this.loadArray((ArrayType)index.target.type);
    }

    private void loadArray(ArrayType arrayType) {
        Type type = arrayType.of;
        if (type.isRef()) {
            if (arrayType.isConst) {
                this.op((int)211).type = type;
            } else {
                this.op((int)202).type = type;
            }
        } else {
            switch (arrayType.of.sizeof()) {
                case 1: {
                    this.op((int)166).type = type;
                    break;
                }
                case 2: {
                    this.op((int)175).type = type;
                    break;
                }
                case 4: {
                    this.op((int)184).type = type;
                    break;
                }
                case 8: {
                    this.op((int)193).type = type;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    private void storeIndex(ArrayType arrayType) {
        IrOp irOp;
        Type type = arrayType.of;
        if (arrayType.of.isRef()) {
            if (arrayType.isConst) {
                throw new IllegalStateException();
            }
            irOp = this.op(206);
        } else {
            switch (arrayType.of.sizeof()) {
                case 1: {
                    irOp = this.op(170);
                    break;
                }
                case 2: {
                    irOp = this.op(179);
                    break;
                }
                case 4: {
                    irOp = this.op(188);
                    break;
                }
                case 8: {
                    irOp = this.op(197);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        irOp.type = type;
    }

    private void assignIndex(Expr.Binary binary) {
        Expr.Index index = (Expr.Index)binary.lhs;
        boolean bl = index.type.isWide();
        this.expr(index.target);
        this.expr(index.index);
        this.expr(binary.rhs);
        if (binary.leave) {
            this.op(bl ? 141 : 139);
        }
        this.storeIndex((ArrayType)index.target.type);
    }

    private void call(Expr.Call call) {
        int n;
        Method method = call.method;
        String string = method.qname();
        Type type = method.returnType();
        boolean bl = type.isVoid();
        Expr[] exprArray = call.args;
        Expr.Interpolation interpolation = null;
        if (call.target != null) {
            this.expr(call.target);
        }
        IrOp irOp = this.preSafeNav(call);
        if (exprArray.length == 1 && exprArray[0].id == 72) {
            interpolation = (Expr.Interpolation)exprArray[0];
            this.expr(interpolation.first());
        } else {
            for (n = 0; n < exprArray.length; ++n) {
                this.expr(exprArray[n]);
            }
        }
        if (call.id == 71 && call.leave) {
            call.leave = false;
            this.op(call.type.isWide() ? 141 : 139);
        }
        if (method.isVirtual() || method.isOverride()) {
            if (call.target.id == 62) {
                this.op(221, method);
            } else {
                this.op(222, method);
            }
        } else if (method.isNative()) {
            if (bl) {
                this.op(225, method);
            } else if (type.isWide()) {
                this.op(224, method);
            } else {
                this.op(223, method);
            }
        } else {
            this.op(221, method);
        }
        if (interpolation != null) {
            for (n = 1; n < interpolation.parts.size(); ++n) {
                Expr expr = (Expr)interpolation.parts.get(n);
                Method method2 = interpolation.printMethods[n];
                this.expr(expr);
                this.op(221, method2);
            }
        }
        this.postSafeNav(call, irOp);
        if (!call.leave && !bl) {
            this.op(type.isWide() ? 134 : 133);
        }
    }

    private void elvis(Expr.Binary binary) {
        this.expr(binary.lhs);
        this.op(136);
        this.op(16);
        this.op(129);
        IrOp irOp = this.jump(143);
        IrOp irOp2 = this.jump(142);
        this.backpatch(irOp);
        this.op(133);
        this.expr(binary.rhs);
        this.backpatch(irOp2);
    }

    private void ternary(Expr.Ternary ternary) {
        this.expr(ternary.cond);
        IrOp irOp = this.jump(144);
        this.expr(ternary.trueExpr);
        IrOp irOp2 = this.jump(142);
        this.backpatch(irOp);
        this.expr(ternary.falseExpr);
        this.backpatch(irOp2);
    }

    private void cast(Expr.Cast cast) {
        this.expr(cast.target);
        int n = this.castOpcode(cast.target.type, cast.type, cast.loc);
        if (n != 0) {
            this.op(n, cast.type);
        }
    }

    private int castOpcode(Type type, Type type2, Location location) {
        if (type.isInteger()) {
            if (type2.isInteger()) {
                return 0;
            }
            if (type2.isLong()) {
                return 118;
            }
            if (type2.isFloat()) {
                return 117;
            }
            if (type2.isDouble()) {
                return 119;
            }
            if (type2.isRef()) {
                return 0;
            }
        }
        if (type.isLong()) {
            if (type2.isInteger()) {
                return 120;
            }
            if (type2.isLong()) {
                return 0;
            }
            if (type2.isFloat()) {
                return 121;
            }
            if (type2.isDouble()) {
                return 122;
            }
        }
        if (type.isFloat()) {
            if (type2.isInteger()) {
                return 123;
            }
            if (type2.isLong()) {
                return 124;
            }
            if (type2.isFloat()) {
                return 0;
            }
            if (type2.isDouble()) {
                return 125;
            }
        }
        if (type.isDouble()) {
            if (type2.isInteger()) {
                return 126;
            }
            if (type2.isLong()) {
                return 127;
            }
            if (type2.isFloat()) {
                return 128;
            }
            if (type2.isDouble()) {
                return 0;
            }
        }
        if (type.isRef() && type2.isRef()) {
            return 237;
        }
        throw this.err("Cast " + type + " -> " + type2, location);
    }

    private IrOp preSafeNav(Expr.Name name) {
        if (!name.safeNav) {
            return null;
        }
        if (name.target == null) {
            throw this.err("Internal safeNav error", name.loc);
        }
        this.op(136);
        this.op(16);
        this.op(129);
        return this.jump(143);
    }

    private void postSafeNav(Expr.Name name, IrOp irOp) {
        if (!name.safeNav) {
            return;
        }
        if (name instanceof Expr.Call && name.type.isVoid()) {
            IrOp irOp2 = this.jump(142);
            this.backpatch(irOp);
            this.op(133);
            this.backpatch(irOp2);
        } else if (name.type.isPrimitive()) {
            IrOp irOp3 = this.jump(142);
            this.backpatch(irOp);
            this.op(133);
            this.op(this.safeNavLoadZero(name));
            this.backpatch(irOp3);
        } else {
            this.backpatch(irOp);
        }
    }

    private int safeNavLoadZero(Expr expr) {
        Type type = expr.type;
        if (type.isFloat()) {
            return 12;
        }
        if (type.isLong()) {
            return 10;
        }
        if (type.isDouble()) {
            return 14;
        }
        return 2;
    }

    private void newExpr(Expr.New new_) {
        int n = 2;
        if (new_.arrayLength == null) {
            this.op((int)233, (Type)new_.of).flags = n;
        } else {
            if (new_.of.isRef()) {
                this.op((int)28, (Slot)this.ns.sysType.slot((String)"sizeofRef")).flags = n;
            } else {
                this.op((int)233, (Type)new_.of).flags = n;
            }
            this.expr(new_.arrayLength);
            this.op((int)63).flags = n;
        }
        this.op((int)223, (Slot)this.ns.sysType.slot((String)"malloc")).type = new_.type;
    }

    private void deleteExpr(Expr.Delete delete) {
        this.expr(delete.target);
        this.op(225, this.ns.sysType.slot("free"));
    }

    private void initArray(Expr.InitArray initArray) {
        Type type = initArray.field.type.arrayOf();
        this.expr(initArray.field);
        this.expr(initArray.length);
        this.op(233, type.qname());
        this.op(230);
    }

    private void initVirt(Expr.InitVirt initVirt) {
        this.op((int)29).type = this.self;
        this.op(231, initVirt.type.qname());
    }

    private void initComp(Expr.InitComp initComp) {
        this.op((int)29).type = this.self;
        this.op(232, initComp.type.qname());
    }

    private void logStmt(Expr.Call call) {
        Expr expr = call.target;
        if (expr.id != 63 || !((Expr.Field)expr).field.isDefine()) {
            this.err("Logging must be called on a define field", call.loc);
            return;
        }
        Field field = ((Expr.Field)expr).field;
        Method method = this.ns.resolveMethod("sys::Log.is" + TextUtil.capitalize((String)call.method.name()));
        Method method2 = this.ns.resolveMethod("sys::OutStream.nl");
        this.op(28, field);
        this.op(221, method);
        IrOp irOp = this.jump(144);
        call.leave = true;
        this.call(call);
        this.op(221, method2);
        this.op(133);
        this.backpatch(irOp);
    }

    private IrOp op(int n) {
        return this.op(new IrOp(n, (String)null));
    }

    private IrOp op(int n, int n2) {
        return this.op(new IrOp(n, n2));
    }

    private IrOp op(int n, String string) {
        return this.op(new IrOp(n, string));
    }

    private IrOp op(int n, Type type) {
        IrOp irOp = new IrOp(n, type);
        this.op(irOp);
        return irOp;
    }

    private IrOp op(int n, Slot slot) {
        IrOp irOp = new IrOp(n, slot);
        this.op(irOp);
        return irOp;
    }

    private IrOp op(IrOp irOp) {
        irOp.index = this.code.size();
        irOp.loc = this.loc;
        this.code.add(irOp);
        return irOp;
    }

    public IrOp at(int n) {
        return (IrOp)this.code.get(n);
    }

    private int mark() {
        return this.code.size();
    }

    private IrOp jump(int n) {
        return this.jump(n, 0);
    }

    private IrOp jump(int n, int n2) {
        this.op(n, String.valueOf(n2));
        return this.at(this.code.size() - 1);
    }

    private void backpatch(IrOp irOp) {
        this.backpatch(irOp, this.mark());
    }

    private void backpatch(IrOp irOp, int n) {
        irOp.arg = String.valueOf(n);
    }

    private void finish() {
        for (int i = 0; this.gotos != null && i < this.gotos.size(); ++i) {
            Stmt.Goto goto_ = (Stmt.Goto)this.gotos.get(i);
            this.backpatch(goto_.op, goto_.destStmt.mark);
        }
    }

    static class Loop {
        Stmt stmt;
        ArrayList breaks = new ArrayList(4);
        ArrayList continues = new ArrayList(4);

        Loop(Stmt stmt) {
            this.stmt = stmt;
        }
    }

    static class Cond {
        ArrayList trueJumps = new ArrayList(4);
        ArrayList falseJumps = new ArrayList(4);

        Cond() {
        }
    }
}

