/*
 * Decompiled with CFR 0.152.
 */
package sedonac.analysis;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import sedonac.analysis.BasicBlock;
import sedonac.analysis.ControlFlowGraph;

class ReversePostorderIterator
implements Iterator {
    protected HashSet visited = new HashSet();
    protected LinkedList queue = new LinkedList();

    public ReversePostorderIterator(ControlFlowGraph controlFlowGraph) {
        this(controlFlowGraph.entry());
    }

    public ReversePostorderIterator(BasicBlock basicBlock) {
        this.queue.addLast(basicBlock);
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    public Object next() {
        BasicBlock basicBlock = (BasicBlock)this.queue.removeFirst();
        this.visited.add(basicBlock);
        int n = basicBlock.jumpEdges.size();
        for (int i = 0; i < n; ++i) {
            Object e = basicBlock.jumpEdges.get(i);
            if (this.visited.contains(e) || this.queue.contains(e)) continue;
            this.queue.addLast(e);
        }
        return basicBlock;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

