/*
 * Decompiled with CFR 0.152.
 */
package sedonacert.prov;

import java.io.File;
import sedona.Int;
import sedona.Schema;
import sedona.Value;
import sedona.kit.KitDb;
import sedona.kit.KitFile;
import sedona.offline.OfflineApp;
import sedona.offline.OfflineComponent;
import sedona.sox.SoxClient;
import sedona.sox.SoxComponent;
import sedona.util.FileUtil;
import sedona.util.TextUtil;
import sedona.xml.XContent;
import sedona.xml.XElem;
import sedona.xml.XParser;
import sedonacert.prov.ProvTest;

public class ProvAddKit
extends ProvTest {
    public static final String certName = "cert";
    protected File addSax;
    protected File addSab;
    protected File addScodeXml;
    protected File addScodeBin;
    protected Schema schema;
    protected Int intVal;

    public void run() throws Throwable {
        this.init();
        this.createAddSab();
        this.makeScode(this.schema, this.addScodeXml, true);
        this.provision(this.addSab, this.addScodeBin);
        this.getApp(this.prov().addSab);
        this.getScode(this.prov().addScode);
        OfflineApp offlineApp = OfflineApp.decodeAppBinary((File)this.prov().addSab);
        this.verifyEq(offlineApp.schema.key, this.schema.key);
        SoxClient soxClient = this.runner.sox;
        SoxComponent soxComponent = soxClient.loadApp();
        SoxComponent soxComponent2 = soxComponent.child(certName);
        boolean bl = false;
        if (soxComponent2 != null) {
            bl = true;
        }
        this.verify(bl);
        this.verifyEq(soxClient.readProp(soxComponent2, soxComponent2.slot("certInt")), this.intVal);
    }

    private final void init() {
        this.addSax = new File(this.runner.testDir, "addKit.sax");
        this.addSab = new File(this.runner.testDir, "addKit.sab");
        this.addScodeXml = new File(this.runner.testDir, "addKit.xml");
        this.addScodeBin = new File(this.runner.testDir, "addKit.scode");
    }

    private final void createAddSab() throws Throwable {
        this.compile(this.prov().initSab);
        XElem xElem = XParser.make((File)this.getSax(this.prov().initSab)).parse();
        KitFile kitFile = KitDb.matchBest((String)"soxcert");
        if (kitFile == null) {
            this.fail("soxcert kit not in the kit database");
        }
        xElem.elem("schema").addContent((XContent)new XElem("kit").addAttr("name", kitFile.name).addAttr("checksum", TextUtil.intToHexString((int)kitFile.checksum)));
        OfflineApp offlineApp = OfflineApp.decodeAppXml((XElem)xElem);
        boolean bl = false;
        if (offlineApp.schema.kit("soxcert") != null) {
            bl = true;
        }
        this.verify(bl);
        this.schema = offlineApp.schema;
        OfflineComponent offlineComponent = new OfflineComponent(this.schema.type("soxcert::CertComp"), certName);
        this.intVal = Int.make((int)kitFile.checksum);
        offlineComponent.set(offlineComponent.slot("certInt"), (Value)this.intVal);
        offlineApp.add((OfflineComponent)offlineApp, offlineComponent);
        offlineApp.assignIds();
        offlineApp.encodeAppBinary(this.addSab);
    }

    private final File getSax(File file) {
        return new File(this.runner.testDir, FileUtil.getBase((String)file.getName()) + ".sax");
    }

    public ProvAddKit() {
        super("addKit");
    }
}

