/*
 * Decompiled with CFR 0.152.
 */
package sedonacert;

import sedona.Env;
import sedonacert.Runner;

public class Main {
    public static void usage() {
        Main.println("usage:");
        Main.println("  sedonacert [options] <host[:port]> <user> <pass>");
        Main.println("options:");
        Main.println("  -ver         print version info and exit");
        Main.println("  -? -help     print this usage synopsis");
    }

    public static void println(String string) {
        System.out.println(string);
    }

    public static int doMain(String[] stringArray) {
        if (!Env.checkJavaVersion()) {
            return 1;
        }
        if (stringArray.length == 0) {
            Main.usage();
            return 1;
        }
        Runner runner = new Runner();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string.equals("-?") || string.equals("-help")) {
                Main.usage();
                return 1;
            }
            if (string.equals("-ver")) {
                Env.printVersion((String)"Sedona Certification Test Harness");
                return 1;
            }
            if (string.startsWith("-")) {
                Main.println("WARNING: unknown option '" + string + '\'');
            } else if (runner.host == null) {
                int n2 = string.indexOf(58);
                runner.host = string;
                runner.port = 1876;
                if (n2 != -1) {
                    try {
                        if (n2 == 0 || n2 == string.length() - 1) {
                            throw new Exception();
                        }
                        runner.host = string.substring(0, n2);
                        runner.port = Integer.parseInt(string.substring(n2 + 1));
                    }
                    catch (Exception exception) {
                        Main.println("ERROR: invalid host parameter: " + string);
                        Main.usage();
                        return 1;
                    }
                }
            } else if (runner.username == null) {
                runner.username = string;
            } else if (runner.password == null) {
                runner.password = string;
            }
            ++n;
        }
        if (runner.password == null) {
            Main.println("WARNING: not enough arguments");
            Main.usage();
            return 1;
        }
        try {
            return runner.run();
        }
        catch (Exception exception) {
            Main.println("ERROR: Cannot run test harness");
            exception.printStackTrace();
            return 1;
        }
    }

    public static void main(String[] stringArray) {
        try {
            int n = Main.doMain(stringArray);
            System.exit(n);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

