/*
 * Decompiled with CFR 0.152.
 */
package sedonac.test;

import sedonac.test.CompileTest;

public class DeadCodeTest
extends CompileTest {
    private static final String[] neverExits = new String[]{"never exits"};
    private static final String[] line3col1 = new String[]{"3:1:"};

    public void testBasic() {
        this.verify("");
        this.verify("return");
        this.verify("int i=0; i+= 1; return");
    }

    public void testIf() {
        this.verify("if (x<1) {x++}\nif (false){}else{x+=1}\nif (true) {x+=1}\nif (x<1){x+=1}else{x+=2}\nif (x<1) x+=1; else if (x<2) return; else return; x+=100\nif (x<1) return; else if (x<2) x+=2; else return; x+=100\nif (x<1) return; else if (x<2) return; else x+=3; x+=100\n");
        this.verify("if (false)\nx+=1; else x += 2", line3col1);
        this.verify("if (true) x+=1; else\nx+=2", line3col1);
        this.verify("if (true) return\nx+=1", line3col1);
        this.verify("if (x<1) return; else return\nx+=1", line3col1);
        this.verify("if (x<1) return; else if (x<2) return; else return\nx+=1", line3col1);
        this.verify("if (x<100){ if (x<1) return; else if (x<2) return; else if (x<3) return; }\nelse { return }\nx+=1");
        this.verify("if (false){\nif (x<1) return; else if (x<2) return; else if (x<3)\nreturn; }\nelse { return }\nx+=1", new String[]{"3:1 - 4:1", "6:1:"});
        this.verify("if (true){ if (x<1) return; else if (x<2) return; else if (x<3) return; } else\nreturn;\nx+=1", line3col1);
    }

    public void testWhile() {
        this.verify("while(x<10){x+=1} x+=100\nwhile(true){break} x+=100\nwhile(true){if(x==0) break; x+=1} x+=100\nwhile(false){} x+=100\n");
        this.verify("while(true){break;\nx+=1}\nwhile(false){\nif (x<1)\nx+=1}\nwhile(x<1){continue\nx+=1}\nx+=1", new String[]{"3:1:", "5:1 - 6:1", "8:1:"});
        this.verify("while(true){}\nx+=1", line3col1, neverExits);
    }

    public void testDoWhile() {
        this.verify("do { x += 1 } while(x<0);\ndo { x += 1; continue } while(x<0);\ndo { if (x%2==0) break; x+=1 } while(x<0);\n");
        this.verify("do { break }while(\nx<10);\ndo { continue\nx+=1}while(x<10);\ndo { break\nx+=1}while(\nx<10);\n", new String[]{"3:1:", "5:1:", "7:1 - 8:1"});
        this.verify("do {} while(true);\nx+=1", line3col1, neverExits);
    }

    public void testFor() {
        this.verify("for(;;){break} x+=100\nfor(int i=0;;){break} x+=100\nfor(int i=0;;++i){if(i>0) break } x+=100\nfor(int i=0;i<10;++i) {if(i==1) continue} x+=100\nfor(int i=0;i<10;++i) {continue}\nfor(int i=0;i<10;++i){} x+=100\nfor(int i=0;i<10;++i){x+=1} x+=100\n");
        this.verify("for(int i=0; i<10;\n++i) { break }\nfor(int i=0; i<10;\n++i) { break;\nx+=100}\n", new String[]{"3:1:", "5:1:", "6:1:"});
        this.verify("for(;;){}\nx+=100", line3col1, neverExits);
    }

    public void testSwitch() {
        this.verify("switch(x){} x+=100\nswitch(x){case 0: break} x+=100\nswitch(x){default: x+=1} x+=100\nswitch(x){case 0: x+=1; case 1: case 2: x+=2; default: x+=1} x+=100\nswitch(x){case 0: break; default: x+=1} x+=100\nswitch(x){case 0: x+=0} x+=100\n");
        this.verify("switch(x){ case 0: default: break;\nx+=2}\nswitch(x){ default: return }\nx+=3\n", new String[]{"3:1:", "5:1:"});
    }

    public void testGoto() {
        this.verify("goto A; A: goto C; B: x += 1; return; C: goto B\n");
        this.verify("goto A\nx += 1\nx += 2\nA: return\n", new String[]{"3:1 - 4:1"});
        this.verify("goto A\nx += 1\nA: x += 2; goto A\nx += 3\n", new String[]{"3:1:", "5:1:"}, neverExits);
    }

    private void verify(String string) {
        this.verify(string, new String[0], new String[0]);
    }

    private void verify(String string, String[] stringArray) {
        this.verify(string, stringArray, new String[0]);
    }

    private void verify(String string, String[] stringArray, String[] stringArray2) {
        int n;
        this.compile(this.genClass(string));
        this.verify(this.compiler.warnings.size() == stringArray.length);
        for (n = 0; n < stringArray.length; ++n) {
            this.verify(this.compiler.warnings.get(n).toString().indexOf(stringArray[n]) >= 0);
        }
        this.verify(this.compiler.errors().length == stringArray2.length);
        for (n = 0; n < stringArray2.length; ++n) {
            this.verify(this.compiler.errors()[n].toLogString().indexOf(stringArray2[n]) >= 0);
        }
    }

    private String genClass(String string) {
        return new StringBuffer().append("class DeadCode extends Component { int x = 0; void dead() {\n").append(string).append("\n}").append("\n}").toString();
    }
}

