/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.util.ArrayList;
import java.util.HashMap;
import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.Location;
import sedonac.ir.IrMethod;
import sedonac.ir.IrSlot;
import sedonac.ir.IrType;
import sedonac.ir.IrVTable;
import sedonac.scode.SCodeImage;

public class VTableLayout
extends CompilerStep {
    SCodeImage image;
    Location loc;

    public VTableLayout(Compiler compiler) {
        super(compiler);
        this.image = compiler.image;
    }

    @Override
    public void run() {
        this.log.debug("  VTableLayout");
        for (int i = 0; i < this.flat.virtTypes.length; ++i) {
            this.layout(this.flat.virtTypes[i]);
        }
        this.quitIfErrors();
    }

    private void layout(IrType irType) {
        IrMethod irMethod;
        int n;
        Object object;
        ArrayList<IrMethod> arrayList = new ArrayList<IrMethod>();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        if (!irType.isVirtual()) {
            object = ((IrType)irType.base).vtable;
            if (object == null) {
                throw new IllegalStateException(irType.qname());
            }
            for (n = 0; n < object.methods.length; ++n) {
                irMethod = object.methods[n];
                irMethod.vindex = arrayList.size();
                hashMap.put(irMethod.name, new Integer(irMethod.vindex));
                arrayList.add(irMethod);
            }
        }
        object = irType.declared;
        for (n = 0; n < ((IrSlot[])object).length; ++n) {
            if (object[n].isField()) continue;
            irMethod = (IrMethod)object[n];
            if (irMethod.isOverride()) {
                Integer n2 = (Integer)hashMap.get(irMethod.name);
                if (n2 == null) {
                    this.err("Unknown override '" + irMethod.qname + "'");
                    continue;
                }
                irMethod.vindex = n2;
                arrayList.set(irMethod.vindex, irMethod);
                continue;
            }
            if (!irMethod.isVirtual()) continue;
            irMethod.vindex = arrayList.size();
            hashMap.put(irMethod.name, new Integer(irMethod.vindex));
            arrayList.add(irMethod);
        }
        irType.vtable = new IrVTable();
        irType.vtable.methods = arrayList.toArray(new IrMethod[arrayList.size()]);
    }

    private void dump() {
        for (int i = 0; i < this.flat.types.length; ++i) {
            this.dump(this.flat.types[i]);
        }
    }

    private void dump(IrType irType) {
        if (irType.vtable == null) {
            return;
        }
        System.out.println("---- " + irType.qname + " vtable ----");
        for (int i = 0; i < irType.vtable.methods.length; ++i) {
            IrMethod irMethod = irType.vtable.methods[i];
            String string = irMethod == null ? "null" : irMethod.qname;
            System.out.println("  " + i + ":  " + string);
        }
    }
}

