/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.io.IOException;
import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.Location;
import sedonac.ast.KitDef;
import sedonac.ast.TypeDef;
import sedonac.translate.CTranslator;
import sedonac.translate.HTranslator;
import sedonac.translate.Translation;

public class Translate
extends CompilerStep {
    public Translate(Compiler compiler) {
        super(compiler);
    }

    @Override
    public void run() {
        Translation translation = this.compiler.translation;
        this.log.info("  Translate [" + translation.outDir + "]");
        try {
            translation.outDir.mkdirs();
            for (int i = 0; i < translation.kits.length; ++i) {
                KitDef kitDef = translation.kits[i];
                for (int j = 0; j < kitDef.types.length; ++j) {
                    TypeDef typeDef = kitDef.types[j];
                    this.translate(typeDef);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw this.err("Cannot translate", new Location(translation.outDir));
        }
    }

    public void translate(TypeDef typeDef) throws IOException {
        Translation translation = this.compiler.translation;
        if (!translation.target.equals("c")) {
            throw this.err("Unknown translation target language '" + translation.target + "'");
        }
        new HTranslator(this.compiler, typeDef).translate();
        new CTranslator(this.compiler, typeDef).translate();
    }
}

