/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.util.HashMap;
import sedonac.Compiler;
import sedonac.CompilerException;
import sedonac.Location;
import sedonac.ast.Expr;
import sedonac.ast.UnresolvedType;
import sedonac.ir.IrField;
import sedonac.ir.IrFlat;
import sedonac.ir.IrMethod;
import sedonac.ir.IrOp;
import sedonac.ir.IrSlot;
import sedonac.ir.IrType;
import sedonac.namespace.ArrayType;
import sedonac.namespace.Field;
import sedonac.namespace.Slot;
import sedonac.namespace.StubType;
import sedonac.namespace.Type;
import sedonac.steps.ResolveTypes;

public class ResolveIR
extends ResolveTypes {
    HashMap unresolved = new HashMap();
    Location loc;

    public ResolveIR(Compiler compiler) {
        super(compiler);
    }

    @Override
    public void run() {
        int n;
        this.log.debug("  ResolveIR");
        IrFlat irFlat = this.compiler.flat;
        irFlat.preResolve();
        for (n = 0; n < irFlat.types.length; ++n) {
            this.resolveBase(irFlat.types[n]);
        }
        for (n = 0; n < irFlat.fields.length; ++n) {
            this.resolveField(irFlat.fields[n]);
        }
        for (n = 0; n < irFlat.methods.length; ++n) {
            this.resolveMethod(irFlat.methods[n]);
        }
        this.quitIfErrors();
        irFlat.postResolve();
    }

    private void resolveBase(IrType irType) {
        if (irType.base == null) {
            return;
        }
        irType.base = this.resolveType(irType.base);
    }

    private void resolveField(IrField irField) {
        Object object;
        irField.type = this.resolveType(irField.type);
        if (irField.isConst() && irField.type.isArray() && irField.type.arrayOf().isRef()) {
            object = (ArrayType)irField.type;
            irField.type = new ArrayType(((ArrayType)object).loc, ((ArrayType)object).of, ((ArrayType)object).len, true);
        }
        if (irField.ctorLengthArg instanceof Expr.Name) {
            object = ((Expr.Name)irField.ctorLengthArg).name;
            Field field = (Field)this.ns.resolveSlot((String)object);
            if (irField == null) {
                this.err("Unknown ctorLengthArg '" + (String)object + "' for '" + irField.qname + "'", irField.ctorLengthArg.loc);
            } else {
                irField.ctorLengthArg = new Expr.Field(irField.ctorLengthArg.loc, null, field);
            }
        }
    }

    private void resolveMethod(IrMethod irMethod) {
        irMethod.ret = this.resolveType(irMethod.ret);
        for (int i = 0; i < irMethod.params.length; ++i) {
            irMethod.params[i] = this.resolveType(irMethod.params[i]);
        }
        this.resolveOps(irMethod.code);
    }

    private void resolveOps(IrOp[] irOpArray) {
        if (irOpArray == null) {
            return;
        }
        block6: for (int i = 0; i < irOpArray.length; ++i) {
            IrOp irOp = irOpArray[i];
            switch (irOp.argType()) {
                case 10: {
                    irOp.resolvedArg = this.resolveType(irOp.arg);
                    continue block6;
                }
                case 11: {
                    irOp.resolvedArg = this.resolveSlot(irOp.arg, null);
                    continue block6;
                }
                case 13: {
                    irOp.resolvedArg = this.resolveSlot(irOp.arg, IrMethod.class);
                    continue block6;
                }
                case 12: {
                    irOp.resolvedArg = this.resolveSlot(irOp.arg, IrField.class);
                }
            }
        }
    }

    private Type resolveType(Type type) {
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            arrayType.of = this.resolveType(arrayType.of);
            arrayType.len = this.arrayLength(arrayType.len, arrayType.loc);
            return arrayType;
        }
        if (type instanceof StubType) {
            StubType stubType = (StubType)type;
            Type type2 = this.ns.resolveType(stubType.qname);
            if (type2 == null) {
                throw new IllegalStateException(stubType.qname);
            }
            return type2;
        }
        if (type instanceof UnresolvedType) {
            String string = ((UnresolvedType)type).name;
            Type type3 = this.ns.resolveType(string);
            if (type3 != null) {
                return type3;
            }
            if (this.unresolved.put(string, string) == null) {
                this.err("Unresolved type \"" + string + "\"");
            }
        }
        return type;
    }

    private Type resolveType(String string) {
        Type type = this.ns.resolveType(string);
        if (type == null) {
            this.err("Unresolved type \"" + string + "\"");
        }
        return type;
    }

    private IrSlot resolveSlot(String string, Class clazz) {
        Slot slot = this.ns.resolveSlot(string);
        if ((slot == null || clazz != null && slot.getClass() != clazz) && this.unresolved.put(string, string) == null) {
            this.err("Unresolved slot \"" + string + "\"");
        }
        return (IrSlot)slot;
    }

    @Override
    public CompilerException err(String string) {
        return super.err(string, this.loc);
    }
}

