/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.util.ArrayList;
import java.util.Arrays;
import sedonac.Compiler;
import sedonac.CompilerException;
import sedonac.CompilerStep;
import sedonac.SourceFile;
import sedonac.ast.Expr;
import sedonac.ast.TypeDef;
import sedonac.parser.Parser;

public class Parse
extends CompilerStep {
    public Parse(Compiler compiler) {
        super(compiler);
    }

    @Override
    public void run() {
        this.log.info("  Parse [" + this.compiler.sourceFiles.length + " files]");
        SourceFile[] sourceFileArray = this.compiler.sourceFiles;
        ArrayList<TypeDef> arrayList = new ArrayList<TypeDef>(Arrays.asList(this.compiler.ast.types));
        for (int i = 0; i < sourceFileArray.length; ++i) {
            this.parse(sourceFileArray[i], arrayList);
        }
        this.quitIfErrors();
        this.compiler.ast.types = arrayList.toArray(new TypeDef[arrayList.size()]);
    }

    void parse(SourceFile sourceFile, ArrayList arrayList) {
        try {
            TypeDef[] typeDefArray = new Parser(this.compiler, sourceFile.file).parse();
            for (int i = 0; i < typeDefArray.length; ++i) {
                TypeDef typeDef = typeDefArray[i];
                if (sourceFile.testOnly) {
                    typeDef.addFacetDef("testonly", new Expr.Literal(typeDef.loc, this.ns, 1, (Object)Boolean.TRUE));
                }
                arrayList.add(typeDef);
            }
        }
        catch (CompilerException compilerException) {
            if (this.log.isDebug()) {
                this.log.debug("  no log: " + compilerException);
            }
        }
        catch (Exception exception) {
            this.err("Cannot parse", sourceFile.file);
            exception.printStackTrace();
        }
    }
}

