/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import sedona.util.TextUtil;
import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.ir.IrMethod;
import sedonac.ir.IrOp;
import sedonac.ir.IrType;
import sedonac.namespace.Field;
import sedonac.namespace.Slot;
import sedonac.namespace.Type;

public class OptimizeIr
extends CompilerStep {
    public OptimizeIr(Compiler compiler) {
        super(compiler);
    }

    @Override
    public void run() {
        if (!this.compiler.optimize) {
            return;
        }
        this.log.debug("  OptimizeIr");
        IrType[] irTypeArray = this.compiler.ir.types;
        for (int i = 0; i < irTypeArray.length; ++i) {
            IrType irType = irTypeArray[i];
            for (int j = 0; j < irType.declared.length; ++j) {
                if (!(irType.declared[j] instanceof IrMethod)) continue;
                this.optimize((IrMethod)irType.declared[j]);
            }
        }
    }

    void optimize(IrMethod irMethod) {
        if (irMethod.code == null || irMethod.code.length < 2) {
            return;
        }
        while (this.doOptimize(irMethod)) {
        }
    }

    boolean doOptimize(IrMethod irMethod) {
        IrOp[] irOpArray = irMethod.code;
        for (int i = 0; i < irOpArray.length - 1; ++i) {
            IrOp irOp = irOpArray[i];
            IrOp irOp2 = irOpArray[i + 1];
            if (irOp.index != i) {
                throw new IllegalStateException();
            }
            IrOp irOp3 = this.optimizeOp(irMethod, irOp);
            if (irOp3 != null) {
                this.replace(irMethod, i, irOp3);
                return true;
            }
            IrOp irOp4 = this.peephole(irMethod, irOp, irOp2);
            if (irOp4 == null) continue;
            this.join(irMethod, i, irOp4);
            return true;
        }
        return false;
    }

    void replace(IrMethod irMethod, int n, IrOp irOp) {
        irOp.index = n;
        irMethod.code[n] = irOp;
    }

    void join(IrMethod irMethod, int n, IrOp irOp) {
        int n2;
        IrOp[] irOpArray = irMethod.code;
        IrOp[] irOpArray2 = new IrOp[irOpArray.length - 1];
        for (n2 = 0; n2 < irOpArray.length; ++n2) {
            if (n2 < n) {
                irOpArray2[n2] = irOpArray[n2];
                continue;
            }
            if (n2 == n) {
                irOpArray2[n2] = irOp;
                continue;
            }
            if (n2 <= n + 1) continue;
            irOpArray2[n2 - 1] = irOpArray[n2];
        }
        irMethod.code = irOpArray2;
        for (n2 = 0; n2 < irOpArray2.length; ++n2) {
            IrOp irOp2 = irOpArray2[n2];
            irOp2.index = n2;
            if (irOp2.isJump()) {
                int n3 = Integer.parseInt(irOp2.arg);
                if (n3 == n + 1) {
                    throw new IllegalStateException(irOp.toString());
                }
                if (n3 > n) {
                    irOp2.arg = String.valueOf(n3 - 1);
                }
            }
            if (irOp2.opcode != 235) continue;
            StringBuffer stringBuffer = new StringBuffer();
            String[] stringArray = TextUtil.split((String)irOp2.arg, (char)',');
            for (int i = 0; i < stringArray.length; ++i) {
                int n4 = Integer.parseInt(stringArray[i]);
                if (n4 == n + 1) {
                    throw new IllegalStateException(irOp.toString());
                }
                if (n4 > n) {
                    --n4;
                }
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(n4);
            }
            irOp2.arg = stringBuffer.toString();
        }
    }

    IrOp optimizeOp(IrMethod irMethod, IrOp irOp) {
        if (irOp.opcode == 221) {
            String string = irOp.argToSlot().qname();
            if (string.equals("sys::Str.get")) {
                return new IrOp(166);
            }
            if (string.equals("sys::Str.set")) {
                return new IrOp(170);
            }
        }
        return null;
    }

    IrOp peephole(IrMethod irMethod, IrOp irOp, IrOp irOp2) {
        if (irOp.opcode == 237) {
            return irOp2;
        }
        if (irOp.opcode == 212 && this.isFieldAtZero(irOp.arg)) {
            return irOp2;
        }
        if (irOp.opcode == 162 && irOp2.opcode == 212) {
            return new IrOp(218, irOp2.arg);
        }
        if (irOp.opcode == 29) {
            if (irOp2.opcode == 212) {
                return new IrOp(215, irOp2.arg);
            }
            if (irOp2.opcode == 221) {
                return new IrOp(229, irOp2.arg);
            }
        }
        if (irOp2.opcode == 143) {
            if (irOp.opcode == 57) {
                return new IrOp(150, irOp2.arg);
            }
            if (irOp.opcode == 58) {
                return new IrOp(151, irOp2.arg);
            }
            if (irOp.opcode == 61) {
                return new IrOp(154, irOp2.arg);
            }
            if (irOp.opcode == 62) {
                return new IrOp(155, irOp2.arg);
            }
            if (irOp.opcode == 59) {
                return new IrOp(152, irOp2.arg);
            }
            if (irOp.opcode == 60) {
                return new IrOp(153, irOp2.arg);
            }
            if (irOp.opcode == 131) {
                return new IrOp(144, irOp2.arg);
            }
            if (irOp.opcode == 132) {
                return new IrOp(143, irOp2.arg);
            }
        }
        if (irOp2.opcode == 144) {
            if (irOp.opcode == 57) {
                return new IrOp(151, irOp2.arg);
            }
            if (irOp.opcode == 58) {
                return new IrOp(150, irOp2.arg);
            }
            if (irOp.opcode == 61) {
                return new IrOp(153, irOp2.arg);
            }
            if (irOp.opcode == 62) {
                return new IrOp(152, irOp2.arg);
            }
            if (irOp.opcode == 59) {
                return new IrOp(155, irOp2.arg);
            }
            if (irOp.opcode == 60) {
                return new IrOp(154, irOp2.arg);
            }
            if (irOp.opcode == 131) {
                return new IrOp(143, irOp2.arg);
            }
            if (irOp.opcode == 132) {
                return new IrOp(144, irOp2.arg);
            }
        }
        if (irOp.opcode == 2) {
            if (irOp2.opcode == 150) {
                return new IrOp(144, irOp2.arg);
            }
            if (irOp2.opcode == 151) {
                return new IrOp(143, irOp2.arg);
            }
            if (irOp2.opcode == 57) {
                return new IrOp(131);
            }
            if (irOp2.opcode == 58) {
                return new IrOp(132);
            }
        }
        if (irOp.opcode == 16) {
            if (irOp2.opcode == 129) {
                return new IrOp(131);
            }
            if (irOp2.opcode == 130) {
                return new IrOp(132);
            }
        }
        return null;
    }

    boolean isFieldAtZero(String string) {
        Field field = (Field)this.ns.resolveSlot(string);
        Type type = field.parent();
        int n = 0;
        Slot[] slotArray = type.slots();
        for (int i = 0; i < slotArray.length; ++i) {
            Slot slot = slotArray[i];
            if (!slot.isField() || slot.isStatic()) continue;
            ++n;
        }
        return n == 1 && type.base().isObj();
    }
}

