/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.Location;
import sedonac.ast.Expr;
import sedonac.ast.Stmt;
import sedonac.namespace.Field;
import sedonac.namespace.Method;
import sedonac.namespace.Type;
import sedonac.parser.Token;

public class NormalizeExpr
extends CompilerStep {
    public NormalizeExpr(Compiler compiler) {
        super(compiler);
    }

    @Override
    public void run() {
        this.log.debug("  NormalizeExpr");
        this.walkAst(3);
        this.quitIfErrors();
    }

    @Override
    public void enterStmt(Stmt stmt) {
        super.enterStmt(stmt);
        switch (stmt.id) {
            case 13: {
                this.normalizeSwitch((Stmt.Switch)stmt);
            }
        }
    }

    private void normalizeSwitch(Stmt.Switch switch_) {
        if (switch_.defaultBlock != null) {
            int n;
            for (n = switch_.cases.length - 1; n >= 0 && switch_.cases[n].block == null; --n) {
            }
            Stmt.Case[] caseArray = new Stmt.Case[n + 1];
            System.arraycopy(switch_.cases, 0, caseArray, 0, n + 1);
            switch_.cases = caseArray;
        }
    }

    @Override
    public Expr expr(Expr expr) {
        if (this.curMethod == null || this.curMethod.isInstanceInit() || this.curMethod.isStaticInit()) {
            return expr;
        }
        if (expr.isAssign() && this.isProp(((Expr.Binary)expr).lhs)) {
            if (expr.id == 45) {
                return this.assign((Expr.Binary)expr);
            }
            return this.compoundAssign((Expr.Binary)expr);
        }
        if (expr.isIncrDecr() && this.isProp(((Expr.Unary)expr).operand)) {
            return this.incrDecr((Expr.Unary)expr);
        }
        return expr;
    }

    private boolean isProp(Expr expr) {
        return expr.id == 63 && ((Expr.Field)expr).field.isProperty();
    }

    private Expr assign(Expr.Binary binary) {
        Expr.Field field = (Expr.Field)binary.lhs;
        Expr expr = binary.rhs;
        return this.setProp(binary, field, expr);
    }

    private Expr compoundAssign(Expr.Binary binary) {
        Expr.Field field = (Expr.Field)binary.lhs;
        Expr expr = binary.rhs;
        Expr.Binary binary2 = new Expr.Binary(expr.loc, new Token(binary.op.loc, binary.op.assignToBinary()), new Expr.Field(expr.loc, this.dupTarget(field, binary.op), field.field), expr);
        return this.setProp(binary, field, binary2);
    }

    private Expr incrDecr(Expr.Unary unary) {
        Expr.Literal literal;
        if (unary.leave && unary.isPostfix()) {
            this.err("Cannot use postfix " + unary.op + " operator on property assignment with chaining", unary.loc);
            return unary;
        }
        Location location = unary.loc;
        Expr.Field field = (Expr.Field)unary.operand;
        Type type = unary.type;
        if (type.isInteger()) {
            literal = new Expr.Literal(location, this.ns, 3, (Object)new Integer(1));
        } else if (type.isLong()) {
            literal = new Expr.Literal(location, this.ns, 4, (Object)new Long(1L));
        } else if (type.isFloat()) {
            literal = new Expr.Literal(location, this.ns, 5, (Object)new Float(1.0f));
        } else if (type.isDouble()) {
            literal = new Expr.Literal(location, this.ns, 6, (Object)new Double(1.0));
        } else {
            this.err("Cannot use " + unary.op + " operator on " + type, location);
            return unary;
        }
        Expr.Binary binary = new Expr.Binary(location, new Token(location, unary.isIncr() ? 14 : 15), new Expr.Field(location, this.dupTarget(field, unary.op), field.field), literal);
        return this.setProp(unary, field, binary);
    }

    private Expr dupTarget(Expr.Field field, Token token) {
        Expr expr = field.target;
        switch (expr.id) {
            case 59: {
                return expr;
            }
            case 60: {
                return expr;
            }
            case 61: {
                return expr;
            }
        }
        this.err("Cannot use " + token + " operator to assign to property '" + field.field.name() + "' against chained base expr", field.loc);
        return expr;
    }

    private Expr setProp(Expr expr, Expr.Field field, Expr expr2) {
        Location location = expr.loc;
        Field field2 = field.field;
        Expr.Literal literal = new Expr.Literal(location, this.ns, 12, (Object)field2);
        Expr[] exprArray = new Expr[]{literal, expr2};
        Type type = field2.type();
        Method method = null;
        if (type.isBool()) {
            method = this.ns.resolveMethod("sys::Component.setBool");
        }
        if (type.isInteger()) {
            method = this.ns.resolveMethod("sys::Component.setInt");
        }
        if (type.isLong()) {
            method = this.ns.resolveMethod("sys::Component.setLong");
        }
        if (type.isFloat()) {
            method = this.ns.resolveMethod("sys::Component.setFloat");
        }
        if (type.isDouble()) {
            method = this.ns.resolveMethod("sys::Component.setDouble");
        }
        if (method == null) {
            throw this.err("Property doesn't map to setter: " + type.qname(), location);
        }
        Expr.Call call = new Expr.Call(location, 71, field.target, method, exprArray);
        call.type = expr2.type;
        call.leave = expr.leave;
        return call;
    }
}

