/*
 * Decompiled with CFR 0.152.
 */
package sedonac.namespace;

import sedona.Facets;
import sedonac.Location;
import sedonac.namespace.Field;
import sedonac.namespace.Kit;
import sedonac.namespace.Slot;
import sedonac.namespace.Type;
import sedonac.namespace.TypeUtil;

public class ArrayType
implements Type {
    private static Slot[] noSlots = new Slot[0];
    public Type of;
    public Len len;
    public boolean isConst;
    public Location loc;

    public ArrayType(Location location, Type type, Len len, boolean bl) {
        this.loc = location;
        this.of = type;
        this.len = len;
        this.isConst = bl;
    }

    public ArrayType(Location location, Type type, Len len) {
        this(location, type, len, false);
    }

    @Override
    public Kit kit() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String name() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String qname() {
        return this.of.qname() + "[]";
    }

    @Override
    public Facets facets() {
        return Facets.empty;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isRef() {
        return true;
    }

    @Override
    public boolean isNullable() {
        return true;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public Type arrayOf() {
        return this.of;
    }

    @Override
    public Len arrayLength() {
        return this.len;
    }

    @Override
    public Type base() {
        return null;
    }

    @Override
    public boolean is(Type type) {
        return TypeUtil.is(this, type);
    }

    @Override
    public boolean equals(Object object) {
        return TypeUtil.equals(this, object);
    }

    @Override
    public String toString() {
        return this.signature();
    }

    @Override
    public String signature() {
        String string;
        String string2 = string = this.isConst ? "const " : "";
        if (this.len == null) {
            return string + this.of + "[]";
        }
        return string + this.of + "[" + this.len + "]";
    }

    @Override
    public int sizeof() {
        if (this.len == null) {
            throw new IllegalStateException("sizeof unbounded array: " + this);
        }
        if (this.of.isRef()) {
            throw new IllegalStateException("array of refs is variable size: " + this);
        }
        return this.of.sizeof() * this.len.val();
    }

    @Override
    public boolean isObj() {
        return false;
    }

    @Override
    public boolean isComponent() {
        return false;
    }

    @Override
    public boolean isaComponent() {
        return false;
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public boolean isaVirtual() {
        return false;
    }

    @Override
    public boolean isBuf() {
        return false;
    }

    @Override
    public boolean isLog() {
        return false;
    }

    @Override
    public boolean isStr() {
        return false;
    }

    @Override
    public boolean isType() {
        return false;
    }

    @Override
    public boolean isBool() {
        return false;
    }

    @Override
    public boolean isByte() {
        return false;
    }

    @Override
    public boolean isFloat() {
        return false;
    }

    @Override
    public boolean isInt() {
        return false;
    }

    @Override
    public boolean isLong() {
        return false;
    }

    @Override
    public boolean isDouble() {
        return false;
    }

    @Override
    public boolean isShort() {
        return false;
    }

    @Override
    public boolean isVoid() {
        return false;
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public boolean isWide() {
        return false;
    }

    @Override
    public boolean isReflective() {
        return false;
    }

    @Override
    public int id() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Slot[] slots() {
        return noSlots;
    }

    @Override
    public Slot[] declared() {
        return noSlots;
    }

    @Override
    public Slot slot(String string) {
        return null;
    }

    @Override
    public void addSlot(Slot slot) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int flags() {
        return 0;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isConst() {
        return this.isConst;
    }

    @Override
    public boolean isFinal() {
        return true;
    }

    @Override
    public boolean isInternal() {
        return this.of.isInternal();
    }

    @Override
    public boolean isPublic() {
        return this.of.isPublic();
    }

    public boolean isTestOnly() {
        return false;
    }

    public static class DefineLen
    extends Len {
        public Field field;

        public DefineLen(Field field) {
            this.field = field;
        }

        @Override
        public String toString() {
            return this.field.qname();
        }

        @Override
        public int val() {
            return this.field.define().asInt();
        }

        @Override
        protected boolean eq(Len len) {
            return this.field.qname().equals(((DefineLen)len).field.qname());
        }
    }

    public static class UnresolvedLen
    extends Len {
        public String id;

        public UnresolvedLen(String string) {
            this.id = string;
        }

        @Override
        public String toString() {
            return this.id;
        }

        @Override
        public int val() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected boolean eq(Len len) {
            throw new UnsupportedOperationException();
        }
    }

    public static class LiteralLen
    extends Len {
        public int val;

        public LiteralLen(int n) {
            this.val = n;
        }

        @Override
        public String toString() {
            return "" + this.val;
        }

        @Override
        public int val() {
            return this.val;
        }

        @Override
        protected boolean eq(Len len) {
            return this.val == ((LiteralLen)len).val;
        }
    }

    public static abstract class Len {
        public final boolean equals(Object object) {
            if (this.getClass() == object.getClass()) {
                return this.eq((Len)object);
            }
            return false;
        }

        public abstract String toString();

        public abstract int val();

        protected abstract boolean eq(Len var1);
    }
}

