/*
 * Decompiled with CFR 0.152.
 */
package sedonac.jasm;

import sedona.util.TextUtil;
import sedonac.ast.Expr;
import sedonac.ir.IrField;
import sedonac.ir.IrMethod;
import sedonac.ir.IrOp;
import sedonac.jasm.Assembler;
import sedonac.jasm.AttributeInfo;
import sedonac.jasm.Buffer;
import sedonac.jasm.Code;
import sedonac.jasm.JavaClassAsm;
import sedonac.jasm.JavaKitAsm;
import sedonac.jasm.OpCodes;
import sedonac.namespace.Field;
import sedonac.namespace.Method;
import sedonac.namespace.Type;

public class JavaMethodAsm
implements OpCodes {
    public static final int OBJ = 65;
    public static final int BOOL = 90;
    public static final int INT = 73;
    public static final int BYTE = 66;
    public static final int SHORT = 83;
    public static final int FLOAT = 70;
    public static final int LONG = 74;
    public static final int DOUBLE = 68;
    public static final int VOID = 86;
    JavaKitAsm kitAsm;
    JavaClassAsm parent;
    IrMethod ir;
    IrOp prevOp;
    int cur;
    Code code;
    int localOffset;
    Patch patches;
    int maxLocals;
    int maxStack;

    JavaMethodAsm(JavaClassAsm javaClassAsm, IrMethod irMethod) {
        this.kitAsm = javaClassAsm.parent;
        this.parent = javaClassAsm;
        this.ir = irMethod;
        this.code = new Code(javaClassAsm);
        this.localOffset = this.computeLocalOffset();
        this.maxLocals = irMethod.maxLocals * 2 + 10;
        this.maxStack = irMethod.maxStack;
    }

    int computeLocalOffset() {
        int n = this.ir.isStatic() ? 0 : 1;
        for (int i = 0; i < this.ir.params.length; ++i) {
            n += this.ir.params[i].isWide() ? 2 : 1;
        }
        return n;
    }

    Code assemble() {
        if (this.ir.code == null) {
            return null;
        }
        IrOp[] irOpArray = this.ir.code;
        this.prevOp = null;
        this.cur = 0;
        while (this.cur < irOpArray.length) {
            this.assemble(irOpArray[this.cur]);
            this.prevOp = irOpArray[this.cur];
            ++this.cur;
        }
        this.backpatch();
        this.code.maxLocals = this.maxLocals;
        this.code.maxStack = this.maxStack;
        this.code.attributes = new AttributeInfo[]{this.toLineNumTable()};
        return this.code;
    }

    void onReturn() {
        if (!this.ir.isInstanceInit()) {
            return;
        }
        if (this.ir.parent.isStr()) {
            return;
        }
        IrField[] irFieldArray = this.parent.ir.instanceFields();
        for (int i = 0; i < irFieldArray.length; ++i) {
            final IrField irField = irFieldArray[i];
            if (irFieldArray[i].ctorLengthParam < 0) continue;
            this.parent.assembleInitField(this.code, irField, true, new Runnable(){

                @Override
                public void run() {
                    JavaMethodAsm.this.code.add(21, irField.ctorLengthParam);
                }
            });
        }
    }

    void assemble(IrOp irOp) {
        irOp.pos = this.code.code.count;
        if ((irOp.flags & 2) != 0) {
            return;
        }
        switch (irOp.opcode) {
            case 0: {
                break;
            }
            case 1: {
                this.op(2);
                break;
            }
            case 2: {
                this.op(3);
                break;
            }
            case 3: {
                this.op(4);
                break;
            }
            case 4: {
                this.op(5);
                break;
            }
            case 5: {
                this.op(6);
                break;
            }
            case 6: {
                this.op(7);
                break;
            }
            case 7: {
                this.op(8);
                break;
            }
            case 8: {
                this.loadInt(irOp.argToInt());
                break;
            }
            case 9: {
                this.loadInt(irOp.argToInt());
                break;
            }
            case 10: {
                this.op(9);
                break;
            }
            case 11: {
                this.op(10);
                break;
            }
            case 12: {
                this.op(11);
                break;
            }
            case 13: {
                this.op(12);
                break;
            }
            case 14: {
                this.op(14);
                break;
            }
            case 15: {
                this.op(15);
                break;
            }
            case 16: {
                this.op(1);
                break;
            }
            case 17: {
                this.op(5);
                break;
            }
            case 18: {
                this.loadFloat(Float.NaN);
                break;
            }
            case 19: {
                this.loadDouble(Double.NaN);
                break;
            }
            case 20: {
                this.loadInt(irOp.argToInt());
                break;
            }
            case 21: {
                this.loadFloat(irOp.argToFloat());
                break;
            }
            case 22: {
                this.loadLong(irOp.argToLong());
                break;
            }
            case 23: {
                this.loadDouble(irOp.argToDouble());
                break;
            }
            case 24: {
                this.kitAsm.loadStr(this.code, irOp.argToStr());
                break;
            }
            case 25: {
                this.kitAsm.loadBuf(this.code, irOp.argToBuf());
                break;
            }
            case 26: {
                this.kitAsm.loadType(this.code, irOp.argToType());
                break;
            }
            case 27: {
                this.kitAsm.loadSlot(this.code, irOp.argToSlot());
                break;
            }
            case 28: {
                this.loadDefine(irOp);
                break;
            }
            case 29: {
                this.loadParam(0, irOp);
                break;
            }
            case 30: {
                this.loadParam(1, irOp);
                break;
            }
            case 31: {
                this.loadParam(2, irOp);
                break;
            }
            case 32: {
                this.loadParam(3, irOp);
                break;
            }
            case 33: {
                this.loadParam(irOp.argToInt(), irOp);
                break;
            }
            case 34: {
                this.loadParam(irOp.argToInt(), irOp);
                break;
            }
            case 35: {
                this.storeParam(irOp.argToInt(), irOp);
                break;
            }
            case 36: {
                this.storeParam(irOp.argToInt(), irOp);
                break;
            }
            case 37: {
                this.loadLocal(0, irOp);
                break;
            }
            case 38: {
                this.loadLocal(1, irOp);
                break;
            }
            case 39: {
                this.loadLocal(2, irOp);
                break;
            }
            case 40: {
                this.loadLocal(3, irOp);
                break;
            }
            case 41: {
                this.loadLocal(4, irOp);
                break;
            }
            case 42: {
                this.loadLocal(5, irOp);
                break;
            }
            case 43: {
                this.loadLocal(6, irOp);
                break;
            }
            case 44: {
                this.loadLocal(7, irOp);
                break;
            }
            case 45: {
                this.loadLocal(irOp.argToInt(), irOp);
                break;
            }
            case 46: {
                this.loadLocal(irOp.argToInt(), irOp);
                break;
            }
            case 47: {
                this.storeLocal(0, irOp);
                break;
            }
            case 48: {
                this.storeLocal(1, irOp);
                break;
            }
            case 49: {
                this.storeLocal(2, irOp);
                break;
            }
            case 50: {
                this.storeLocal(3, irOp);
                break;
            }
            case 51: {
                this.storeLocal(4, irOp);
                break;
            }
            case 52: {
                this.storeLocal(5, irOp);
                break;
            }
            case 53: {
                this.storeLocal(6, irOp);
                break;
            }
            case 54: {
                this.storeLocal(7, irOp);
                break;
            }
            case 55: {
                this.storeLocal(irOp.argToInt(), irOp);
                break;
            }
            case 56: {
                this.storeLocal(irOp.argToInt(), irOp);
                break;
            }
            case 57: {
                this.compare(159);
                break;
            }
            case 58: {
                this.compare(160);
                break;
            }
            case 59: {
                this.compare(163);
                break;
            }
            case 60: {
                this.compare(162);
                break;
            }
            case 61: {
                this.compare(161);
                break;
            }
            case 62: {
                this.compare(164);
                break;
            }
            case 63: {
                this.op(104);
                break;
            }
            case 64: {
                this.op(108);
                break;
            }
            case 65: {
                this.op(112);
                break;
            }
            case 66: {
                this.op(96);
                break;
            }
            case 67: {
                this.op(100);
                break;
            }
            case 68: {
                this.op(128);
                break;
            }
            case 69: {
                this.op(130);
                break;
            }
            case 70: {
                this.op(126);
                break;
            }
            case 71: {
                this.op(2);
                this.op(130);
                break;
            }
            case 72: {
                this.op(116);
                break;
            }
            case 73: {
                this.op(120);
                break;
            }
            case 74: {
                this.op(122);
                break;
            }
            case 75: {
                this.op(4);
                this.op(96);
                break;
            }
            case 76: {
                this.op(2);
                this.op(96);
                break;
            }
            case 77: {
                this.compare(153, 148);
                break;
            }
            case 78: {
                this.compare(154, 148);
                break;
            }
            case 79: {
                this.compare(157, 148);
                break;
            }
            case 80: {
                this.compare(156, 148);
                break;
            }
            case 81: {
                this.compare(155, 148);
                break;
            }
            case 82: {
                this.compare(158, 148);
                break;
            }
            case 83: {
                this.op(105);
                break;
            }
            case 84: {
                this.op(109);
                break;
            }
            case 85: {
                this.op(113);
                break;
            }
            case 86: {
                this.op(97);
                break;
            }
            case 87: {
                this.op(101);
                break;
            }
            case 88: {
                this.op(129);
                break;
            }
            case 89: {
                this.op(131);
                break;
            }
            case 90: {
                this.op(127);
                break;
            }
            case 91: {
                this.loadLong(-1L);
                this.op(131);
                break;
            }
            case 92: {
                this.op(117);
                break;
            }
            case 93: {
                this.op(121);
                break;
            }
            case 94: {
                this.op(123);
                break;
            }
            case 95: {
                this.code.add(184, this.parent.cp.method("sedona/vm/VmUtil", "floatEQ", "(FF)Z"));
                break;
            }
            case 96: {
                this.code.add(184, this.parent.cp.method("sedona/vm/VmUtil", "floatNE", "(FF)Z"));
                break;
            }
            case 97: {
                this.compare(157, 150);
                break;
            }
            case 98: {
                this.compare(156, 150);
                break;
            }
            case 99: {
                this.compare(155, 150);
                break;
            }
            case 100: {
                this.compare(158, 150);
                break;
            }
            case 101: {
                this.op(106);
                break;
            }
            case 102: {
                this.op(110);
                break;
            }
            case 103: {
                this.op(98);
                break;
            }
            case 104: {
                this.op(102);
                break;
            }
            case 105: {
                this.op(118);
                break;
            }
            case 106: {
                this.code.add(184, this.parent.cp.method("sedona/vm/VmUtil", "doubleEQ", "(DD)Z"));
                break;
            }
            case 107: {
                this.code.add(184, this.parent.cp.method("sedona/vm/VmUtil", "doubleNE", "(DD)Z"));
                break;
            }
            case 108: {
                this.compare(157, 152);
                break;
            }
            case 109: {
                this.compare(156, 152);
                break;
            }
            case 110: {
                this.compare(155, 152);
                break;
            }
            case 111: {
                this.compare(158, 152);
                break;
            }
            case 112: {
                this.op(107);
                break;
            }
            case 113: {
                this.op(111);
                break;
            }
            case 114: {
                this.op(99);
                break;
            }
            case 115: {
                this.op(103);
                break;
            }
            case 116: {
                this.op(119);
                break;
            }
            case 117: {
                this.op(134);
                break;
            }
            case 118: {
                this.op(133);
                break;
            }
            case 119: {
                this.op(135);
                break;
            }
            case 120: {
                this.op(136);
                break;
            }
            case 121: {
                this.op(137);
                break;
            }
            case 122: {
                this.op(138);
                break;
            }
            case 123: {
                this.op(139);
                break;
            }
            case 124: {
                this.op(140);
                break;
            }
            case 125: {
                this.op(141);
                break;
            }
            case 126: {
                this.op(142);
                break;
            }
            case 127: {
                this.op(143);
                break;
            }
            case 128: {
                this.op(144);
                break;
            }
            case 129: {
                this.compare(165);
                break;
            }
            case 130: {
                this.compare(166);
                break;
            }
            case 131: {
                this.not();
                break;
            }
            case 132: {
                throw new IllegalStateException();
            }
            case 133: {
                this.op(87);
                break;
            }
            case 134: {
                this.op(88);
                break;
            }
            case 135: {
                break;
            }
            case 136: {
                this.op(89);
                break;
            }
            case 137: {
                this.op(92);
                break;
            }
            case 138: {
                this.dupDown(irOp);
                break;
            }
            case 139: {
                this.dupDown(irOp);
                break;
            }
            case 140: {
                this.dupDown(irOp);
                break;
            }
            case 141: {
                this.dupDown(irOp);
                break;
            }
            case 142: {
                this.jump(167, irOp);
                break;
            }
            case 143: {
                this.jump(154, irOp);
                break;
            }
            case 144: {
                this.jump(153, irOp);
                break;
            }
            case 145: {
                this.foreach(irOp);
                break;
            }
            case 146: {
                throw new IllegalStateException();
            }
            case 147: {
                throw new IllegalStateException();
            }
            case 148: {
                throw new IllegalStateException();
            }
            case 149: {
                throw new IllegalStateException();
            }
            case 162: {
                this.skipLoadDataAddr();
                break;
            }
            case 163: {
                this.loadField(irOp);
                break;
            }
            case 166: {
                this.loadArray(irOp);
                break;
            }
            case 167: {
                this.storeField(irOp);
                break;
            }
            case 170: {
                this.storeArray(irOp);
                break;
            }
            case 171: {
                this.addArray(irOp);
                break;
            }
            case 172: {
                this.loadField(irOp);
                break;
            }
            case 175: {
                this.loadArray(irOp);
                break;
            }
            case 176: {
                this.storeField(irOp);
                break;
            }
            case 179: {
                this.storeArray(irOp);
                break;
            }
            case 180: {
                this.addArray(irOp);
                break;
            }
            case 181: {
                this.loadField(irOp);
                break;
            }
            case 184: {
                this.loadArray(irOp);
                break;
            }
            case 185: {
                this.storeField(irOp);
                break;
            }
            case 188: {
                this.storeArray(irOp);
                break;
            }
            case 189: {
                this.addArray(irOp);
                break;
            }
            case 190: {
                this.loadField(irOp);
                break;
            }
            case 193: {
                this.loadArray(irOp);
                break;
            }
            case 194: {
                this.storeField(irOp);
                break;
            }
            case 197: {
                this.storeArray(irOp);
                break;
            }
            case 198: {
                this.addArray(irOp);
                break;
            }
            case 199: {
                this.loadField(irOp);
                break;
            }
            case 202: {
                this.loadArray(irOp);
                break;
            }
            case 203: {
                this.storeField(irOp);
                break;
            }
            case 206: {
                this.storeArray(irOp);
                break;
            }
            case 207: {
                this.addArray(irOp);
                break;
            }
            case 208: {
                this.loadField(irOp);
                break;
            }
            case 210: {
                this.loadField(irOp);
                break;
            }
            case 211: {
                this.loadArray(irOp);
                break;
            }
            case 212: {
                this.loadField(irOp);
                break;
            }
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: {
                this.call(irOp);
                break;
            }
            case 226: 
            case 227: 
            case 228: {
                this.returnOp();
                break;
            }
            case 230: {
                this.code.add(88);
                this.code.add(87);
                break;
            }
            case 231: {
                this.code.add(87);
                break;
            }
            case 232: {
                this.initComp();
                break;
            }
            case 233: {
                this.code.addIntConst(-999);
                break;
            }
            case 234: {
                this.assertOp(irOp);
                break;
            }
            case 235: {
                this.switchOp(irOp);
                break;
            }
            case 236: {
                break;
            }
            case 237: {
                this.cast(irOp);
                break;
            }
            default: {
                throw new IllegalStateException(irOp + " " + irOp.loc);
            }
        }
    }

    void loadInt(int n) {
        this.code.addIntConst(n);
    }

    void loadLong(long l) {
        this.code.addLongConst(l);
    }

    void loadFloat(float f) {
        this.code.addFloatConst(f);
    }

    void loadDouble(double d) {
        this.code.addDoubleConst(d);
    }

    public void loadParam(int n, IrOp irOp) {
        this.load(n, this.jstackType(irOp));
    }

    public void loadLocal(int n, IrOp irOp) {
        this.load(n + this.localOffset, this.jstackType(irOp));
    }

    public void load(int n, int n2) {
        switch (n2) {
            case 65: {
                this.code.aload(n);
                break;
            }
            case 73: {
                this.code.iload(n);
                break;
            }
            case 74: {
                this.code.lload(n);
                break;
            }
            case 70: {
                this.code.fload(n);
                break;
            }
            case 68: {
                this.code.dload(n);
                break;
            }
            default: {
                throw new IllegalStateException("" + (char)n2);
            }
        }
    }

    public void storeParam(int n, IrOp irOp) {
        this.store(n, this.jstackType(irOp));
    }

    public void storeLocal(int n, IrOp irOp) {
        this.store(n + this.localOffset, this.jstackType(irOp));
    }

    public void store(int n, int n2) {
        switch (n2) {
            case 65: {
                this.code.astore(n);
                break;
            }
            case 73: {
                this.code.istore(n);
                break;
            }
            case 74: {
                this.code.lstore(n);
                break;
            }
            case 70: {
                this.code.fstore(n);
                break;
            }
            case 68: {
                this.code.dstore(n);
                break;
            }
            default: {
                throw new IllegalStateException("" + (char)n2);
            }
        }
    }

    void compare(int n) {
        this.compare(n, -1);
    }

    void compare(int n, int n2) {
        if (n2 > 0) {
            this.op(n2);
        }
        int n3 = this.branch(n);
        this.op(3);
        int n4 = this.branch(167);
        this.patch(n3);
        this.op(4);
        this.patch(n4);
    }

    void jump(int n, IrOp irOp) {
        this.branchTo(n, this.ir.code[irOp.argToInt()]);
    }

    void loadDefine(IrOp irOp) {
        Field field = (Field)irOp.resolvedArg;
        if (field == null) {
            throw new IllegalStateException("ERROR: must create IrOp with resolved field: " + irOp);
        }
        Expr.Literal literal = field.define();
        if (literal != null && !field.parent().qname().equals("sys::Sys")) {
            switch (literal.id) {
                case 1: {
                    this.op(4);
                    return;
                }
                case 2: {
                    this.op(3);
                    return;
                }
                case 3: {
                    this.loadInt(literal.asInt());
                    return;
                }
                case 4: {
                    this.loadLong(literal.asLong());
                    return;
                }
                case 5: {
                    this.loadFloat(literal.asFloat());
                    return;
                }
                case 6: {
                    this.loadDouble(literal.asDouble());
                    return;
                }
                case 7: {
                    this.loadLong(literal.asLong());
                    return;
                }
                case 9: {
                    this.kitAsm.loadStr(this.code, literal.asString());
                    return;
                }
                case 8: {
                    this.op(1);
                    return;
                }
            }
        }
        this.loadField(irOp);
    }

    void loadField(IrOp irOp) {
        Field field = (Field)irOp.resolvedArg;
        if (field == null) {
            throw new IllegalStateException("ERROR: must create IrOp with resolved field: " + irOp);
        }
        if (field.qname().equals("sys::Str.buf")) {
            this.code.add(180, this.code.cp.field("sedona/vm/StrRef", "buf", "[B"));
            return;
        }
        int n = this.parent.fieldRef(field);
        if (field.isStatic()) {
            this.code.add(178, n);
        } else {
            this.code.add(180, n);
        }
        if (field.type().isByte()) {
            this.code.addIntConst(255);
            this.code.add(126);
        }
        if (field.type().isShort()) {
            this.code.addIntConst(65535);
            this.code.add(126);
        }
    }

    void storeField(IrOp irOp) {
        Field field = (Field)irOp.resolvedArg;
        if (field == null) {
            throw new IllegalStateException("ERROR: must create IrOp with resolved field: " + irOp);
        }
        int n = this.parent.fieldRef(field);
        if (field.isStatic()) {
            this.code.add(179, n);
        } else {
            this.code.add(181, n);
        }
    }

    void loadArray(IrOp irOp) {
        int n = this.jstackType(irOp, false);
        switch (n) {
            case 90: {
                this.code.add(51);
                break;
            }
            case 66: {
                this.code.add(51);
                this.code.addIntConst(255);
                this.code.add(126);
                break;
            }
            case 83: {
                this.code.add(53);
                this.code.addIntConst(65535);
                this.code.add(126);
                break;
            }
            case 73: {
                this.code.add(46);
                break;
            }
            case 74: {
                this.code.add(47);
                break;
            }
            case 70: {
                this.code.add(48);
                break;
            }
            case 68: {
                this.code.add(49);
                break;
            }
            case 65: {
                this.code.add(50);
                break;
            }
            default: {
                throw new IllegalStateException("loadArray " + (char)n);
            }
        }
    }

    void storeArray(IrOp irOp) {
        int n = this.jstackType(irOp.type, false);
        switch (n) {
            case 90: {
                this.code.add(84);
                break;
            }
            case 66: {
                this.code.add(84);
                break;
            }
            case 83: {
                this.code.add(86);
                break;
            }
            case 73: {
                this.code.add(79);
                break;
            }
            case 74: {
                this.code.add(80);
                break;
            }
            case 70: {
                this.code.add(81);
                break;
            }
            case 68: {
                this.code.add(82);
                break;
            }
            case 65: {
                this.code.add(83);
                break;
            }
            default: {
                throw new IllegalStateException("storeArray " + (char)n);
            }
        }
    }

    void addArray(IrOp irOp) {
        throw new IllegalStateException();
    }

    void call(IrOp irOp) {
        int n;
        Method method = (Method)irOp.resolvedArg;
        if (method == null) {
            throw new IllegalStateException("ERROR: must create IrOp with resolved method: " + irOp);
        }
        boolean bl = JavaClassAsm.isJavaNative(method);
        String string = method.qname();
        if (string.equals("sys::Sys.malloc")) {
            this.malloc(irOp);
            return;
        }
        if (bl) {
            n = 184;
        } else if (irOp.opcode == 222) {
            n = 182;
        } else if (method.isStatic()) {
            n = 184;
        } else if (this.ir.isStaticInit() && method.isInstanceInit()) {
            n = 182;
        } else if (this.ir.isInstanceInit() && method.isInstanceInit()) {
            n = this.prevOp.opcode == 29 ? 183 : 182;
        } else {
            n = 182;
            if (irOp.opcode == 221 && this.parent.ir.is(method.parent()) && (method.isVirtual() || method.isInstanceInit())) {
                n = 183;
            }
        }
        if (bl) {
            this.code.add(178, this.parent.contextRef());
        }
        int n2 = this.parent.methodRef(method);
        this.code.add(n, n2);
        Type type = method.returnType();
        if (method.isNative() && type.isRef() && !type.isObj() && !type.isArray() && !type.isStr()) {
            this.code.add(192, this.code.cp.cls(JavaClassAsm.jname(type, true)));
        }
    }

    void malloc(IrOp irOp) {
        Type type = irOp.type;
        if (type.isArray()) {
            int n = this.code.cp.cls(JavaClassAsm.jname(type.arrayOf(), false));
            this.code.add(189, n);
        } else {
            int n = this.code.cp.cls(JavaClassAsm.jname(type, false));
            this.code.add(187, n);
            this.code.add(89);
            this.code.add(183, this.code.cp.method(n, "<init>", "()V"));
        }
    }

    void returnOp() {
        this.code.add(this.returnOp(this.ir.ret));
    }

    int returnOp(Type type) {
        this.onReturn();
        switch (this.jstackType(type)) {
            case 65: {
                return 176;
            }
            case 73: {
                return 172;
            }
            case 74: {
                return 173;
            }
            case 70: {
                return 174;
            }
            case 68: {
                return 175;
            }
            case 86: {
                return 177;
            }
        }
        throw new IllegalStateException(((Object)type).toString());
    }

    void dupDown(IrOp irOp) {
        if ((irOp.flags & 1) != 0) {
            switch (irOp.opcode) {
                case 138: {
                    this.op(89);
                    break;
                }
                case 140: {
                    this.op(92);
                    break;
                }
                default: {
                    throw new IllegalStateException(irOp.toString());
                }
            }
            return;
        }
        switch (irOp.opcode) {
            case 138: {
                this.op(90);
                break;
            }
            case 139: {
                this.op(91);
                break;
            }
            case 140: {
                this.op(93);
                break;
            }
            case 141: {
                this.op(94);
                break;
            }
            default: {
                throw new IllegalStateException(irOp.toString());
            }
        }
    }

    void foreach(IrOp irOp) {
        int n = this.maxLocals++;
        int n2 = this.maxLocals++;
        int n3 = this.maxLocals++;
        this.store(n3, 73);
        this.store(n2, 73);
        this.store(n, 65);
        irOp.pos = this.code.code.count;
        this.load(n2, 73);
        this.load(n3, 73);
        this.code.add(4);
        this.code.add(96);
        this.code.add(89);
        this.store(n3, 73);
        this.jump(164, irOp);
        this.load(n, 65);
        this.load(n3, 73);
    }

    void not() {
        this.code.add(4);
        this.code.add(130);
    }

    void skipLoadDataAddr() {
        int n = this.peek().opcode;
        if (n == 136 || n == 137) {
            ++this.cur;
        }
    }

    void initComp() {
        this.kitAsm.loadType(this.code, this.parent.ir);
        this.code.add(181, this.code.cp.field("sedona/vm/sys/Component", "type", "Lsedona/vm/sys/Type;"));
    }

    void switchOp(IrOp irOp) {
        int n;
        String[] stringArray = TextUtil.split((String)irOp.arg, (char)',');
        int[] nArray = new int[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            nArray[n] = Integer.parseInt(stringArray[n]);
        }
        n = this.code.code.u1(170);
        while (this.code.code.count % 4 != 0) {
            this.code.code.u1(0);
        }
        int n2 = this.code.code.u4(-1);
        this.code.code.u4(0);
        this.code.code.u4(nArray.length - 1);
        for (int i = 0; i < nArray.length; ++i) {
            Patch patch = new Patch();
            patch.baseOffset = n;
            patch.offset = this.code.code.u4(-1);
            patch.dest = this.ir.code[nArray[i]];
            patch.width = 4;
            patch.next = this.patches;
            this.patches = patch;
        }
        this.code.code.u4(n2, this.code.code.count - n);
    }

    void assertOp(IrOp irOp) {
        this.code.add(184, this.parent.assertRef());
    }

    void cast(IrOp irOp) {
        Type type = irOp.argToType();
        String string = JavaClassAsm.jname(type, true);
        this.code.add(192, this.code.cp.cls(string));
    }

    AttributeInfo toLineNumTable() {
        IrOp[] irOpArray = this.ir.code;
        Buffer buffer = new Buffer();
        buffer.u2(65535);
        int n = 0;
        int n2 = -1;
        for (int i = 0; i < irOpArray.length; ++i) {
            IrOp irOp = irOpArray[i];
            if (n2 == irOp.loc.line) continue;
            buffer.u2(irOp.pos);
            buffer.u2(irOp.loc.line);
            n2 = irOp.loc.line;
            ++n;
        }
        buffer.u2(0, n);
        return new AttributeInfo((Assembler)this.parent, "LineNumberTable", buffer.trim());
    }

    IrOp peek() {
        if (this.cur + 1 >= this.ir.code.length) {
            return null;
        }
        return this.ir.code[this.cur + 1];
    }

    void op(int n) {
        this.code.add(n);
    }

    void branchTo(int n, IrOp irOp) {
        Patch patch = new Patch();
        patch.offset = this.branch(n);
        patch.baseOffset = patch.offset - 1;
        patch.dest = irOp;
        patch.next = this.patches;
        this.patches = patch;
    }

    int branch(int n) {
        return this.code.branch(n);
    }

    void patch(int n) {
        this.code.patch(n);
    }

    void patch(int n, int n2) {
        this.code.patch(n, n2);
    }

    void backpatch() {
        Patch patch = this.patches;
        while (patch != null) {
            if (patch.width == 2) {
                this.code.code.u2(patch.offset, patch.dest.pos - patch.baseOffset);
            } else {
                this.code.code.u4(patch.offset, patch.dest.pos - patch.baseOffset);
            }
            patch = patch.next;
        }
    }

    public int jstackType(IrOp irOp) {
        return this.jstackType(irOp, true);
    }

    public int jstackType(IrOp irOp, boolean bl) {
        if (irOp.type == null) {
            throw new IllegalStateException("IrOp not typed: " + irOp);
        }
        return this.jstackType(irOp.type, bl);
    }

    public int jstackType(Type type) {
        return this.jstackType(type, true);
    }

    public int jstackType(Type type, boolean bl) {
        if (type.isRef()) {
            return 65;
        }
        switch (type.id()) {
            case 0: {
                return 86;
            }
            case 1: {
                return bl ? 73 : 90;
            }
            case 2: {
                return bl ? 73 : 66;
            }
            case 3: {
                return bl ? 73 : 83;
            }
            case 4: {
                return 73;
            }
            case 5: {
                return 74;
            }
            case 6: {
                return 70;
            }
            case 7: {
                return 68;
            }
        }
        throw new IllegalStateException(((Object)type).toString());
    }

    static class Patch {
        int baseOffset;
        int offset;
        IrOp dest;
        int width = 2;
        Patch next;

        Patch() {
        }
    }
}

