/*
 * Decompiled with CFR 0.152.
 */
package sedonac.ir;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import sedona.Bool;
import sedona.Facets;
import sedona.Value;
import sedona.util.TextUtil;
import sedonac.ast.Expr;
import sedonac.ir.IrField;
import sedonac.ir.IrMethod;
import sedonac.ir.IrOp;
import sedonac.ir.IrSlot;
import sedonac.ir.IrType;
import sedonac.namespace.Type;
import sedonac.namespace.TypeUtil;
import sedonac.scode.SCode;

public class IrWriter
extends PrintWriter {
    public int indent;

    public IrWriter(Writer writer) {
        super(writer);
    }

    public IrWriter(OutputStream outputStream) {
        super(outputStream);
    }

    public void writeType(IrType irType) {
        this.writeFacets(irType.facets);
        this.w(TypeUtil.flagsToString(irType));
        this.w("class ").w(irType.name);
        if (irType.base != null) {
            this.w(" extends ").w(irType.base);
        }
        this.nl();
        this.w("{").nl();
        ++this.indent;
        IrSlot[] irSlotArray = irType.declared;
        for (int i = 0; i < irSlotArray.length; ++i) {
            this.nl();
            this.writeSlot(irSlotArray[i]);
        }
        --this.indent;
        this.nl();
        this.w("}").nl();
    }

    public void writeSlot(IrSlot irSlot) {
        if (irSlot instanceof IrMethod) {
            this.writeMethod((IrMethod)irSlot);
        } else {
            this.writeField((IrField)irSlot);
        }
    }

    public void writeFlags(IrSlot irSlot) {
        this.w(TypeUtil.flagsToString(irSlot));
    }

    public void writeField(IrField irField) {
        this.writeFacets(irField.facets);
        this.indent();
        this.writeFlags(irField);
        this.w(irField.type);
        this.w(" ").w(irField.name);
        if (irField.isDefine() && !irField.type.isLog()) {
            this.w(" = ").w(irField.define.toCodeString());
        }
        if (irField.arrayInit) {
            this.w(" = {...}");
        }
        this.nl();
        if (irField.ctorLengthParam > 0 || irField.ctorLengthArg != null) {
            this.w("  {").nl();
            if (irField.ctorLengthParam > 0) {
                this.w("    .ctorLengthParam = " + irField.ctorLengthParam).nl();
            }
            if (irField.ctorLengthArg != null) {
                Expr expr = irField.ctorLengthArg;
                String string = expr instanceof Expr.Literal ? ((Expr.Literal)expr).toCodeString() : ((Expr.Field)expr).field.qname();
                this.w("    .ctorLengthArg = " + string).nl();
            }
            this.w("  }").nl();
        }
    }

    public void writeMethod(IrMethod irMethod) {
        Type[] typeArray = irMethod.params;
        this.writeFacets(irMethod.facets);
        this.indent();
        this.writeFlags(irMethod);
        this.w(irMethod.ret).w(" ").w(irMethod.name).w("(");
        for (int i = 0; i < irMethod.params.length; ++i) {
            if (i > 0) {
                this.w(",");
            }
            this.w(irMethod.params[i]);
        }
        this.w(")");
        if (irMethod.isNative()) {
            this.w(" = ").w(irMethod.nativeId.toString());
        }
        this.nl();
        IrOp[] irOpArray = irMethod.code;
        if (irOpArray != null) {
            this.indent().w("{").nl();
            ++this.indent;
            if (irMethod.maxLocals > 0) {
                this.indent().w(".maxLocals = " + irMethod.maxLocals).nl();
            }
            for (int i = 0; i < irOpArray.length; ++i) {
                this.writeOp(irOpArray[i]);
            }
            --this.indent;
            this.indent().w("}").nl();
        }
    }

    public void writeOp(IrOp irOp) {
        String string = TextUtil.pad((String)(irOp.index + ": "), (int)5);
        this.indent().w(string).w(SCode.name(irOp.opcode));
        if (irOp.arg != null) {
            this.w(" ").w(irOp.arg);
        }
        this.nl();
    }

    public IrWriter writeFacets(Facets facets) {
        String[] stringArray = facets.keys();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Value value = facets.get(string);
            this.indent().w("@").w(string);
            if (value != Bool.TRUE) {
                this.w("=").w(value.toCode());
            }
            this.nl();
        }
        return this;
    }

    public IrWriter w(Type type) {
        String string = type.signature();
        if (string.startsWith("const ")) {
            string = string.substring(6);
        }
        this.print(string);
        return this;
    }

    public IrWriter w(Object object) {
        this.print(object);
        return this;
    }

    public IrWriter w(int n) {
        this.print(n);
        return this;
    }

    public IrWriter indent() {
        return this.w(TextUtil.getSpaces((int)(this.indent * 2)));
    }

    public IrWriter nl() {
        return this.w("\n");
    }
}

