/*
 * Decompiled with CFR 0.152.
 */
package sedonac.ast;

import sedonac.Location;
import sedonac.ast.AstNode;
import sedonac.ast.AstVisitor;
import sedonac.ast.AstWriter;
import sedonac.ast.Block;
import sedonac.ast.Expr;
import sedonac.ast.LocalScope;
import sedonac.ast.VarDef;
import sedonac.ir.IrOp;
import sedonac.namespace.Type;

public abstract class Stmt
extends AstNode {
    public static final int EXPR_STMT = 1;
    public static final int LOCAL_DEF = 2;
    public static final int RETURN = 3;
    public static final int IF = 4;
    public static final int FOR = 5;
    public static final int FOREACH = 6;
    public static final int WHILE = 7;
    public static final int DO_WHILE = 8;
    public static final int BREAK = 9;
    public static final int CONTINUE = 10;
    public static final int ASSERT = 11;
    public static final int GOTO = 12;
    public static final int SWITCH = 13;
    public final int id;
    public String label;
    public int mark = -1;

    Stmt(Location location, int n) {
        super(location);
        this.id = n;
    }

    public void walk(AstVisitor astVisitor) {
        astVisitor.enterStmt(this);
        this.doWalk(astVisitor);
        astVisitor.exitStmt(this);
    }

    public boolean isExit() {
        return false;
    }

    public abstract int maxStack();

    static int max(int n, int n2) {
        return Math.max(n, n2);
    }

    static int max(int n, int n2, int n3) {
        return Math.max(Math.max(n, n2), n3);
    }

    static int max(int n, int n2, int n3, int n4) {
        return Math.max(Math.max(n, n2), Math.max(n3, n4));
    }

    protected abstract void doWalk(AstVisitor var1);

    public static class Case
    extends AstNode {
        public Expr label;
        public Block block;

        public Case(Location location) {
            super(location);
        }

        public void walk(AstVisitor astVisitor) {
            this.label = this.label.walk(astVisitor);
            if (this.block != null) {
                this.block.walk(astVisitor);
            }
        }

        public int maxStack() {
            return this.block == null ? 0 : this.block.maxStack();
        }

        @Override
        public void write(AstWriter astWriter) {
            astWriter.indent().w("case:").w(this.label).nl();
            if (this.block != null) {
                this.block.write(astWriter, false);
            }
        }
    }

    public static class Switch
    extends Stmt {
        public Expr cond;
        public Case[] cases;
        public Block defaultBlock;

        public Switch(Location location) {
            super(location, 13);
        }

        @Override
        public boolean isExit() {
            if (this.defaultBlock == null) {
                return false;
            }
            for (int i = 0; i < this.cases.length; ++i) {
                if (this.cases[i].block == null || this.cases[i].block.isExit()) continue;
                return false;
            }
            return this.defaultBlock.isExit();
        }

        @Override
        protected void doWalk(AstVisitor astVisitor) {
            this.cond = this.cond.walk(astVisitor);
            for (int i = 0; i < this.cases.length; ++i) {
                this.cases[i].walk(astVisitor);
            }
            if (this.defaultBlock != null) {
                this.defaultBlock.walk(astVisitor);
            }
        }

        @Override
        public int maxStack() {
            int n = this.cond.maxStack();
            for (int i = 0; i < this.cases.length; ++i) {
                n = Switch.max(n, this.cases[i].maxStack());
            }
            if (this.defaultBlock != null) {
                n = Switch.max(n, this.defaultBlock.maxStack());
            }
            return n;
        }

        @Override
        public void write(AstWriter astWriter) {
            astWriter.indent().w("switch (").w(this.cond).w(")").nl();
            astWriter.indent().w("{").nl();
            ++astWriter.indent;
            for (int i = 0; i < this.cases.length; ++i) {
                this.cases[i].write(astWriter);
            }
            if (this.defaultBlock != null) {
                astWriter.indent().w("default:").nl();
                this.defaultBlock.write(astWriter, false);
            }
            --astWriter.indent;
            astWriter.indent().w("}").nl();
        }
    }

    public static class Goto
    extends Stmt {
        public String destLabel;
        public Stmt destStmt;
        public IrOp op;

        public Goto(Location location) {
            super(location, 12);
        }

        @Override
        public boolean isExit() {
            return true;
        }

        @Override
        public int maxStack() {
            return 0;
        }

        @Override
        protected void doWalk(AstVisitor astVisitor) {
        }

        @Override
        public void write(AstWriter astWriter) {
            astWriter.indent().w("goto ").w(this.destLabel).nl();
        }
    }

    public static class Assert
    extends Stmt {
        public Expr cond;

        public Assert(Location location) {
            super(location, 11);
        }

        @Override
        protected void doWalk(AstVisitor astVisitor) {
            this.cond = this.cond.walk(astVisitor);
        }

        @Override
        public int maxStack() {
            return this.cond.maxStack();
        }

        @Override
        public void write(AstWriter astWriter) {
            astWriter.indent().w("assert (").w(this.cond).w(")").nl();
        }
    }

    public static class Continue
    extends Stmt {
        public Continue(Location location) {
            super(location, 10);
        }

        @Override
        protected void doWalk(AstVisitor astVisitor) {
        }

        @Override
        public int maxStack() {
            return 0;
        }

        @Override
        public void write(AstWriter astWriter) {
            astWriter.indent().w("continue").nl();
        }
    }

    public static class Break
    extends Stmt {
        public Break(Location location) {
            super(location, 9);
        }

        @Override
        protected void doWalk(AstVisitor astVisitor) {
        }

        @Override
        public int maxStack() {
            return 0;
        }

        @Override
        public void write(AstWriter astWriter) {
            astWriter.indent().w("break").nl();
        }
    }

    public static class DoWhile
    extends Stmt {
        public Expr cond;
        public Block block;

        public DoWhile(Location location) {
            super(location, 8);
        }

        @Override
        protected void doWalk(AstVisitor astVisitor) {
            if (this.cond != null) {
                this.cond = this.cond.walk(astVisitor);
            }
            this.block.walk(astVisitor);
        }

        @Override
        public int maxStack() {
            int n = this.cond.maxStack();
            int n2 = this.block.maxStack();
            return DoWhile.max(n, n2);
        }

        @Override
        public void write(AstWriter astWriter) {
            astWriter.indent().w("do").nl();
            this.block.write(astWriter);
            astWriter.indent().w("while (").w(this.cond).w(")").nl();
        }
    }

    public static class While
    extends Stmt {
        public Expr cond;
        public Block block;

        public While(Location location) {
            super(location, 7);
        }

        @Override
        protected void doWalk(AstVisitor astVisitor) {
            if (this.cond != null) {
                this.cond = this.cond.walk(astVisitor);
            }
            this.block.walk(astVisitor);
        }

        @Override
        public int maxStack() {
            int n = this.cond.maxStack();
            int n2 = this.block.maxStack();
            return While.max(n, n2);
        }

        @Override
        public void write(AstWriter astWriter) {
            astWriter.indent().w("while (").w(this.cond).w(")").nl();
            this.block.write(astWriter);
        }
    }

    public static class Foreach
    extends Stmt
    implements LocalScope {
        public LocalDef local;
        public Expr array;
        public Expr length;
        public Block block;

        public Foreach(Location location) {
            super(location, 6);
        }

        @Override
        public LocalDef[] getLocals() {
            return new LocalDef[]{this.local};
        }

        @Override
        public LocalDef resolveLocal(String string) {
            return LocalDef.isLocal(this.local, string);
        }

        @Override
        protected void doWalk(AstVisitor astVisitor) {
            this.local.walk(astVisitor);
            this.array = this.array.walk(astVisitor);
            if (this.length != null) {
                this.length = this.length.walk(astVisitor);
            }
            this.block.walk(astVisitor);
        }

        @Override
        public int maxStack() {
            int n = this.array.maxStack();
            int n2 = this.length == null ? 0 : this.length.maxStack();
            int n3 = this.block.maxStack();
            return Foreach.max(n + n2 + 2, n3);
        }

        @Override
        public void write(AstWriter astWriter) {
            astWriter.indent().w("foreach (").w(this.local).w(" : ").w(this.array);
            if (this.length != null) {
                astWriter.w(", ").w(this.length);
            }
            astWriter.w(")").nl();
            this.block.write(astWriter);
        }
    }

    public static class For
    extends Stmt
    implements LocalScope {
        public Stmt init;
        public Expr cond;
        public Expr update;
        public Block block;

        public For(Location location) {
            super(location, 5);
        }

        @Override
        public LocalDef[] getLocals() {
            if (this.init instanceof LocalDef) {
                return new LocalDef[]{(LocalDef)this.init};
            }
            return new LocalDef[0];
        }

        @Override
        public LocalDef resolveLocal(String string) {
            return LocalDef.isLocal(this.init, string);
        }

        @Override
        protected void doWalk(AstVisitor astVisitor) {
            if (this.init != null) {
                this.init.walk(astVisitor);
            }
            if (this.cond != null) {
                this.cond = this.cond.walk(astVisitor);
            }
            if (this.update != null) {
                this.update = this.update.walk(astVisitor);
            }
            this.block.walk(astVisitor);
        }

        @Override
        public int maxStack() {
            int n = this.init == null ? 0 : this.init.maxStack();
            int n2 = this.cond == null ? 0 : this.cond.maxStack();
            int n3 = this.update == null ? 0 : this.update.maxStack();
            int n4 = this.block.maxStack();
            return For.max(n, n2, n3, n4);
        }

        @Override
        public void write(AstWriter astWriter) {
            astWriter.indent().w("for (");
            if (this.init != null) {
                astWriter.w(this.init);
            }
            astWriter.w("; ");
            if (this.cond != null) {
                astWriter.w(this.cond);
            }
            astWriter.w("; ");
            if (this.update != null) {
                astWriter.w(this.update);
            }
            astWriter.w(")").nl();
            this.block.write(astWriter);
        }
    }

    public static class If
    extends Stmt {
        public Expr cond;
        public Block trueBlock;
        public Block falseBlock;

        public If(Location location) {
            super(location, 4);
        }

        @Override
        public boolean isExit() {
            if (this.falseBlock == null) {
                return false;
            }
            return this.trueBlock.isExit() && this.falseBlock.isExit();
        }

        @Override
        protected void doWalk(AstVisitor astVisitor) {
            this.cond = this.cond.walk(astVisitor);
            this.trueBlock.walk(astVisitor);
            if (this.falseBlock != null) {
                this.falseBlock.walk(astVisitor);
            }
        }

        @Override
        public int maxStack() {
            int n = this.cond.maxStack();
            int n2 = this.trueBlock.maxStack();
            int n3 = this.falseBlock == null ? 0 : this.falseBlock.maxStack();
            return If.max(n, n2, n3);
        }

        @Override
        public void write(AstWriter astWriter) {
            astWriter.indent().w("if (").w(this.cond).w(")").nl();
            this.trueBlock.write(astWriter);
            if (this.falseBlock != null) {
                astWriter.indent().w("else").nl();
                this.falseBlock.write(astWriter);
            }
        }
    }

    public static class Return
    extends Stmt {
        public Expr expr;
        public int foreachDepth;

        public Return(Location location) {
            super(location, 3);
        }

        @Override
        protected void doWalk(AstVisitor astVisitor) {
            if (this.expr != null) {
                this.expr = this.expr.walk(astVisitor);
            }
        }

        @Override
        public boolean isExit() {
            return true;
        }

        @Override
        public int maxStack() {
            return this.expr == null ? 0 : this.expr.maxStack();
        }

        @Override
        public void write(AstWriter astWriter) {
            astWriter.indent().w("return ");
            if (this.expr != null) {
                astWriter.w(this.expr);
            }
            astWriter.nl();
        }
    }

    public static class LocalDef
    extends Stmt
    implements VarDef {
        public int index;
        public Type type;
        public String name;
        public Expr init;
        public boolean declared;

        public LocalDef(Location location, Type type, String string, Expr expr) {
            super(location, 2);
            this.type = type;
            this.name = string;
            this.init = expr;
        }

        public LocalDef(Location location, Type type, String string) {
            this(location, type, string, null);
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public Type type() {
            return this.type;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public boolean isParam() {
            return false;
        }

        @Override
        public boolean isLocal() {
            return true;
        }

        public String toString() {
            return this.type + " " + this.name;
        }

        @Override
        public int maxStack() {
            return this.init == null ? 0 : this.init.maxStack();
        }

        @Override
        protected void doWalk(AstVisitor astVisitor) {
            if (this.init != null) {
                this.init = this.init.walk(astVisitor);
            }
            this.type = astVisitor.type(this.type);
        }

        @Override
        public void write(AstWriter astWriter) {
            astWriter.indent().w(this.type).w(" ").w(this.name);
            if (this.init != null) {
                astWriter.w(" = ").w(this.init);
            }
            astWriter.nl();
        }

        public static LocalDef isLocal(Stmt stmt, String string) {
            if (stmt instanceof LocalDef) {
                LocalDef localDef = (LocalDef)stmt;
                if (localDef.name.equals(string)) {
                    return localDef;
                }
            }
            return null;
        }
    }

    public static class ExprStmt
    extends Stmt {
        public Expr expr;

        public ExprStmt(Location location, Expr expr) {
            super(location, 1);
            this.expr = expr;
        }

        @Override
        protected void doWalk(AstVisitor astVisitor) {
            this.expr = this.expr.walk(astVisitor);
        }

        @Override
        public int maxStack() {
            return this.expr.maxStack();
        }

        @Override
        public void write(AstWriter astWriter) {
            astWriter.indent().w(this.expr).nl();
        }
    }
}

