/*
 * Decompiled with CFR 0.152.
 */
package sedonac.ast;

import java.util.ArrayList;
import sedona.Bool;
import sedona.Buf;
import sedona.Double;
import sedona.Float;
import sedona.Int;
import sedona.Long;
import sedona.Str;
import sedona.Value;
import sedonac.Location;
import sedonac.ast.AstNode;
import sedonac.ast.AstVisitor;
import sedonac.ast.AstWriter;
import sedonac.ast.ParamDef;
import sedonac.ast.Stmt;
import sedonac.jasm.JavaClassAsm;
import sedonac.namespace.Method;
import sedonac.namespace.Namespace;
import sedonac.namespace.Slot;
import sedonac.namespace.Type;
import sedonac.namespace.TypeUtil;
import sedonac.parser.Token;

public abstract class Expr
extends AstNode {
    public static final int TRUE_LITERAL = 1;
    public static final int FALSE_LITERAL = 2;
    public static final int INT_LITERAL = 3;
    public static final int LONG_LITERAL = 4;
    public static final int FLOAT_LITERAL = 5;
    public static final int DOUBLE_LITERAL = 6;
    public static final int TIME_LITERAL = 7;
    public static final int NULL_LITERAL = 8;
    public static final int STR_LITERAL = 9;
    public static final int BUF_LITERAL = 10;
    public static final int TYPE_LITERAL = 11;
    public static final int SLOT_LITERAL = 12;
    public static final int ARRAY_LITERAL = 13;
    public static final int SIZE_OF = 14;
    public static final int NEGATE = 20;
    public static final int COND_NOT = 21;
    public static final int BIT_NOT = 22;
    public static final int PRE_INCR = 23;
    public static final int PRE_DECR = 24;
    public static final int POST_INCR = 25;
    public static final int POST_DECR = 26;
    public static final int COND_OR = 27;
    public static final int COND_AND = 28;
    public static final int EQ = 29;
    public static final int NOT_EQ = 30;
    public static final int GT = 31;
    public static final int GT_EQ = 32;
    public static final int LT = 33;
    public static final int LT_EQ = 34;
    public static final int BIT_OR = 35;
    public static final int BIT_XOR = 36;
    public static final int BIT_AND = 37;
    public static final int LSHIFT = 38;
    public static final int RSHIFT = 39;
    public static final int MUL = 40;
    public static final int DIV = 41;
    public static final int MOD = 42;
    public static final int ADD = 43;
    public static final int SUB = 44;
    public static final int ASSIGN = 45;
    public static final int ASSIGN_ADD = 46;
    public static final int ASSIGN_SUB = 47;
    public static final int ASSIGN_MUL = 48;
    public static final int ASSIGN_DIV = 49;
    public static final int ASSIGN_MOD = 50;
    public static final int ASSIGN_BIT_OR = 51;
    public static final int ASSIGN_BIT_XOR = 52;
    public static final int ASSIGN_BIT_AND = 53;
    public static final int ASSIGN_LSHIFT = 54;
    public static final int ASSIGN_RSHIFT = 55;
    public static final int ELVIS = 56;
    public static final int TERNARY = 57;
    public static final int NAME = 58;
    public static final int PARAM = 59;
    public static final int LOCAL = 60;
    public static final int THIS = 61;
    public static final int SUPER = 62;
    public static final int FIELD = 63;
    public static final int INDEX = 64;
    public static final int CALL = 65;
    public static final int CAST = 66;
    public static final int INIT_ARRAY = 67;
    public static final int INIT_VIRT = 68;
    public static final int INIT_COMP = 69;
    public static final int STATIC_TYPE = 70;
    public static final int PROP_SET = 71;
    public static final int INTERPOLATION = 72;
    public static final int NEW = 73;
    public static final int DELETE = 74;
    public int id;
    public Type type;
    public boolean leave = true;

    Expr(Location location, int n) {
        super(location);
        this.id = n;
    }

    public final Expr walk(AstVisitor astVisitor) {
        if (this.type != null) {
            this.type = astVisitor.type(this.type);
        }
        this.doWalk(astVisitor);
        return astVisitor.expr(this);
    }

    public Stmt toStmt() {
        return new Stmt.ExprStmt(this.loc, this);
    }

    public boolean isAssign() {
        return false;
    }

    public boolean isIncrDecr() {
        return false;
    }

    public boolean isStmt() {
        switch (this.id) {
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 74: {
                return true;
            }
        }
        return false;
    }

    public boolean isLiteral() {
        return false;
    }

    public Literal toLiteral() {
        return null;
    }

    public boolean isDefine() {
        return false;
    }

    public String toCodeString() {
        throw new IllegalStateException("not literal: " + this.getClass().getName());
    }

    public boolean isAssignable() {
        return false;
    }

    public Integer toIntLiteral() {
        return null;
    }

    protected abstract void doWalk(AstVisitor var1);

    @Override
    public void write(AstWriter astWriter) {
        astWriter.w(this);
    }

    public abstract String toString();

    public boolean isNullLiteral(Type type) {
        if (this.id == 8 && type.isNullable()) {
            this.type = type;
            return true;
        }
        return false;
    }

    public abstract int maxStack();

    public static class Delete
    extends Expr {
        public Expr target;

        public Delete(Location location) {
            super(location, 74);
        }

        @Override
        protected void doWalk(AstVisitor astVisitor) {
            this.target = this.target.walk(astVisitor);
        }

        @Override
        public int maxStack() {
            return this.target.maxStack();
        }

        @Override
        public String toString() {
            return "delete " + this.target;
        }
    }

    public static class New
    extends Expr {
        public Type of;
        public Expr arrayLength;

        public New(Location location) {
            super(location, 73);
        }

        @Override
        protected void doWalk(AstVisitor astVisitor) {
            this.of = astVisitor.type(this.of);
            if (this.arrayLength != null) {
                this.arrayLength = this.arrayLength.walk(astVisitor);
            }
        }

        @Override
        public String toString() {
            String string = "new " + this.of;
            string = this.arrayLength != null ? string + "[" + this.arrayLength + "]" : string + "()";
            return string;
        }

        @Override
        public int maxStack() {
            return 2;
        }
    }

    public static class Interpolation
    extends Expr {
        public ArrayList parts = new ArrayList();
        public Method[] printMethods;
        public boolean callOk;

        public Interpolation(Location location) {
            super(location, 72);
        }

        public Literal first() {
            Expr expr = (Expr)this.parts.get(0);
            if (expr.id != 9) {
                throw new IllegalStateException("first not string literal: " + expr.id + " " + expr);
            }
            return (Literal)expr;
        }

        @Override
        protected void doWalk(AstVisitor astVisitor) {
            ArrayList<Expr> arrayList = new ArrayList<Expr>();
            for (int i = 0; i < this.parts.size(); ++i) {
                Expr expr = (Expr)this.parts.get(i);
                arrayList.add(expr.walk(astVisitor));
            }
            this.parts = arrayList;
        }

        @Override
        public int maxStack() {
            int n = 0;
            for (int i = 0; i < this.parts.size(); ++i) {
                n += ((Expr)this.parts.get(i)).maxStack();
            }
            return n;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('\"');
            for (int i = 0; i < this.parts.size(); ++i) {
                Expr expr = (Expr)this.parts.get(i);
                if (expr.id == 9) {
                    stringBuffer.append(expr.toString());
                    continue;
                }
                stringBuffer.append("${").append(expr).append('}');
            }
            stringBuffer.append('\"');
            return stringBuffer.toString();
        }
    }

    public static class StaticType
    extends Expr {
        public StaticType(Location location, Type type) {
            super(location, 70);
            this.type = type;
        }

        @Override
        protected void doWalk(AstVisitor astVisitor) {
            this.type = astVisitor.type(this.type);
        }

        @Override
        public int maxStack() {
            return 0;
        }

        @Override
        public String toString() {
            return ((Object)this.type).toString();
        }
    }

    public static class InitComp
    extends Expr {
        public InitComp(Location location, Type type) {
            super(location, 69);
            this.type = type;
        }

        @Override
        protected void doWalk(AstVisitor astVisitor) {
        }

        @Override
        public int maxStack() {
            return 2;
        }

        @Override
        public String toString() {
            return "InitComp " + this.type;
        }
    }

    public static class InitVirt
    extends Expr {
        public InitVirt(Location location, Type type) {
            super(location, 68);
            this.type = type;
        }

        @Override
        protected void doWalk(AstVisitor astVisitor) {
        }

        @Override
        public int maxStack() {
            return 2;
        }

        @Override
        public String toString() {
            return "InitVirt " + this.type;
        }
    }

    public static class InitArray
    extends Expr {
        public Expr field;
        public Expr length;

        public InitArray(Location location) {
            super(location, 67);
        }

        @Override
        protected void doWalk(AstVisitor astVisitor) {
        }

        @Override
        public String toString() {
            return "{...}";
        }

        @Override
        public int maxStack() {
            return 4;
        }
    }

    public static class Cast
    extends Expr {
        public Expr target;

        public Cast(Location location, Type type, Expr expr) {
            super(location, 66);
            this.type = type;
            this.target = expr;
        }

        @Override
        protected void doWalk(AstVisitor astVisitor) {
            this.type = astVisitor.type(this.type);
            this.target = this.target.walk(astVisitor);
        }

        @Override
        public int maxStack() {
            int n = this.target.maxStack();
            if (this.type.isWide()) {
                n = Math.max(n, 2);
            }
            return n;
        }

        @Override
        public String toString() {
            return "(" + this.type + ")" + this.target;
        }
    }

    public static class Call
    extends Name {
        public Expr[] args;
        public Method method;

        public Call(Location location, Expr expr, String string, Expr[] exprArray) {
            super(location, 65, expr, string);
            this.args = exprArray;
        }

        public Call(Location location, Expr expr, Method method, Expr[] exprArray) {
            this(location, 65, expr, method, exprArray);
        }

        public Call(Location location, int n, Expr expr, Method method, Expr[] exprArray) {
            super(location, n, expr, method.name());
            this.method = method;
            this.args = exprArray;
            if (method != null) {
                this.type = method.returnType();
            }
        }

        @Override
        protected void doWalk(AstVisitor astVisitor) {
            super.doWalk(astVisitor);
            for (int i = 0; i < this.args.length; ++i) {
                this.args[i] = this.args[i].walk(astVisitor);
            }
        }

        @Override
        public int maxStack() {
            Type type;
            int n = super.maxStack();
            for (int i = 0; i < this.args.length; ++i) {
                n += this.args[i].maxStack();
            }
            if (this.id == 71) {
                n += this.type.isWide() ? 2 : 1;
            }
            if (!(type = this.method.returnType()).isVoid()) {
                n = Math.max(n, type.isWide() ? 2 : 1);
            }
            if (JavaClassAsm.isJavaNative(this.method)) {
                ++n;
            }
            return n;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(super.toString());
            stringBuffer.append("(");
            for (int i = 0; i < this.args.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.args[i]);
            }
            return stringBuffer.append(")").toString();
        }
    }

    public static class Index
    extends Expr {
        public Expr target;
        public Expr index;

        public Index(Location location, Expr expr, Expr expr2) {
            super(location, 64);
            this.target = expr;
            this.index = expr2;
        }

        @Override
        public boolean isAssignable() {
            return this.target.id != 63 || !((Field)this.target).field.isConst();
        }

        @Override
        protected void doWalk(AstVisitor astVisitor) {
            this.target = this.target.walk(astVisitor);
            this.index = this.index.walk(astVisitor);
        }

        @Override
        public int maxStack() {
            return this.target.maxStack() + this.index.maxStack();
        }

        @Override
        public String toString() {
            return this.target.toString() + "[" + this.index + "]";
        }
    }

    public static class Field
    extends Name {
        public sedonac.namespace.Field field;

        public Field(Location location, Expr expr, sedonac.namespace.Field field, boolean bl) {
            super(location, 63, expr, field.name());
            this.field = field;
            this.type = field.type();
            this.safeNav = bl;
        }

        public Field(Location location, Expr expr, sedonac.namespace.Field field) {
            this(location, expr, field, false);
        }

        @Override
        public boolean isAssignable() {
            return !this.field.isInline() && !this.field.isConst();
        }

        @Override
        public Literal toLiteral() {
            if (this.isDefine()) {
                return this.field.define();
            }
            return null;
        }

        @Override
        public boolean isDefine() {
            return this.field.isDefine();
        }

        @Override
        public Integer toIntLiteral() {
            if (this.isDefine() && this.type.isInt()) {
                return this.field.define().toIntLiteral();
            }
            return null;
        }

        @Override
        public int maxStack() {
            int n;
            int n2 = super.maxStack();
            int n3 = n = this.type.isWide() ? 2 : 1;
            if (this.type.isByte() || this.type.isShort()) {
                ++n;
            }
            return Math.max(n2, n);
        }

        @Override
        public String toString() {
            return super.toString();
        }
    }

    public static class Super
    extends Expr {
        public Super(Location location) {
            super(location, 62);
        }

        @Override
        public void doWalk(AstVisitor astVisitor) {
        }

        @Override
        public int maxStack() {
            return 1;
        }

        @Override
        public String toString() {
            return "super";
        }
    }

    public static class This
    extends Expr {
        public This(Location location) {
            super(location, 61);
        }

        @Override
        public void doWalk(AstVisitor astVisitor) {
        }

        @Override
        public int maxStack() {
            return 1;
        }

        @Override
        public String toString() {
            return "this";
        }
    }

    public static class Local
    extends Name {
        public Stmt.LocalDef def;

        public Local(Location location, Stmt.LocalDef localDef) {
            super(location, 60, null, localDef.name);
            this.type = localDef.type;
            this.def = localDef;
        }

        @Override
        public boolean isAssignable() {
            return true;
        }

        @Override
        public int maxStack() {
            return this.type.isWide() ? 2 : 1;
        }
    }

    public static class Param
    extends Name {
        public ParamDef def;

        public Param(Location location, String string, ParamDef paramDef) {
            super(location, 59, null, string);
            this.type = paramDef.type;
            this.def = paramDef;
        }

        @Override
        public boolean isAssignable() {
            return true;
        }

        @Override
        public int maxStack() {
            return this.type.isWide() ? 2 : 1;
        }
    }

    public static class Name
    extends Expr {
        public Expr target;
        public String name;
        public boolean safeNav;

        public Name(Location location, Expr expr, String string) {
            this(location, 58, expr, string);
        }

        public Name(Location location, int n, Expr expr, String string) {
            super(location, n);
            this.target = expr;
            this.name = string;
        }

        @Override
        protected void doWalk(AstVisitor astVisitor) {
            if (this.target != null) {
                this.target = this.target.walk(astVisitor);
            }
        }

        @Override
        public String toString() {
            if (this.target == null) {
                return this.name;
            }
            if (this.safeNav) {
                return this.target.toString() + "?." + this.name;
            }
            return this.target.toString() + "." + this.name;
        }

        @Override
        public int maxStack() {
            int n;
            int n2 = n = this.target == null ? 0 : this.target.maxStack();
            if (this.safeNav) {
                ++n;
            }
            return n;
        }
    }

    public static class Ternary
    extends Expr {
        public Expr cond;
        public Expr trueExpr;
        public Expr falseExpr;

        public Ternary(Location location) {
            super(location, 57);
        }

        @Override
        protected void doWalk(AstVisitor astVisitor) {
            this.cond = this.cond.walk(astVisitor);
            this.trueExpr = this.trueExpr.walk(astVisitor);
            this.falseExpr = this.falseExpr.walk(astVisitor);
        }

        @Override
        public String toString() {
            return "(" + this.cond + " ? " + this.trueExpr + " : " + this.falseExpr + ")";
        }

        @Override
        public int maxStack() {
            return Math.max(this.cond.maxStack(), Math.max(this.trueExpr.maxStack(), this.falseExpr.maxStack()));
        }
    }

    public static class Cond
    extends Expr {
        public Token op;
        public ArrayList operands = new ArrayList();

        public Cond(Location location, int n, Token token, Expr expr) {
            super(location, n);
            this.op = token;
            this.operands.add(expr);
        }

        @Override
        protected void doWalk(AstVisitor astVisitor) {
            ArrayList<Expr> arrayList = new ArrayList<Expr>();
            for (int i = 0; i < this.operands.size(); ++i) {
                Expr expr = (Expr)this.operands.get(i);
                arrayList.add(expr.walk(astVisitor));
            }
            this.operands = arrayList;
        }

        @Override
        public int maxStack() {
            int n = 0;
            for (int i = 0; i < this.operands.size(); ++i) {
                n += ((Expr)this.operands.get(i)).maxStack();
            }
            return n;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("(");
            for (int i = 0; i < this.operands.size(); ++i) {
                if (i > 0) {
                    stringBuffer.append(" " + this.op + " ");
                }
                stringBuffer.append(this.operands.get(i));
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    public static class Binary
    extends Expr {
        public Token op;
        public Expr lhs;
        public Expr rhs;

        public Binary(Location location, Token token, Expr expr, Expr expr2) {
            super(location, token.toBinaryExprId());
            this.op = token;
            this.lhs = expr;
            this.rhs = expr2;
            this.type = expr.type;
        }

        @Override
        public boolean isAssign() {
            return this.op.isAssign();
        }

        @Override
        protected void doWalk(AstVisitor astVisitor) {
            this.lhs = this.lhs.walk(astVisitor);
            this.rhs = this.rhs.walk(astVisitor);
        }

        @Override
        public int maxStack() {
            int n = this.lhs.maxStack() + this.rhs.maxStack();
            if (this.isAssign()) {
                n += this.type.isWide() ? 2 : 1;
            }
            return n;
        }

        @Override
        public String toString() {
            return "(" + this.lhs + " " + this.op + " " + this.rhs + ")";
        }
    }

    public static class Unary
    extends Expr {
        public Token op;
        public Expr operand;

        public Unary(Location location, Token token, Expr expr) {
            this(location, token, expr, false);
        }

        public Unary(Location location, Token token, Expr expr, boolean bl) {
            super(location, token.toUnaryExprId(bl));
            this.op = token;
            this.operand = expr;
        }

        @Override
        public boolean isIncrDecr() {
            return this.isIncr() || this.isDecr();
        }

        public boolean isIncr() {
            return this.id == 23 || this.id == 25;
        }

        public boolean isDecr() {
            return this.id == 24 || this.id == 26;
        }

        public boolean isPrefix() {
            return this.id == 23 || this.id == 24;
        }

        public boolean isPostfix() {
            return this.id == 25 || this.id == 26;
        }

        @Override
        protected void doWalk(AstVisitor astVisitor) {
            this.operand = this.operand.walk(astVisitor);
        }

        @Override
        public int maxStack() {
            int n = this.operand.maxStack();
            if (this.id == 21) {
                ++n;
            }
            if (this.isIncrDecr()) {
                n += this.type.isWide() ? 4 : 2;
            }
            return n;
        }

        @Override
        public String toString() {
            if (this.isPostfix()) {
                return this.operand.toString() + this.op.toString();
            }
            return this.op.toString() + this.operand.toString();
        }
    }

    public static class Literal
    extends Expr {
        public Object value;

        public Literal(Location location, Namespace namespace, int n, Object object) {
            super(location, n);
            this.value = object;
            switch (n) {
                case 1: {
                    this.type = namespace.boolType;
                    break;
                }
                case 2: {
                    this.type = namespace.boolType;
                    break;
                }
                case 3: {
                    this.type = namespace.intType;
                    break;
                }
                case 4: {
                    this.type = namespace.longType;
                    break;
                }
                case 5: {
                    this.type = namespace.floatType;
                    break;
                }
                case 6: {
                    this.type = namespace.doubleType;
                    break;
                }
                case 7: {
                    this.type = namespace.longType;
                    break;
                }
                case 9: {
                    this.type = namespace.strType;
                    break;
                }
                case 10: {
                    this.type = namespace.bufType;
                    break;
                }
                case 11: {
                    this.type = namespace.typeType;
                    break;
                }
                case 12: {
                    this.type = namespace.slotType;
                    break;
                }
                case 8: {
                    this.type = namespace.objType;
                    break;
                }
                case 14: {
                    this.type = namespace.intType;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        public Literal(Location location, int n, Type type, Object object) {
            super(location, n);
            this.type = type;
            this.id = n;
            this.value = object;
        }

        @Override
        public boolean isLiteral() {
            return true;
        }

        @Override
        public Literal toLiteral() {
            return this;
        }

        public boolean isZero() {
            switch (this.id) {
                case 3: {
                    return this.asInt() == 0;
                }
                case 4: {
                    return this.asLong() == 0L;
                }
                case 5: {
                    return this.asFloat() == 0.0f;
                }
                case 6: {
                    return this.asDouble() == 0.0;
                }
                case 7: {
                    return this.asLong() == 0L;
                }
            }
            return false;
        }

        @Override
        public Integer toIntLiteral() {
            if (this.id == 3) {
                return (Integer)this.value;
            }
            return null;
        }

        public int asInt() {
            return (Integer)this.value;
        }

        public long asLong() {
            return (java.lang.Long)this.value;
        }

        public float asFloat() {
            return ((java.lang.Float)this.value).floatValue();
        }

        public double asDouble() {
            return (java.lang.Double)this.value;
        }

        public String asString() {
            return (String)this.value;
        }

        public Buf asBuf() {
            return (Buf)this.value;
        }

        public Type asType() {
            return (Type)this.value;
        }

        public Slot asSlot() {
            return (Slot)this.value;
        }

        public Object[] asArray() {
            return (Object[])this.value;
        }

        @Override
        protected void doWalk(AstVisitor astVisitor) {
        }

        public Value toValue() {
            switch (this.id) {
                case 1: {
                    return Bool.TRUE;
                }
                case 2: {
                    return Bool.FALSE;
                }
                case 3: {
                    return Int.make((int)this.asInt());
                }
                case 4: {
                    return Long.make((long)this.asLong());
                }
                case 5: {
                    return Float.make((float)this.asFloat());
                }
                case 6: {
                    return Double.make((double)this.asDouble());
                }
                case 7: {
                    return Long.make((long)this.asLong());
                }
                case 9: {
                    return Str.make((String)this.value.toString());
                }
                case 10: {
                    return Buf.fromString((String)this.asBuf().toString());
                }
                case 8: {
                    if (this.type.isBool()) {
                        return Bool.NULL;
                    }
                    if (this.type.isFloat()) {
                        return Float.NULL;
                    }
                    if (this.type.isDouble()) {
                        return Double.NULL;
                    }
                    throw new IllegalStateException("Cannot map null literal: " + this.type);
                }
            }
            throw new IllegalStateException("Cannot map to value: " + this);
        }

        @Override
        public String toCodeString() {
            switch (this.id) {
                case 8: {
                    return "null";
                }
                case 7: {
                    return this.value.toString() + "ns";
                }
                case 14: {
                    return this.asType().qname();
                }
            }
            return TypeUtil.toCodeString(this.value);
        }

        public Literal negate() {
            Number number;
            switch (this.id) {
                case 3: {
                    number = new Integer(-this.asInt());
                    break;
                }
                case 4: {
                    number = new java.lang.Long(-this.asLong());
                    break;
                }
                case 5: {
                    number = new java.lang.Float(-this.asFloat());
                    break;
                }
                case 6: {
                    number = new java.lang.Double(-this.asDouble());
                    break;
                }
                case 7: {
                    number = new java.lang.Long(-this.asLong());
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return new Literal(this.loc, this.id, this.type, (Object)number);
        }

        @Override
        public int maxStack() {
            return this.type.isWide() ? 2 : 1;
        }

        @Override
        public String toString() {
            return this.toCodeString();
        }
    }
}

