/*
 * Decompiled with CFR 0.152.
 */
package sedonac.analysis;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import sedonac.analysis.BasicBlock;
import sedonac.analysis.ControlFlowGraph;

class DepthFirstIterator
implements Iterator {
    protected HashSet visited = new HashSet();
    protected Stack stack = new Stack();

    public DepthFirstIterator(ControlFlowGraph controlFlowGraph) {
        this(controlFlowGraph.entry());
    }

    public DepthFirstIterator(BasicBlock basicBlock) {
        this.stack.push(basicBlock);
    }

    @Override
    public boolean hasNext() {
        return !this.stack.isEmpty();
    }

    public Object next() {
        BasicBlock basicBlock = (BasicBlock)this.stack.pop();
        this.visited.add(basicBlock);
        int n = basicBlock.jumpEdges.size();
        for (int i = 0; i < n; ++i) {
            Object e = basicBlock.jumpEdges.get(i);
            if (this.visited.contains(e)) continue;
            this.stack.push(e);
        }
        return basicBlock;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

