/*
 * Decompiled with CFR 0.152.
 */
package sedonac.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import sedonac.analysis.BasicBlock;
import sedonac.analysis.DepthFirstIterator;
import sedonac.analysis.ReversePostorderIterator;
import sedonac.ast.Block;
import sedonac.ast.MethodDef;
import sedonac.ast.Stmt;

public final class ControlFlowGraph {
    public final MethodDef method;
    private ArrayList blocks;
    private BasicBlock entryBlock;
    private BasicBlock exitBlock;
    private HashMap labels;
    private ArrayList exits;
    private Stack loopStack;

    private ControlFlowGraph(MethodDef methodDef) {
        this.method = methodDef;
        this.blocks = new ArrayList();
        this.labels = new HashMap();
        this.exits = new ArrayList();
        this.loopStack = new Stack();
        this.entryBlock = this.newBlock();
    }

    public static ControlFlowGraph make(MethodDef methodDef) {
        ControlFlowGraph controlFlowGraph = new ControlFlowGraph(methodDef);
        controlFlowGraph.buildGraph();
        return controlFlowGraph;
    }

    private void buildGraph() {
        if (this.method.code == null) {
            this.exitBlock = this.entryBlock;
            return;
        }
        this.exitBlock = this.block(this.entryBlock, this.method.code);
        while (!this.exits.isEmpty()) {
            BasicBlock basicBlock = (BasicBlock)this.exits.remove(0);
            this.addJump(basicBlock, this.exitBlock);
        }
    }

    private BasicBlock block(BasicBlock basicBlock, Block block) {
        if (block == null) {
            throw new IllegalStateException("empty codeBlock: " + this.method.qname);
        }
        BasicBlock basicBlock2 = basicBlock;
        Stmt[] stmtArray = block.stmts();
        for (int i = 0; i < stmtArray.length; ++i) {
            if (stmtArray[i].label != null) {
                basicBlock2 = this.label(basicBlock2, stmtArray[i].label);
            }
            basicBlock2 = this.stmt(basicBlock2, stmtArray[i]);
        }
        return basicBlock2;
    }

    private BasicBlock label(BasicBlock basicBlock, String string) {
        BasicBlock basicBlock2 = (BasicBlock)this.labels.get(string);
        if (basicBlock2 == null) {
            basicBlock2 = basicBlock;
            if (basicBlock.hasStmts()) {
                basicBlock2 = this.newBlock();
                this.addJump(basicBlock, basicBlock2);
            }
            this.labels.put(string, basicBlock2);
        } else {
            if (basicBlock2.hasStmts()) {
                throw new IllegalStateException("label block should be empty");
            }
            this.addJump(basicBlock, basicBlock2);
        }
        return basicBlock2;
    }

    private BasicBlock stmt(BasicBlock basicBlock, Stmt stmt) {
        switch (stmt.id) {
            case 1: 
            case 2: 
            case 11: {
                basicBlock.addStmt(stmt);
                return basicBlock;
            }
            case 4: {
                return this.ifStmt(basicBlock, (Stmt.If)stmt);
            }
            case 5: {
                return this.forStmt(basicBlock, (Stmt.For)stmt);
            }
            case 6: {
                return this.foreachStmt(basicBlock, (Stmt.Foreach)stmt);
            }
            case 7: {
                return this.whileStmt(basicBlock, (Stmt.While)stmt);
            }
            case 8: {
                return this.doWhileStmt(basicBlock, (Stmt.DoWhile)stmt);
            }
            case 13: {
                return this.switchStmt(basicBlock, (Stmt.Switch)stmt);
            }
            case 3: {
                return this.returnStmt(basicBlock, (Stmt.Return)stmt);
            }
            case 9: {
                return this.breakStmt(basicBlock, stmt);
            }
            case 10: {
                return this.continueStmt(basicBlock, stmt);
            }
            case 12: {
                return this.gotoStmt(basicBlock, (Stmt.Goto)stmt);
            }
        }
        throw new IllegalStateException("Unhandled statement id: " + stmt.id);
    }

    private BasicBlock returnStmt(BasicBlock basicBlock, Stmt.Return return_) {
        if (return_.expr == null && return_.loc.compareTo(this.method.loc) == 0) {
            if (basicBlock.hasStmts()) {
                this.exits.add(basicBlock);
                return this.newBlock();
            }
            return basicBlock;
        }
        basicBlock.addStmt(return_);
        this.exits.add(basicBlock);
        return this.newBlock();
    }

    private BasicBlock breakStmt(BasicBlock basicBlock, Stmt stmt) {
        basicBlock.addStmt(stmt);
        this.addJump(basicBlock, ((LoopItem)this.loopStack.peek()).breakTarget);
        return this.newBlock();
    }

    private BasicBlock continueStmt(BasicBlock basicBlock, Stmt stmt) {
        basicBlock.addStmt(stmt);
        this.addJump(basicBlock, ((LoopItem)this.loopStack.peek()).contTarget);
        return this.newBlock();
    }

    private BasicBlock gotoStmt(BasicBlock basicBlock, Stmt.Goto goto_) {
        basicBlock.addStmt(goto_);
        BasicBlock basicBlock2 = (BasicBlock)this.labels.get(goto_.destLabel);
        if (basicBlock2 == null) {
            basicBlock2 = this.newBlock();
            this.labels.put(goto_.destLabel, basicBlock2);
        }
        this.addJump(basicBlock, basicBlock2);
        return this.newBlock();
    }

    private BasicBlock ifStmt(BasicBlock basicBlock, Stmt.If if_) {
        basicBlock.addStmt(if_);
        BasicBlock basicBlock2 = this.newBlock();
        BasicBlock basicBlock3 = this.newBlock();
        BasicBlock basicBlock4 = null;
        BasicBlock basicBlock5 = null;
        BasicBlock basicBlock6 = null;
        if (2 != if_.cond.id) {
            this.addJump(basicBlock, basicBlock3);
        }
        basicBlock4 = this.block(basicBlock3, if_.trueBlock);
        this.addJump(basicBlock4, basicBlock2);
        if (if_.falseBlock == null) {
            if (1 != if_.cond.id) {
                this.addJump(basicBlock, basicBlock2);
            }
        } else {
            basicBlock5 = this.newBlock();
            if (1 != if_.cond.id) {
                this.addJump(basicBlock, basicBlock5);
            }
            basicBlock6 = this.block(basicBlock5, if_.falseBlock);
            this.addJump(basicBlock6, basicBlock2);
        }
        return basicBlock2;
    }

    private BasicBlock whileStmt(BasicBlock basicBlock, Stmt.While while_) {
        BasicBlock basicBlock2 = null;
        BasicBlock basicBlock3 = this.newBlock();
        BasicBlock basicBlock4 = this.newBlock();
        BasicBlock basicBlock5 = null;
        basicBlock2 = basicBlock.hasStmts() ? this.newBlock() : basicBlock;
        basicBlock2.addStmt(while_);
        if (basicBlock != basicBlock2) {
            this.addJump(basicBlock, basicBlock2);
        }
        if (while_.cond.id != 2) {
            this.addJump(basicBlock2, basicBlock4);
        }
        LoopItem loopItem = new LoopItem(basicBlock3, basicBlock2);
        this.loopStack.push(loopItem);
        basicBlock5 = this.block(basicBlock4, while_.block);
        if (this.loopStack.pop() != loopItem) {
            throw new IllegalStateException();
        }
        this.addJump(basicBlock5, basicBlock2);
        if (while_.cond.id != 1) {
            this.addJump(basicBlock2, basicBlock3);
        }
        return basicBlock3;
    }

    private BasicBlock doWhileStmt(BasicBlock basicBlock, Stmt.DoWhile doWhile) {
        BasicBlock basicBlock2 = null;
        BasicBlock basicBlock3 = null;
        BasicBlock basicBlock4 = this.newBlock();
        BasicBlock basicBlock5 = null;
        Stmt.DoWhile doWhile2 = new Stmt.DoWhile(doWhile.cond.loc);
        doWhile2.block = doWhile.block;
        doWhile2.cond = doWhile.cond;
        doWhile2.label = doWhile.label;
        doWhile = doWhile2;
        basicBlock2 = basicBlock.hasStmts() ? this.newBlock() : basicBlock;
        basicBlock3 = basicBlock2;
        if (basicBlock != basicBlock2) {
            this.addJump(basicBlock, basicBlock2);
        }
        if (!doWhile.block.isEmpty()) {
            basicBlock3 = this.newBlock();
            LoopItem loopItem = new LoopItem(basicBlock4, basicBlock3);
            this.loopStack.push(loopItem);
            basicBlock5 = this.block(basicBlock2, doWhile.block);
            if (this.loopStack.pop() != loopItem) {
                throw new IllegalStateException();
            }
            this.addJump(basicBlock5, basicBlock3);
        }
        basicBlock3.addStmt(doWhile);
        if (1 != doWhile.cond.id) {
            this.addJump(basicBlock3, basicBlock4);
        }
        if (2 != doWhile.cond.id) {
            this.addJump(basicBlock3, basicBlock2);
        }
        return basicBlock4;
    }

    private BasicBlock switchStmt(BasicBlock basicBlock, Stmt.Switch switch_) {
        BasicBlock basicBlock2 = this.newBlock();
        BasicBlock basicBlock3 = null;
        BasicBlock basicBlock4 = null;
        basicBlock.addStmt(switch_);
        LoopItem loopItem = new LoopItem(basicBlock2, basicBlock2);
        this.loopStack.push(loopItem);
        for (int i = 0; i < switch_.cases.length; ++i) {
            if (switch_.cases[i].block == null) continue;
            basicBlock3 = this.newBlock();
            this.addJump(basicBlock, basicBlock3);
            if (basicBlock4 != null) {
                this.addJump(basicBlock4, basicBlock3);
            }
            basicBlock4 = this.block(basicBlock3, switch_.cases[i].block);
        }
        if (switch_.defaultBlock == null) {
            this.addJump(basicBlock, basicBlock2);
            if (basicBlock4 != null) {
                this.addJump(basicBlock4, basicBlock2);
            }
        } else {
            basicBlock3 = this.newBlock();
            this.addJump(basicBlock, basicBlock3);
            if (basicBlock4 != null) {
                this.addJump(basicBlock4, basicBlock3);
            }
            basicBlock4 = this.block(basicBlock3, switch_.defaultBlock);
            this.addJump(basicBlock4, basicBlock2);
        }
        if (this.loopStack.pop() != loopItem) {
            throw new IllegalStateException();
        }
        return basicBlock2;
    }

    private BasicBlock forStmt(BasicBlock basicBlock, Stmt.For for_) {
        BasicBlock basicBlock2 = null;
        BasicBlock basicBlock3 = null;
        BasicBlock basicBlock4 = null;
        BasicBlock basicBlock5 = null;
        BasicBlock basicBlock6 = this.newBlock();
        if (for_.init != null) {
            basicBlock.addStmt(for_.init);
        }
        BasicBlock basicBlock7 = basicBlock2 = basicBlock.hasStmts() ? this.newBlock() : basicBlock;
        if (basicBlock != basicBlock2) {
            this.addJump(basicBlock, basicBlock2);
        }
        basicBlock2.addStmt(for_);
        basicBlock3 = basicBlock2;
        if (for_.update != null) {
            basicBlock3 = this.newBlock();
            basicBlock3.addStmt(new Stmt.ExprStmt(for_.update.loc, for_.update));
            this.addJump(basicBlock3, basicBlock2);
        }
        if (!for_.block.isEmpty()) {
            basicBlock4 = this.newBlock();
            LoopItem loopItem = new LoopItem(basicBlock6, basicBlock3);
            this.loopStack.push(loopItem);
            basicBlock5 = this.block(basicBlock4, for_.block);
            this.addJump(basicBlock5, basicBlock3);
            if (this.loopStack.pop() != loopItem) {
                throw new IllegalStateException();
            }
            if (for_.cond == null || 2 != for_.cond.id) {
                this.addJump(basicBlock2, basicBlock4);
            }
        } else {
            this.addJump(basicBlock2, basicBlock3);
        }
        if (for_.cond != null && 1 != for_.cond.id) {
            this.addJump(basicBlock2, basicBlock6);
        }
        return basicBlock6;
    }

    private BasicBlock foreachStmt(BasicBlock basicBlock, Stmt.Foreach foreach) {
        BasicBlock basicBlock2 = basicBlock.hasStmts() ? this.newBlock() : basicBlock;
        BasicBlock basicBlock3 = this.newBlock();
        BasicBlock basicBlock4 = null;
        BasicBlock basicBlock5 = this.newBlock();
        basicBlock2.addStmt(foreach);
        if (basicBlock != basicBlock2) {
            this.addJump(basicBlock, basicBlock2);
        }
        this.addJump(basicBlock2, basicBlock3);
        LoopItem loopItem = new LoopItem(basicBlock5, basicBlock2);
        this.loopStack.push(loopItem);
        basicBlock4 = this.block(basicBlock3, foreach.block);
        if (this.loopStack.pop() != loopItem) {
            throw new IllegalStateException();
        }
        this.addJump(basicBlock4, basicBlock2);
        this.addJump(basicBlock2, basicBlock5);
        return basicBlock5;
    }

    public BasicBlock entry() {
        return this.entryBlock;
    }

    public BasicBlock exit() {
        return this.exitBlock;
    }

    public int size() {
        return this.blocks.size();
    }

    public BasicBlock[] asArray() {
        return this.blocks.toArray(new BasicBlock[this.blocks.size()]);
    }

    public HashSet asSet() {
        return new HashSet(this.blocks);
    }

    private BasicBlock newBlock() {
        BasicBlock basicBlock = new BasicBlock();
        this.blocks.add(basicBlock);
        return basicBlock;
    }

    private void addJump(BasicBlock basicBlock, BasicBlock basicBlock2) {
        if (!basicBlock.hasStmts()) {
            while (!basicBlock.backEdges.isEmpty()) {
                BasicBlock basicBlock3 = (BasicBlock)basicBlock.backEdges.get(0);
                basicBlock3.removeJump(basicBlock);
                basicBlock3.addJump(basicBlock2);
            }
            if (this.labels.entrySet().contains(basicBlock)) {
                throw new IllegalStateException(basicBlock.toString());
            }
            this.blocks.remove(basicBlock);
        } else {
            basicBlock.addJump(basicBlock2);
            if (!this.blocks.contains(basicBlock)) {
                this.blocks.add(basicBlock);
            }
        }
        if (!this.blocks.contains(basicBlock2)) {
            this.blocks.add(basicBlock2);
        }
    }

    public Iterator depthFirstIterator() {
        return new DepthFirstIterator(this);
    }

    public Iterator reversePostorderIterator() {
        return new ReversePostorderIterator(this);
    }

    private class LoopItem {
        public final BasicBlock breakTarget;
        public final BasicBlock contTarget;

        public LoopItem(BasicBlock basicBlock, BasicBlock basicBlock2) {
            this.breakTarget = basicBlock;
            this.contTarget = basicBlock2;
        }
    }
}

