/*
 * Decompiled with CFR 0.152.
 */
package sedonac;

import sedonac.Compiler;
import sedonac.CompilerSupport;
import sedonac.ast.FieldDef;
import sedonac.ast.MethodDef;
import sedonac.ast.TypeDef;

public abstract class CompilerStep
extends CompilerSupport {
    public TypeDef curType;
    public MethodDef curMethod;
    public boolean inStatic;

    public CompilerStep(Compiler compiler) {
        super(compiler);
    }

    public abstract void run();

    public void walkAst(int n) {
        TypeDef[] typeDefArray = this.compiler.ast.types;
        for (int i = 0; i < typeDefArray.length; ++i) {
            typeDefArray[i].walk(this, n);
        }
    }

    @Override
    public void enterType(TypeDef typeDef) {
        super.enterType(typeDef);
        this.curType = typeDef;
    }

    @Override
    public void exitType(TypeDef typeDef) {
        super.exitType(typeDef);
        this.curType = null;
    }

    @Override
    public void enterField(FieldDef fieldDef) {
        super.enterField(fieldDef);
        this.inStatic = fieldDef.isStatic();
    }

    @Override
    public void exitField(FieldDef fieldDef) {
        super.exitField(fieldDef);
    }

    @Override
    public void enterMethod(MethodDef methodDef) {
        super.enterMethod(methodDef);
        this.curMethod = methodDef;
        this.inStatic = methodDef.isStatic();
    }

    @Override
    public void exitMethod(MethodDef methodDef) {
        super.exitMethod(methodDef);
        this.curMethod = null;
    }
}

