/*
 * Decompiled with CFR 0.152.
 */
package sedonac.translate;

import java.io.File;
import java.util.HashMap;
import sedonac.Compiler;
import sedonac.ast.FieldDef;
import sedonac.ast.MethodDef;
import sedonac.ast.TypeDef;
import sedonac.translate.CTranslator;

public class HTranslator
extends CTranslator {
    public HTranslator(Compiler compiler, TypeDef typeDef) {
        super(compiler, typeDef);
    }

    @Override
    public File toFile() {
        return new File(this.outDir, this.qname(this.type) + ".h");
    }

    @Override
    public void doTranslate() {
        String string = "__" + this.qname(this.type).toUpperCase() + "_H";
        this.w("#ifndef ").w(string).nl();
        this.w("#define ").w(string).nl();
        this.w("").nl();
        this.w("#include \"sedona.h\"").nl();
        this.includes();
        this.w("").nl();
        this.structForward();
        this.w("").nl();
        this.staticFieldForwards();
        this.w("").nl();
        this.methodForwards();
        this.w("").nl();
        this.w("#endif").nl().nl();
    }

    @Override
    public void findIncludes(HashMap hashMap, FieldDef fieldDef) {
        this.addInclude(hashMap, fieldDef.type);
    }

    @Override
    public void findIncludes(HashMap hashMap, MethodDef methodDef) {
        this.addInclude(hashMap, methodDef.ret);
        for (int i = 0; i < methodDef.params.length; ++i) {
            this.addInclude(hashMap, methodDef.params[i].type);
        }
    }

    public void structForward() {
        this.w("typedef struct").nl();
        this.w("{").nl();
        FieldDef[] fieldDefArray = this.type.fieldDefs();
        int n = 0;
        for (int i = 0; i < fieldDefArray.length; ++i) {
            FieldDef fieldDef = fieldDefArray[i];
            if (fieldDef.isStatic()) continue;
            this.structField(fieldDef);
            ++n;
        }
        if (n == 0) {
            this.w("  uint8_t dummy;").nl();
        }
        this.w("} ").nl();
        this.w(this.qname(this.type)).w(";").nl();
    }

    public void structField(FieldDef fieldDef) {
        this.w("  ").wtype(fieldDef.type);
        if (fieldDef.type.isRef() && !fieldDef.isInline()) {
            this.w("*");
        }
        this.w(" ").w(fieldDef.name).w(";").nl();
    }

    public void staticFieldForwards() {
        FieldDef[] fieldDefArray = this.type.fieldDefs();
        for (int i = 0; i < fieldDefArray.length; ++i) {
            FieldDef fieldDef = fieldDefArray[i];
            if (!fieldDef.isStatic()) continue;
            this.w("extern ");
            this.fieldSig(fieldDef);
            this.w(";").nl();
        }
    }

    public void methodForwards() {
        MethodDef[] methodDefArray = this.type.methodDefs();
        for (int i = 0; i < methodDefArray.length; ++i) {
            MethodDef methodDef = methodDefArray[i];
            this.w("extern ");
            this.methodSig(methodDef);
            this.w(";").nl();
        }
    }
}

