/*
 * Decompiled with CFR 0.152.
 */
package sedonac.test;

import java.io.File;
import java.net.InetAddress;
import sedona.Constants;
import sedona.KitPart;
import sedona.Schema;
import sedona.Type;
import sedona.offline.OfflineApp;
import sedona.offline.OfflineComponent;
import sedona.sox.SoxClient;
import sedona.util.FileUtil;
import sedonac.test.AbstractSoxTest;

public class PstoreTest
extends AbstractSoxTest
implements Constants {
    OfflineApp app;
    OfflineComponent plat;
    OfflineComponent sox;
    OfflineComponent users;
    OfflineComponent admin;
    OfflineComponent pstore;
    OfflineComponent a;
    OfflineComponent b;
    OfflineComponent c;
    OfflineComponent badOff1;
    OfflineComponent badOff2;
    OfflineComponent badSize1;
    OfflineComponent badSize2;
    OfflineComponent badDup1;
    OfflineComponent badDup2;
    OfflineComponent badDup3;
    OfflineComponent badDup4;
    OfflineComponent badParent;

    @Override
    public void test() throws Exception {
        FileUtil.delete((File)this.testDir(), null);
        super.test();
    }

    @Override
    public void doTest() throws Exception {
        this.client = new SoxClient(this.sock, InetAddress.getLocalHost(), 1876, "admin", "pw");
        this.client.connect(null);
        System.out.println("Connected to pstore VM");
        this.verifyStatus();
        this.verifyReadWrite();
        this.verifyResvChange();
        this.client.close();
    }

    public void verifyStatus() throws Exception {
        this.verifyEq(this.readByte(this.a, "status"), 0);
        this.verifyEq(this.readByte(this.b, "status"), 0);
        this.verifyEq(this.readByte(this.c, "status"), 0);
        this.verifyEq(this.readByte(this.badParent, "status"), 2);
        this.verifyEq(this.readByte(this.badOff1, "status"), 4);
        this.verifyEq(this.readByte(this.badOff2, "status"), 4);
        this.verifyEq(this.readByte(this.badSize1, "status"), 5);
        this.verifyEq(this.readByte(this.badSize2, "status"), 5);
        this.verifyEq(this.readByte(this.badDup1, "status"), 6);
        this.verifyEq(this.readByte(this.badDup2, "status"), 6);
        this.verifyEq(this.readByte(this.badDup3, "status"), 6);
        this.verifyEq(this.readByte(this.badDup4, "status"), 6);
    }

    public void verifyReadWrite() throws Exception {
        this.verifyReadWrite(this.a);
        this.verifyReadWrite(this.b);
        this.verifyReadWrite(this.c);
    }

    public void verifyReadWrite(OfflineComponent offlineComponent) throws Exception {
        char c = offlineComponent.name().charAt(0);
        this.verifyRemote(offlineComponent, "verifyOwner", 0);
        this.verifyRemote(offlineComponent, "verifyClaim", 1);
        this.verifyRemote(offlineComponent, "verifyOwner", 1);
        this.verifyRemote(offlineComponent, "verifyTell", 0);
        this.verifyRemote(offlineComponent, "verifyWrite", 97, 1);
        this.verifyRemote(offlineComponent, "verifyTell", 1);
        this.verifyRemote(offlineComponent, "verifyWrite", 98, 1);
        this.verifyRemote(offlineComponent, "verifyTell", 2);
        this.verifyRemote(offlineComponent, "verifyWrite", 99, 1);
        this.verifyRemote(offlineComponent, "verifyTell", 3);
        this.verifyRemote(offlineComponent, "verifyWriteI4", -1425814513, 1);
        this.verifyRemote(offlineComponent, "verifyTell", 7);
        this.verifyRemote(offlineComponent, "verifySeek", 99, 1);
        this.verifyRemote(offlineComponent, "verifyTell", 99);
        this.verifyRemote(offlineComponent, "verifyWrite", c, 1);
        this.verifyRemote(offlineComponent, "verifyTell", 100);
        this.verifyRemote(offlineComponent, "verifySeek", 0, 1);
        this.verifyRemote(offlineComponent, "verifyTell", 0);
        this.verifyRemote(offlineComponent, "verifyRead", 97);
        this.verifyRemote(offlineComponent, "verifyRead", 98);
        this.verifyRemote(offlineComponent, "verifyRead", 99);
        this.verifyRemote(offlineComponent, "verifyReadS4", -1425814513);
        this.verifyRemote(offlineComponent, "verifySeek", 99, 1);
        this.verifyRemote(offlineComponent, "verifyTell", 99);
        this.verifyRemote(offlineComponent, "verifyRead", c);
    }

    void verifyRemote(OfflineComponent offlineComponent, String string, int n, int n2) throws Exception {
        this.invoke(offlineComponent, string, n);
        this.verifyEq(this.readInt(offlineComponent, "result"), n2);
    }

    void verifyRemote(OfflineComponent offlineComponent, String string, int n) throws Exception {
        this.invoke(offlineComponent, string, null);
        this.verifyEq(this.readInt(offlineComponent, "result"), n);
    }

    public void verifyResvChange() throws Exception {
        this.verifyEq(this.readByte(this.b, "status"), 0);
        this.write(this.b, "resvSize", 0);
        Thread.sleep(100L);
        this.verifyEq(this.readByte(this.b, "status"), 5);
        this.write(this.b, "resvSize", 150);
        Thread.sleep(100L);
        this.verifyEq(this.readByte(this.b, "status"), 6);
        this.write(this.b, "resvSize", 100);
        Thread.sleep(100L);
        this.verifyEq(this.readByte(this.b, "status"), 0);
        this.write(this.c, "resvOffset", 150);
        Thread.sleep(100L);
        this.verifyEq(this.readByte(this.b, "status"), 0);
        this.verifyEq(this.readByte(this.c, "status"), 6);
        this.write(this.c, "resvOffset", 200);
        Thread.sleep(100L);
        this.verifyEq(this.readByte(this.b, "status"), 0);
        this.verifyEq(this.readByte(this.c, "status"), 0);
    }

    @Override
    public OfflineApp buildApp() throws Exception {
        this.schema = Schema.load((KitPart[])new KitPart[]{KitPart.forLocalKit((String)"sys"), KitPart.forLocalKit((String)"sox"), KitPart.forLocalKit((String)"inet"), KitPart.forLocalKit((String)"pstore")});
        this.app = new OfflineApp(this.schema);
        this.app.setInt("meta", 15);
        this.plat = this.app.add((OfflineComponent)this.app, new OfflineComponent(this.schema.type("sys::PlatformService"), "plat"));
        this.sox = this.app.add((OfflineComponent)this.app, new OfflineComponent(this.schema.type("sox::SoxService"), "sox"));
        this.users = this.app.add((OfflineComponent)this.app, new OfflineComponent(this.schema.type("sys::UserService"), "users"));
        this.admin = this.addAdmin(this.users, "admin", "pw");
        this.pstore = this.app.add((OfflineComponent)this.app, new OfflineComponent(this.schema.type("pstore::PstoreService"), "pstore"));
        this.a = this.addFile(this.pstore, "a", 0, 100);
        this.b = this.addFile(this.pstore, "b", 100, 100);
        this.c = this.addFile(this.pstore, "c", 200, 100);
        this.badOff1 = this.addFile(this.pstore, "badOff1", -100, 10);
        this.badOff2 = this.addFile(this.pstore, "badOff2", 800000, 10);
        this.badSize1 = this.addFile(this.pstore, "badSz1", 300, 0);
        this.badSize2 = this.addFile(this.pstore, "badSz2", 300, 800000);
        this.badDup1 = this.addFile(this.pstore, "badDup1", 1000, 21);
        this.badDup2 = this.addFile(this.pstore, "badDup2", 1020, 50);
        this.badDup3 = this.addFile(this.pstore, "badDup3", 1020, 100);
        this.badDup4 = this.addFile(this.pstore, "badDup4", 1040, 10);
        this.badParent = this.addFile((OfflineComponent)this.app, "badPar", 300, 1);
        this.app.assignIds();
        return this.app;
    }

    OfflineComponent addFile(OfflineComponent offlineComponent, String string, int n, int n2) {
        Type type = this.schema.type("pstore::TestPstoreFile");
        OfflineComponent offlineComponent2 = new OfflineComponent(type, string);
        offlineComponent2.setInt("resvOffset", n);
        offlineComponent2.setInt("resvSize", n2);
        this.app.add(offlineComponent, offlineComponent2);
        return offlineComponent2;
    }
}

