/*
 * Decompiled with CFR 0.152.
 */
package sedonac.test;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import sedona.Depend;
import sedona.kit.KitDb;
import sedona.kit.KitFile;
import sedona.util.FileUtil;
import sedona.util.Version;
import sedonac.test.Test;

public class KitDbTest
extends Test {
    public void testDependParse() throws Exception {
        Depend depend = Depend.parse((String)"foo 1.2.3");
        this.verifyEq(depend.size(), 1);
        this.verifyDepend(depend, 0, new Version("1.2.3"), false, false, null, -1);
        depend = Depend.parse((String)"foo 1.2.3+");
        this.verifyEq(depend.size(), 1);
        this.verifyDepend(depend, 0, new Version("1.2.3"), true, false, null, -1);
        depend = Depend.parse((String)"foo 1.2.3=");
        this.verifyEq(depend.size(), 1);
        this.verifyDepend(depend, 0, new Version("1.2.3"), false, true, null, -1);
        depend = Depend.parse((String)"foo 1.2.3-1.2.4");
        this.verifyEq(depend.size(), 1);
        this.verifyDepend(depend, 0, new Version("1.2.3"), false, false, new Version("1.2.4"), -1);
        depend = Depend.makeChecksum((String)"foo", (int)-1122868);
        this.verifyEq(depend.size(), 1);
        this.verifyDepend(depend, 0, null, false, false, null, -1122868);
        depend = Depend.parse((String)"foo 10.20, 10.30");
        this.verifyEq(depend.size(), 2);
        this.verifyDepend(depend, 0, new Version("10.20"), false, false, null, -1);
        this.verifyDepend(depend, 1, new Version("10.30"), false, false, null, -1);
        depend = Depend.parse((String)"foo 10+, 0x12345678, 20-30");
        this.verifyEq(depend.size(), 3);
        this.verifyDepend(depend, 0, new Version("10"), true, false, null, -1);
        this.verifyDepend(depend, 1, null, false, false, null, 305419896);
        this.verifyDepend(depend, 2, new Version("20"), false, false, new Version("30"), -1);
    }

    void verifyDepend(Depend depend, int n, Version version, boolean bl, boolean bl2, Version version2, int n2) {
        this.verifyEq(depend.name(), "foo");
        this.verifyEq(depend.version(n), version);
        this.verifyEq(depend.isPlus(n), bl);
        this.verifyEq(depend.isExact(n), bl2);
        this.verifyEq(depend.endVersion(n), version2);
        this.verifyEq(depend.checksum(n), n2);
        String string = depend.toString();
        Depend depend2 = Depend.parse((String)string);
        this.verifyEq(depend2.name(), "foo");
        this.verifyEq(depend2.version(n), version);
        this.verifyEq(depend2.isPlus(n), bl);
        this.verifyEq(depend2.isExact(n), bl2);
        this.verifyEq(depend2.endVersion(n), version2);
        this.verifyEq(depend2.checksum(n), n2);
    }

    public void testDependMatch() throws Exception {
        Depend depend = Depend.parse((String)"foo 1.2");
        this.verifyEq(depend.match(new Version("1")), false);
        this.verifyEq(depend.match(new Version("1.2")), true);
        this.verifyEq(depend.match(new Version("1.2.0")), true);
        this.verifyEq(depend.match(new Version("1.2.20")), true);
        this.verifyEq(depend.match(new Version("1.3")), false);
        this.verifyEq(depend.match(new Version("2")), false);
        this.verifyEq(depend.match(new Version("10.3")), false);
        this.verifyEq(depend.match(-1430532899), false);
        this.verifyEq(depend.match(new Version("1.2"), -1430532899), true);
        this.verifyEq(depend.match(new Version("1.3"), -1430532899), false);
        depend = Depend.parse((String)"foo 1.2+");
        this.verifyEq(depend.match(new Version("1")), false);
        this.verifyEq(depend.match(new Version("1.1")), false);
        this.verifyEq(depend.match(new Version("1.1.3")), false);
        this.verifyEq(depend.match(new Version("1.2")), true);
        this.verifyEq(depend.match(new Version("1.2.0")), true);
        this.verifyEq(depend.match(new Version("1.2.20.3")), true);
        this.verifyEq(depend.match(new Version("1.3")), true);
        this.verifyEq(depend.match(new Version("2")), true);
        this.verifyEq(depend.match(new Version("10.3")), true);
        this.verifyEq(depend.match(-1430532899), false);
        this.verifyEq(depend.match(new Version("1.2.3"), -1430532899), true);
        this.verifyEq(depend.match(new Version("1.0"), -1430532899), false);
        depend = Depend.parse((String)"foo 1.2=");
        this.verifyEq(depend.match(new Version("1")), false);
        this.verifyEq(depend.match(new Version("1.2")), true);
        this.verifyEq(depend.match(new Version("1.2.1")), false);
        this.verifyEq(depend.match(new Version("1.2"), -1430532899), true);
        this.verifyEq(depend.match(-1430532899), false);
        this.verifyEq(depend.match(new Version("1"), -1430532899), false);
        depend = Depend.parse((String)"foo 1.2=,0xaabbccdd");
        this.verifyEq(depend.match(new Version("1.2"), -1430532899), true);
        this.verifyEq(depend.match(new Version("1.2"), -4469539), false);
        this.verifyEq(depend.match(new Version("1"), -1430532899), false);
        depend = Depend.parse((String)"foo 3.2-3.4");
        this.verifyEq(depend.match(new Version("1.1")), false);
        this.verifyEq(depend.match(new Version("3.1")), false);
        this.verifyEq(depend.match(new Version("3.2")), true);
        this.verifyEq(depend.match(new Version("3.2.10")), true);
        this.verifyEq(depend.match(new Version("3.3.99")), true);
        this.verifyEq(depend.match(new Version("3.4")), true);
        this.verifyEq(depend.match(new Version("3.4.456")), true);
        this.verifyEq(depend.match(new Version("3.5")), false);
        this.verifyEq(depend.match(-1430532899), false);
        this.verifyEq(depend.match(new Version("3.2.11"), -1430532899), true);
        this.verifyEq(depend.match(new Version("1.0"), -1430532899), false);
        depend = Depend.parse((String)"foo 0xaabbccdd");
        this.verifyEq(depend.match(new Version("1.1")), false);
        this.verifyEq(depend.match(new Version("3.1")), false);
        this.verifyEq(depend.match(-1430532899), true);
        this.verifyEq(depend.match(-1430532897), false);
        this.verifyEq(depend.match(new Version("1.1"), -1430532899), true);
        this.verifyEq(depend.match(new Version("1.1"), -1430532897), false);
        depend = Depend.parse((String)"foo 1.2, 0xaabbccdd");
        this.verifyEq(depend.match(new Version("1.1")), false);
        this.verifyEq(depend.match(new Version("1.2")), true);
        this.verifyEq(depend.match(-1430532899), true);
        this.verifyEq(depend.match(new Version("1.1"), -1430532899), false);
        this.verifyEq(depend.match(new Version("1.2"), -1430532897), false);
        this.verifyEq(depend.match(new Version("1.2"), -1430532899), true);
        depend = Depend.parse((String)"foo 3.2, 3.4+, 0xaabbccdd");
        this.verifyEq(depend.match(new Version("1.1")), false);
        this.verifyEq(depend.match(new Version("3.1")), false);
        this.verifyEq(depend.match(new Version("3.2")), true);
        this.verifyEq(depend.match(new Version("3.2.10")), true);
        this.verifyEq(depend.match(new Version("3.3.99")), false);
        this.verifyEq(depend.match(new Version("3.4")), true);
        this.verifyEq(depend.match(new Version("3.4.456")), true);
        this.verifyEq(depend.match(new Version("3.5")), true);
        this.verifyEq(depend.match(-1430532899), true);
        this.verifyEq(depend.match(-1430532897), false);
        this.verifyEq(depend.match(new Version("1.0"), -1430532897), false);
        this.verifyEq(depend.match(new Version("1.0"), -1430532899), false);
        this.verifyEq(depend.match(new Version("3.2.1"), -1430532897), false);
        this.verifyEq(depend.match(new Version("3.2.1"), -1430532899), true);
        this.verifyEq(depend.match(new Version("3.4"), -1430532899), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testKitDb() throws Exception {
        File file = new File(KitDb.dir, "testKitDb");
        file.mkdirs();
        try {
            this.makeKitFile(file, 305419896, "1.0.3400");
            this.makeKitFile(file, 305419896, "1.0.3400.1");
            this.makeKitFile(file, 305419896, "1.0.3401");
            this.makeKitFile(file, 305419896, "1.0.3402");
            this.makeKitFile(file, -1431655766, "1.0.3403");
            this.makeKitFile(file, -1431655766, "1.1.3500");
            this.makeKitFile(file, -1145324613, "1.1.3501");
            this.makeKitFile(file, -858993460, "1.2.3600");
            KitFile[] kitFileArray = KitDb.list((String)"testKitDb");
            this.verifyEq(kitFileArray.length, 8);
            this.verifyKitFile(kitFileArray[0], 305419896, "1.0.3400.1");
            this.verifyKitFile(kitFileArray[1], 305419896, "1.0.3400");
            this.verifyKitFile(kitFileArray[2], 305419896, "1.0.3401");
            this.verifyKitFile(kitFileArray[3], 305419896, "1.0.3402");
            this.verifyKitFile(kitFileArray[4], -1431655766, "1.0.3403");
            this.verifyKitFile(kitFileArray[5], -1431655766, "1.1.3500");
            this.verifyKitFile(kitFileArray[6], -1145324613, "1.1.3501");
            this.verifyKitFile(kitFileArray[7], -858993460, "1.2.3600");
            kitFileArray = KitDb.matchAll((Depend)Depend.parse((String)"testKitDb 1.0"));
            this.verifyEq(kitFileArray.length, 5);
            this.verifyKitFile(kitFileArray[0], 305419896, "1.0.3400.1");
            this.verifyKitFile(kitFileArray[1], 305419896, "1.0.3400");
            this.verifyKitFile(kitFileArray[2], 305419896, "1.0.3401");
            this.verifyKitFile(kitFileArray[3], 305419896, "1.0.3402");
            this.verifyKitFile(kitFileArray[4], -1431655766, "1.0.3403");
            kitFileArray = KitDb.matchAll((Depend)Depend.parse((String)"testKitDb 1.1+"));
            this.verifyEq(kitFileArray.length, 3);
            this.verifyKitFile(kitFileArray[0], -1431655766, "1.1.3500");
            this.verifyKitFile(kitFileArray[1], -1145324613, "1.1.3501");
            this.verifyKitFile(kitFileArray[2], -858993460, "1.2.3600");
            kitFileArray = KitDb.matchAll((Depend)Depend.parse((String)"testKitDb 0xaaaaaaaa"));
            this.verifyEq(kitFileArray.length, 2);
            this.verifyKitFile(kitFileArray[0], -1431655766, "1.0.3403");
            this.verifyKitFile(kitFileArray[1], -1431655766, "1.1.3500");
            KitFile kitFile = KitDb.matchBest((String)"testKitDb");
            this.verifyKitFile(kitFile, -858993460, "1.2.3600");
            kitFile = KitDb.matchBest((Depend)Depend.parse((String)"testKitDb 1.0"));
            this.verifyKitFile(kitFile, -1431655766, "1.0.3403");
            kitFile = KitDb.matchBest((Depend)Depend.parse((String)"testKitDb 1.1+"));
            this.verifyKitFile(kitFile, -858993460, "1.2.3600");
            kitFile = KitDb.matchBest((Depend)Depend.parse((String)"testKitDb 0x12345678"));
            this.verifyKitFile(kitFile, 305419896, "1.0.3402");
            kitFile = KitDb.matchBest((Depend)Depend.parse((String)"testKitDb 1.3"));
            this.verify(kitFile == null);
            kitFile = KitDb.matchBest((Depend)Depend.parse((String)"testKitDb 1.0.3400="));
            this.verifyKitFile(kitFile, 305419896, "1.0.3400");
            kitFile = KitDb.matchBest((Depend)Depend.parse((String)"testKitDb 1.0.3400.1="));
            this.verifyKitFile(kitFile, 305419896, "1.0.3400.1");
            kitFile = KitDb.matchBest((Depend)Depend.parse((String)"testKitDb 1.0="));
            this.verify(kitFile == null);
        }
        finally {
            FileUtil.delete((File)file, null);
        }
    }

    void verifyKitFile(KitFile kitFile, int n, String string) {
        this.verifyEq(kitFile.name, "testKitDb");
        this.verifyEq(kitFile.checksum, n);
        this.verifyEq(kitFile.version.toString(), string);
        this.verifyEq(kitFile.exists(), true);
    }

    void makeKitFile(File file, int n, String string) throws Exception {
        File file2 = new File(file, file.getName() + "-" + Integer.toHexString(n) + "-" + string + ".kit");
        PrintWriter printWriter = new PrintWriter(new FileWriter(file2));
        printWriter.print("dummy test file");
        printWriter.close();
    }
}

