/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import sedona.kit.KitDb;
import sedona.manifest.KitManifest;
import sedona.util.FileUtil;
import sedona.util.Version;
import sedona.xml.XWriter;
import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.Location;
import sedonac.SourceFile;
import sedonac.ast.IncludeDef;
import sedonac.ir.IrKit;
import sedonac.ir.IrType;
import sedonac.ir.IrWriter;
import sedonac.jasm.JavaClass;

public class WriteKit
extends CompilerStep {
    public WriteKit(Compiler compiler) {
        super(compiler);
    }

    @Override
    public void run() {
        IrKit irKit = this.compiler.ir;
        KitManifest kitManifest = this.compiler.manifest;
        File file = KitDb.toFile((String)irKit.name, (int)kitManifest.checksum, (Version)kitManifest.version);
        File file2 = file.getParentFile();
        this.log.info("  WriteKit [" + file + "]");
        try {
            int n;
            file2.mkdirs();
            ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            this.writeManifest(zipOutputStream, irKit);
            for (n = 0; n < irKit.types.length; ++n) {
                this.writeType(zipOutputStream, irKit.types[n]);
            }
            for (n = 0; n < this.compiler.java.length; ++n) {
                this.writeJava(zipOutputStream, this.compiler.java[n]);
            }
            if (this.compiler.ast.includeSource) {
                this.writeSource(zipOutputStream);
            }
            zipOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw this.err("Cannot write kit file", new Location(file));
        }
    }

    private void writeManifest(ZipOutputStream zipOutputStream, IrKit irKit) throws IOException {
        zipOutputStream.putNextEntry(new ZipEntry("manifest.xml"));
        XWriter xWriter = new XWriter((OutputStream)zipOutputStream);
        this.compiler.manifest.encodeXml(xWriter);
        xWriter.flush();
        zipOutputStream.closeEntry();
    }

    private void writeType(ZipOutputStream zipOutputStream, IrType irType) throws IOException {
        zipOutputStream.putNextEntry(new ZipEntry(irType.name + ".ir"));
        IrWriter irWriter = new IrWriter(zipOutputStream);
        irWriter.writeType(irType);
        irWriter.flush();
        zipOutputStream.closeEntry();
    }

    private void writeJava(ZipOutputStream zipOutputStream, JavaClass javaClass) throws IOException {
        zipOutputStream.putNextEntry(new ZipEntry(javaClass.path()));
        zipOutputStream.write(javaClass.classfile.bytes, 0, javaClass.classfile.count);
        zipOutputStream.closeEntry();
    }

    private void writeSource(ZipOutputStream zipOutputStream) throws Exception {
        SourceFile[] sourceFileArray = this.compiler.sourceFiles;
        HashMap hashMap = new HashMap();
        for (int i = 0; i < sourceFileArray.length; ++i) {
            this.writeSource(zipOutputStream, sourceFileArray[i].file.getName(), new FileInputStream(sourceFileArray[i].file), hashMap);
        }
        IncludeDef[] includeDefArray = this.compiler.ast.includes;
        for (int i = 0; i < includeDefArray.length; ++i) {
            this.writeSource(zipOutputStream, includeDefArray[i], hashMap);
        }
    }

    private void writeSource(ZipOutputStream zipOutputStream, IncludeDef includeDef, HashMap hashMap) throws Exception {
        ZipFile zipFile = new ZipFile(includeDef.sourceKit.file.file);
        Iterator iterator = includeDef.typeToSource.values().iterator();
        HashSet<String> hashSet = new HashSet<String>();
        while (iterator.hasNext()) {
            ZipEntry zipEntry = (ZipEntry)iterator.next();
            if (!hashSet.add(zipEntry.getName())) continue;
            String string = zipEntry.getName().substring(zipEntry.getName().indexOf(47) + 1);
            this.writeSource(zipOutputStream, string, zipFile.getInputStream(zipEntry), hashMap);
        }
        zipFile.close();
    }

    private void writeSource(ZipOutputStream zipOutputStream, String string, InputStream inputStream, HashMap hashMap) throws IOException {
        for (int i = 0; i < 100 && hashMap.get(string) != null; ++i) {
            string = FileUtil.getBase((String)string) + "_" + i + ".sedona";
        }
        hashMap.put(string, string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        zipOutputStream.putNextEntry(new ZipEntry("source/" + string));
        FileUtil.pipe((InputStream)bufferedInputStream, (OutputStream)zipOutputStream);
        ((InputStream)bufferedInputStream).close();
        zipOutputStream.closeEntry();
    }
}

