/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import sedonac.Compiler;
import sedonac.CompilerException;
import sedonac.Location;
import sedonac.ast.IncludeDef;
import sedonac.ast.TypeDef;
import sedonac.ir.IrKit;
import sedonac.namespace.Type;
import sedonac.parser.Parser;
import sedonac.steps.ResolveDepends;

public class ResolveIncludes
extends ResolveDepends {
    public ResolveIncludes(Compiler compiler) {
        super(compiler);
        this.autoMountKitIntoNamespace = false;
    }

    @Override
    public void run() {
        int n;
        IncludeDef[] includeDefArray = this.compiler.ast.includes;
        if (includeDefArray == null || includeDefArray.length == 0) {
            this.compiler.ast.types = new TypeDef[0];
            return;
        }
        this.log.debug("  ResolveIncludes");
        for (n = 0; n < includeDefArray.length; ++n) {
            includeDefArray[n].sourceKit = this.resolveDepend(includeDefArray[n]);
        }
        this.quitIfErrors();
        for (n = 0; n < includeDefArray.length; ++n) {
            IrKit irKit = includeDefArray[n].sourceKit;
            this.resolveRecursive(irKit, null);
            if (!irKit.manifest.hasNatives) continue;
            this.err("Cannot include types from kits that have natives: " + irKit.file);
        }
        this.quitIfErrors();
        ArrayList arrayList = new ArrayList(includeDefArray.length);
        for (int i = 0; i < includeDefArray.length; ++i) {
            this.autoInclude(includeDefArray[i]);
            this.resolveTypes(includeDefArray[i], arrayList);
        }
        this.quitIfErrors();
        this.compiler.ast.types = arrayList.toArray(new TypeDef[arrayList.size()]);
    }

    private void autoInclude(IncludeDef includeDef) {
        Iterator iterator = includeDef.typeToSource.keySet().iterator();
        while (iterator.hasNext()) {
            this.recursivelyAutoInclude(includeDef, (String)iterator.next());
        }
    }

    private void recursivelyAutoInclude(IncludeDef includeDef, String string) {
        Type type = includeDef.sourceKit.type(string);
        if (type == null) {
            return;
        }
        Type type2 = type.base();
        int n = -1;
        n = type2.qname().indexOf(58);
        String string2 = type2.qname().substring(0, n);
        String string3 = type2.qname().substring(n + 2);
        if (string2.equals(includeDef.depend.name()) && !includeDef.typeToSource.containsKey(string3)) {
            StringBuffer stringBuffer = new StringBuffer().append("Auto-Including '").append(((Object)type2).toString()).append("' from kit ").append(includeDef.sourceKit.file).append(". '").append(string).append("' depends on it.");
            this.warn(stringBuffer.toString());
            includeDef.typeToSource.put(string3, null);
            this.recursivelyAutoInclude(includeDef, string3);
        }
    }

    private void resolveTypes(IncludeDef includeDef, ArrayList arrayList) {
        File file = includeDef.sourceKit.file.file;
        Location location = null;
        try {
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory() || !zipEntry.getName().endsWith(".sedona")) continue;
                bl = true;
                location = new Location(file, zipEntry);
                TypeDef[] typeDefArray = new Parser(this.compiler, location, zipFile.getInputStream(zipEntry)).parse();
                for (int i = 0; i < typeDefArray.length; ++i) {
                    if (!includeDef.typeToSource.containsKey(typeDefArray[i].name())) continue;
                    includeDef.typeToSource.put(typeDefArray[i].name(), zipEntry);
                    arrayList.add(typeDefArray[i]);
                    this.log.debug("      Include '" + typeDefArray[i].name() + "' from: " + file.getName() + "|" + zipEntry.getName());
                }
            }
            if (!bl) {
                this.err("<include> error: Kit '" + includeDef.sourceKit.name() + "' does not include source files.");
            }
            for (TypeDef[] typeDefArray : includeDef.typeToSource.keySet()) {
                if (includeDef.typeToSource.get(typeDefArray) != null) continue;
                this.err("<include> error: type '" + (String)typeDefArray + "' was not defined in any source files from kit '" + includeDef.sourceKit.file + "'");
            }
            zipFile.close();
        }
        catch (CompilerException compilerException) {
            throw this.err("Failed to compile source from kit", location, (Throwable)compilerException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw this.err("Cannot import types from kit file", new Location(file), (Throwable)exception);
        }
    }
}

