/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.util.ArrayList;
import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.Location;
import sedonac.ir.IrMethod;
import sedonac.ir.IrSlot;
import sedonac.ir.IrType;
import sedonac.namespace.TypeUtil;

public class FindTestCases
extends CompilerStep {
    public FindTestCases(Compiler compiler) {
        super(compiler);
    }

    @Override
    public void run() {
        if (!this.compiler.image.test) {
            return;
        }
        this.log.debug("  FindTestCases");
        this.compiler.testMethods = FindTestCases.findTestMethods(this.flat.types, false);
        for (int i = 0; i < this.compiler.testMethods.length; ++i) {
            this.checkTestCase(this.compiler.testMethods[i]);
        }
    }

    private void checkTestCase(IrMethod irMethod) {
        boolean bl;
        String string = irMethod.qname;
        Location location = new Location(string);
        boolean bl2 = bl = irMethod.params.length > 0;
        if (!irMethod.isPublic()) {
            this.err("Test method '" + string + "' must be public", location);
        }
        if (!irMethod.isStatic()) {
            this.err("Test method '" + string + "' must be static", location);
        }
        if (irMethod.isAbstract()) {
            this.err("Test method '" + string + "' cannot be abstract", location);
        }
        if (irMethod.isNative()) {
            this.err("Test method '" + string + "' cannot be native", location);
        }
        if (!irMethod.ret.isVoid()) {
            this.err("Test method '" + string + "' return void", location);
        }
        if (bl) {
            this.err("Test method '" + string + "' cannot have parameters", location);
        }
    }

    public static IrMethod[] findTestMethods(IrType[] irTypeArray, boolean bl) {
        ArrayList<IrMethod> arrayList = new ArrayList<IrMethod>(100);
        for (int i = 0; i < irTypeArray.length; ++i) {
            IrType irType = irTypeArray[i];
            if (!TypeUtil.isaTest(irType)) continue;
            for (int j = 0; j < irType.declared.length; ++j) {
                IrSlot irSlot = irType.declared[j];
                if (!(irSlot instanceof IrMethod)) continue;
                IrMethod irMethod = (IrMethod)irSlot;
                if (!irMethod.name.startsWith("test") || bl && irMethod.facets.getb("javaSkip", false)) continue;
                arrayList.add(irMethod);
            }
        }
        return arrayList.toArray(new IrMethod[arrayList.size()]);
    }
}

