/*
 * Decompiled with CFR 0.152.
 */
package sedonac.jasm;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import sedonac.jasm.Assembler;
import sedonac.jasm.AttributeInfo;
import sedonac.jasm.Buffer;
import sedonac.jasm.ConstantPool;
import sedonac.jasm.Jvm;

public class Code
extends AttributeInfo {
    public final ConstantPool cp;
    public int maxStack = -1;
    public int maxLocals = -1;
    public Buffer code = new Buffer(512);
    public AttributeInfo[] attributes = new AttributeInfo[0];

    public Code(Assembler assembler) {
        super(assembler, "Code");
        this.cp = assembler.cp;
    }

    public int add(int n) {
        if (Jvm.OPCODE_ARGS[n] != 0) {
            throw new IllegalStateException("Opcode requires arguments: " + n);
        }
        return this.code.u1(n);
    }

    public int add(int n, int n2) {
        int n3 = this.code.count;
        if (n == 18) {
            if (n2 < 255) {
                this.code.u1(18);
                this.code.u1(n2);
            } else {
                this.code.u1(19);
                this.code.u2(n2);
            }
            return n3;
        }
        byte by = Jvm.OPCODE_ARGS[n];
        this.code.u1(n);
        if (by == 1) {
            this.code.u1(n2);
        } else if (by == 2 || by == 3) {
            this.code.u2(n2);
        } else {
            throw new IllegalStateException("Opcode does not take u1 or u2 args: " + n);
        }
        return n3;
    }

    public int addIntConst(int n) {
        switch (n) {
            case -1: {
                return this.add(2);
            }
            case 0: {
                return this.add(3);
            }
            case 1: {
                return this.add(4);
            }
            case 2: {
                return this.add(5);
            }
            case 3: {
                return this.add(6);
            }
            case 4: {
                return this.add(7);
            }
            case 5: {
                return this.add(8);
            }
        }
        if (-128 <= n && n <= 127) {
            return this.add(16, n);
        }
        if (Short.MIN_VALUE <= n && n <= Short.MAX_VALUE) {
            return this.add(17, n);
        }
        return this.add(18, this.cp.intConst(n));
    }

    public int addLongConst(long l) {
        if (l == 0L) {
            return this.add(9);
        }
        if (l == 1L) {
            return this.add(10);
        }
        return this.add(20, this.cp.longConst(l));
    }

    public int addFloatConst(float f) {
        if (f == 0.0f) {
            return this.add(11);
        }
        if (f == 1.0f) {
            return this.add(12);
        }
        return this.add(18, this.cp.floatConst(f));
    }

    public int addDoubleConst(double d) {
        if (d == 0.0) {
            return this.add(14);
        }
        if (d == 1.0) {
            return this.add(15);
        }
        return this.add(20, this.cp.doubleConst(d));
    }

    public int addPad(int n) {
        int n2 = this.code.u1(n);
        int n3 = 3 - n2 % 4;
        for (int i = 0; i < n3; ++i) {
            this.code.u1(0);
        }
        return n2;
    }

    public void aload(int n) {
        switch (n) {
            case 0: {
                this.add(42);
                break;
            }
            case 1: {
                this.add(43);
                break;
            }
            case 2: {
                this.add(44);
                break;
            }
            case 3: {
                this.add(45);
                break;
            }
            default: {
                this.add(25, n);
            }
        }
    }

    public void iload(int n) {
        switch (n) {
            case 0: {
                this.add(26);
                break;
            }
            case 1: {
                this.add(27);
                break;
            }
            case 2: {
                this.add(28);
                break;
            }
            case 3: {
                this.add(29);
                break;
            }
            default: {
                this.add(21, n);
            }
        }
    }

    public void lload(int n) {
        switch (n) {
            case 0: {
                this.add(30);
                break;
            }
            case 1: {
                this.add(31);
                break;
            }
            case 2: {
                this.add(32);
                break;
            }
            case 3: {
                this.add(33);
                break;
            }
            default: {
                this.add(22, n);
            }
        }
    }

    public void fload(int n) {
        switch (n) {
            case 0: {
                this.add(34);
                break;
            }
            case 1: {
                this.add(35);
                break;
            }
            case 2: {
                this.add(36);
                break;
            }
            case 3: {
                this.add(37);
                break;
            }
            default: {
                this.add(23, n);
            }
        }
    }

    public void dload(int n) {
        switch (n) {
            case 0: {
                this.add(38);
                break;
            }
            case 1: {
                this.add(39);
                break;
            }
            case 2: {
                this.add(40);
                break;
            }
            case 3: {
                this.add(41);
                break;
            }
            default: {
                this.add(24, n);
            }
        }
    }

    public void astore(int n) {
        switch (n) {
            case 0: {
                this.add(75);
                break;
            }
            case 1: {
                this.add(76);
                break;
            }
            case 2: {
                this.add(77);
                break;
            }
            case 3: {
                this.add(78);
                break;
            }
            default: {
                this.add(58, n);
            }
        }
    }

    public void istore(int n) {
        switch (n) {
            case 0: {
                this.add(59);
                break;
            }
            case 1: {
                this.add(60);
                break;
            }
            case 2: {
                this.add(61);
                break;
            }
            case 3: {
                this.add(62);
                break;
            }
            default: {
                this.add(54, n);
            }
        }
    }

    public void lstore(int n) {
        switch (n) {
            case 0: {
                this.add(63);
                break;
            }
            case 1: {
                this.add(64);
                break;
            }
            case 2: {
                this.add(65);
                break;
            }
            case 3: {
                this.add(66);
                break;
            }
            default: {
                this.add(55, n);
            }
        }
    }

    public void fstore(int n) {
        switch (n) {
            case 0: {
                this.add(67);
                break;
            }
            case 1: {
                this.add(68);
                break;
            }
            case 2: {
                this.add(69);
                break;
            }
            case 3: {
                this.add(70);
                break;
            }
            default: {
                this.add(56, n);
            }
        }
    }

    public void dstore(int n) {
        switch (n) {
            case 0: {
                this.add(71);
                break;
            }
            case 1: {
                this.add(72);
                break;
            }
            case 2: {
                this.add(73);
                break;
            }
            case 3: {
                this.add(74);
                break;
            }
            default: {
                this.add(57, n);
            }
        }
    }

    public int branch(int n) {
        return this.add(n, 65535) + 1;
    }

    public int branch(int n, int n2) {
        return this.add(n, n2 - this.code.count);
    }

    public void patch(int n) {
        this.patch(n, this.code.count);
    }

    public void patch(int n, int n2) {
        this.code.u2(n, n2 - n + 1);
    }

    public int invoke(Method method) {
        int n = this.cp.method(method);
        int n2 = method.getModifiers();
        if (Modifier.isInterface(n2)) {
            return this.invokeInterface(n, method.getParameterTypes().length + 1);
        }
        if (Modifier.isStatic(n2)) {
            return this.add(184, n);
        }
        return this.add(182, n);
    }

    public int invokeInterface(int n, int n2) {
        int n3 = this.code.count;
        this.code.u1(185);
        this.code.u2(n);
        this.code.u1(n2);
        this.code.u1(0);
        return n3;
    }

    @Override
    void compile(Buffer buffer) {
        if (this.maxStack < 0 || this.maxLocals < 0) {
            throw new IllegalStateException("maxStack or maxLocals not set");
        }
        buffer.u2(this.name);
        int n = buffer.u4(-1);
        buffer.u2(this.maxStack);
        buffer.u2(this.maxLocals);
        buffer.u4(this.code.count);
        buffer.append(this.code);
        buffer.u2(0);
        buffer.u2(this.attributes.length);
        for (int i = 0; i < this.attributes.length; ++i) {
            this.attributes[i].compile(buffer);
        }
        buffer.u4(n, buffer.count - n - 4);
    }
}

