/*
 * Decompiled with CFR 0.152.
 */
package sedonac.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import sedona.Buf;
import sedona.KitPart;
import sedona.Schema;
import sedona.util.Version;
import sedonac.scode.SCode;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SCodeValidator {
    static SCodeValidator decode;
    Buf buf;
    SHeader hdr;
    Schema schema;
    int sysKitBix;
    int endTypeBix;
    int endSlotBix;
    int endLogBix;

    public void parse(File file) throws IOException {
        this.parse(Buf.readFrom((File)file));
    }

    public void parse(Buf buf) throws IOException {
        this.buf = buf;
        System.out.println("\nParsing header fields....\n");
        this.hdr.parse(buf);
        this.hdr.print();
        System.out.println("\nParsing bootstrap....\n");
        this.parseBootstrap(buf);
        System.out.println("\nParsing kit list....\n");
        this.parseKits();
        System.out.println();
        System.out.println("endTypeBix = 0x" + SCodeValidator.tHS(this.endTypeBix));
        System.out.println("endSlotBix = 0x" + SCodeValidator.tHS(this.endSlotBix));
        System.out.println("\nParsing log list....\n");
        this.parseLogs(this.endSlotBix);
        System.out.println();
        System.out.println("endLogBix = 0x" + SCodeValidator.tHS(this.endLogBix));
        System.out.println("\nParsing method list....\n");
        this.parseMethods(this.endLogBix);
        if (this.hdr.testTabBix > 0) {
            System.out.println("\nParsing test table....\n");
            this.parseTests();
        } else {
            System.out.println("\nNo test table to parse.\n");
        }
    }

    private final void parseBootstrap(Buf buf) throws IOException {
        int n;
        buf.pos = this.hdr.bootBix * this.hdr.blockSize;
        int n2 = buf.u1();
        int n3 = buf.u1();
        System.out.println("Bootstrap: numParams = " + n2 + ", numLocals = " + n3);
        int n4 = buf.u1();
        if (n4 == 0) {
            n4 = buf.u1();
        }
        while (n4 == 221) {
            n = this.u2aligned(buf);
            System.out.println("Static init call to bix = 0x" + SCodeValidator.tHS(n));
            n4 = buf.u1();
            if (n4 != 0) continue;
            n4 = buf.u1();
        }
        if (n4 != 29) {
            throw new IOException("Found " + n4 + " not LoadParam0 at offset " + SCodeValidator.tHS(buf.pos));
        }
        n4 = buf.u1();
        if (n4 != 30) {
            throw new IOException("Found " + n4 + " not LoadParam1 at offset " + SCodeValidator.tHS(buf.pos));
        }
        n4 = buf.u1();
        if (n4 == 0) {
            n4 = buf.u1();
        }
        if (n4 != 221) {
            throw new IOException("Found " + n4 + " not Call at offset " + SCodeValidator.tHS(buf.pos));
        }
        n = this.u2aligned(buf);
        n4 = buf.u1();
        if (n4 != 227) {
            throw new IOException("Found " + n4 + " not ReturnPop at offset " + SCodeValidator.tHS(buf.pos));
        }
        System.out.println(" Main bix is " + SCodeValidator.tHS(n));
        System.out.println("Bootstrap section ended at scode offset " + SCodeValidator.tHS(buf.pos));
    }

    private final void parseMethodStandalone(File file, int n) throws IOException {
        this.buf = Buf.readFrom((File)file);
        System.out.println("\nParsing header fields....");
        this.hdr.parse(this.buf);
        this.parseMethod(n, true);
    }

    private final void parseMethods(int n) throws IOException {
        if (n > 0) {
            this.buf.pos = n * this.hdr.blockSize;
        }
        while (this.buf.pos < this.hdr.imageSize) {
            this.parseMethod(-1, false);
        }
    }

    private final void parseMethod(int n, boolean bl) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = this.buf.pos;
        if (n > 0) {
            this.buf.pos = n * this.hdr.blockSize;
        } else {
            n = this.buf.pos / this.hdr.blockSize;
        }
        int n3 = this.buf.pos;
        System.out.println("\nParsing method at bix = 0x" + SCodeValidator.tHS(n));
        int n4 = this.buf.pos;
        int n5 = this.buf.u1();
        System.out.println(SCodeValidator.opFormat(n4, n5, "Num params") + n5);
        n4 = this.buf.pos;
        n5 = this.buf.u1();
        System.out.println(SCodeValidator.opFormat(n4, n5, "Num locals") + n5);
        boolean bl2 = false;
        block5: while (!bl2) {
            n4 = this.buf.pos;
            n5 = this.buf.u1();
            System.out.print(SCodeValidator.opFormat(n4, n5, SCode.name(n5)));
            String string = this.getArgString(n5);
            if (string != null) {
                System.out.println(string);
            } else {
                System.out.println();
            }
            switch (n5) {
                case 221: {
                    arrayList.add(string);
                    break;
                }
                case 142: 
                case 143: 
                case 144: 
                case 146: 
                case 147: 
                case 148: 
                case 150: 
                case 151: 
                case 152: 
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: {
                    if (n4 + SCodeValidator.intval(string) <= n3) continue block5;
                    n3 = n4 + SCodeValidator.intval(string);
                    break;
                }
                case 226: 
                case 227: 
                case 228: {
                    if (this.buf.pos <= n3) continue block5;
                    bl2 = true;
                    break;
                }
            }
        }
        if (bl) {
            this.buf.pos = n2;
        }
    }

    private final String getArgString(int n) throws IOException {
        String string = null;
        switch (SCode.argType(n)) {
            case 14: {
                string = String.valueOf(this.buf.s1());
                break;
            }
            case 1: {
                string = "0x" + SCodeValidator.tHS(this.buf.u1());
                break;
            }
            case 15: {
                string = String.valueOf(this.buf.s2());
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "0x" + SCodeValidator.tHS(this.u2aligned(this.buf));
                break;
            }
            case 13: {
                string = "0x" + SCodeValidator.tHS(this.buf.u2());
                break;
            }
            case 4: {
                string = String.valueOf(this.i4aligned(this.buf));
                break;
            }
            case 6: {
                string = String.valueOf(this.f4aligned(this.buf));
                break;
            }
            case 3: {
                string = "0x" + SCodeValidator.tHS(this.i4aligned(this.buf));
                break;
            }
            case 5: {
                string = "0x" + Long.toHexString(this.i8aligned(this.buf));
                break;
            }
            case 7: {
                string = String.valueOf(this.f8aligned(this.buf));
                break;
            }
            case 16: {
                int n2 = this.u2aligned(this.buf);
                string = "(" + n2 + ") ";
                int n3 = 0;
                while (n3 < n2) {
                    if (n3 > 0) {
                        string = string + ", ";
                    }
                    string = string + "0x" + SCodeValidator.tHS(this.u2aligned(this.buf));
                    ++n3;
                }
                break;
            }
            case 12: {
                if (SCode.name(n).endsWith("1")) {
                    string = "0x" + SCodeValidator.tHS(this.buf.u1());
                    break;
                }
                if (SCode.name(n).endsWith("2")) {
                    string = "0x" + SCodeValidator.tHS(this.u2aligned(this.buf));
                    break;
                }
                if (SCode.name(n).endsWith("4")) {
                    string = "0x" + SCodeValidator.tHS(this.i4aligned(this.buf));
                    break;
                }
                string = "0x" + SCodeValidator.tHS(this.u2aligned(this.buf));
                break;
            }
            default: {
                return null;
            }
        }
        return string;
    }

    private final void parseLogs(int n) throws IOException {
        int n2 = -2;
        int n3 = -1;
        int n4 = this.buf.pos;
        if (n > 0) {
            this.buf.pos = n * this.hdr.blockSize;
        }
        while (n3 == n2 + 1) {
            n2 = n3;
            n3 = this.u2aligned(this.buf);
            int n5 = this.u2aligned(this.buf);
            String string = this.parseStr(n5);
            if (n3 != n2 + 1) continue;
            System.out.print("\nLog " + n3);
            System.out.println("\tName = " + string + "  NameBix = 0x" + SCodeValidator.tHS(n5));
        }
        this.endLogBix = (this.buf.pos + (this.hdr.blockSize - 1)) / this.hdr.blockSize;
        this.buf.pos = n4;
    }

    private final void parseTests() throws IOException {
        this.buf.pos = this.hdr.testTabBix * this.hdr.blockSize;
        int n = this.u2aligned(this.buf);
        System.out.println("  # tests = " + n);
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.u2aligned(this.buf);
            int n4 = this.u2aligned(this.buf);
            System.out.print("\nTest " + n2 + ": qname bix = 0x" + SCodeValidator.tHS(n3));
            System.out.println(", code bix = 0x" + SCodeValidator.tHS(n4));
            System.out.println("  Name = " + this.parseQnameSlot(n3));
            System.out.println();
            this.parseMethod(n4, true);
            ++n2;
        }
    }

    private final void parseTest(int n) throws IOException {
        this.buf.pos = n * this.hdr.blockSize;
        int n2 = this.buf.u1();
        int n3 = this.buf.u1();
        int n4 = this.u2aligned(this.buf);
        int n5 = this.u2aligned(this.buf);
        String string = this.parseStr(n4);
        String string2 = this.parseStr(n5);
        int n6 = this.u2aligned(this.buf);
        int n7 = this.i4aligned(this.buf);
    }

    private final void parseKits() throws IOException {
        int n = 0;
        while (n < this.hdr.numKits) {
            this.buf.pos = this.hdr.kitTabBix * this.hdr.blockSize + n * 2;
            int n2 = this.u2aligned(this.buf);
            this.parseKit(n2);
            ++n;
        }
    }

    private final KitPart parseKit(int n) throws IOException {
        int n2 = this.buf.pos;
        this.buf.pos = n * this.hdr.blockSize;
        int n3 = this.buf.u1();
        int n4 = this.buf.u1();
        int n5 = this.u2aligned(this.buf);
        int n6 = this.u2aligned(this.buf);
        String string = this.parseStr(n5);
        if (string.equals("sys")) {
            this.sysKitBix = n;
        }
        String string2 = this.parseStr(n6);
        int n7 = this.u2aligned(this.buf);
        int n8 = this.i4aligned(this.buf);
        System.out.println("\nKit " + n3 + " at bix 0x" + SCodeValidator.tHS(n));
        System.out.println("  Name    = " + string + '-' + SCodeValidator.tHS(n8) + "  ver " + string2);
        System.out.println("  NameBix = 0x" + SCodeValidator.tHS(n5) + ", verBix = 0x" + SCodeValidator.tHS(n6));
        System.out.println("  # types = " + n4);
        int n9 = 0;
        while (n9 < n4) {
            int n10 = this.u2aligned(this.buf);
            this.parseType(n10);
            ++n9;
        }
        this.buf.pos = n2;
        return new KitPart(string, n8, Version.parse((String)string2));
    }

    private final void parseType(int n) throws IOException {
        int n2 = this.buf.pos;
        if (n > 0) {
            this.buf.pos = n * this.hdr.blockSize;
        } else {
            n = this.buf.pos / this.hdr.blockSize;
        }
        int n3 = this.buf.u1();
        int n4 = this.buf.u1();
        int n5 = this.u2aligned(this.buf);
        int n6 = this.u2aligned(this.buf);
        String string = this.parseStr(n5);
        System.out.println("\n\tType " + n3 + " at bix 0x" + SCodeValidator.tHS(n));
        System.out.println("  \tName    = " + string + "  NameBix = 0x" + SCodeValidator.tHS(n5));
        System.out.println("  \tkitBix  = " + SCodeValidator.tHS(n6));
        if (n6 == this.sysKitBix && string.substring(0, 1).equals(string.substring(0, 1).toLowerCase())) {
            this.buf.pos = n2;
            return;
        }
        int n7 = this.u2aligned(this.buf);
        int n8 = this.u2aligned(this.buf);
        int n9 = this.u2aligned(this.buf);
        System.out.println("  \tbaseBix = " + SCodeValidator.tHS(n7));
        System.out.println("  \tinitBix = " + SCodeValidator.tHS(n9));
        System.out.println("  \tSize    = " + n8 + "  # slots = " + n4);
        int n10 = 0;
        while (n10 < n4) {
            int n11 = this.u2aligned(this.buf);
            this.parseSlot(n11);
            ++n10;
        }
        if (n > this.endTypeBix) {
            this.endTypeBix = (this.buf.pos + (this.hdr.blockSize - 1)) / this.hdr.blockSize;
        }
        this.buf.pos = n2;
    }

    private final void parseSlot(int n) throws IOException {
        int n2 = this.buf.pos;
        this.buf.pos = n * this.hdr.blockSize;
        int n3 = this.buf.u1();
        int n4 = this.buf.u1();
        int n5 = this.u2aligned(this.buf);
        String string = this.parseStr(n5);
        int n6 = this.u2aligned(this.buf);
        int n7 = this.u2aligned(this.buf);
        System.out.println("\n\t\tSlot " + n3 + " at bix 0x" + SCodeValidator.tHS(n));
        System.out.println("  \t\tName    = " + string + "  NameBix = 0x" + SCodeValidator.tHS(n5));
        System.out.println("  \t\tfpBix   = " + SCodeValidator.tHS(n6) + "  rtFlags = " + n4);
        System.out.println("  \t\tcodeBix = " + SCodeValidator.tHS(n7) + " ONLY if method!");
        if (n > this.endSlotBix) {
            this.endSlotBix = (this.buf.pos + (this.hdr.blockSize - 1)) / this.hdr.blockSize;
        }
        this.buf.pos = n2;
    }

    private final String parseQnameSlot(int n) throws IOException {
        int n2 = this.buf.pos;
        this.buf.pos = n * this.hdr.blockSize;
        int n3 = this.u2aligned(this.buf);
        int n4 = this.u2aligned(this.buf);
        this.buf.pos = n3 * this.hdr.blockSize;
        int n5 = this.u2aligned(this.buf);
        int n6 = this.u2aligned(this.buf);
        String string = this.parseStr(n5);
        String string2 = this.parseStr(n6);
        String string3 = this.parseStr(n4);
        this.buf.pos = n2;
        return string + ':' + string2 + '.' + string3;
    }

    private final String parseStr(int n) throws IOException {
        int n2 = n * this.hdr.blockSize;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (this.buf.bytes[n2 + n3] != 0) {
            stringBuffer.append((char)this.buf.bytes[n2 + n3]);
            ++n3;
        }
        return stringBuffer.toString();
    }

    private final int u2aligned(Buf buf) throws IOException {
        if (buf.pos % 2 != 0) {
            throw new IOException("Alignment exception at scode offset 0x" + SCodeValidator.tHS(buf.pos));
        }
        return buf.u2();
    }

    private final int i4aligned(Buf buf) throws IOException {
        if (buf.pos % 4 != 0) {
            throw new IOException("Alignment exception at scode offset 0x" + SCodeValidator.tHS(buf.pos));
        }
        return buf.i4();
    }

    private final long i8aligned(Buf buf) throws IOException {
        if (buf.pos % 8 != 0) {
            throw new IOException("Alignment exception at scode offset 0x" + SCodeValidator.tHS(buf.pos));
        }
        return buf.i8();
    }

    private final float f4aligned(Buf buf) throws IOException {
        if (buf.pos % 4 != 0) {
            throw new IOException("Alignment exception at scode offset 0x" + SCodeValidator.tHS(buf.pos));
        }
        return buf.f4();
    }

    private final double f8aligned(Buf buf) throws IOException {
        if (buf.pos % 8 != 0) {
            throw new IOException("Alignment exception at scode offset 0x" + SCodeValidator.tHS(buf.pos));
        }
        return buf.f8();
    }

    static String tHS(int n) {
        return Integer.toHexString(n);
    }

    static int intval(String string) {
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Error: Could not extract integer from string " + string);
            return -1;
        }
    }

    static int hexval(String string) {
        try {
            return Integer.valueOf(string.substring(2), 16);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Error: Could not extract integer from string " + string);
            return -1;
        }
    }

    static String opFormat(int n, int n2, String string) {
        String string2 = "                                                  ";
        int n3 = 25;
        String string3 = string2.substring(0, n3 - string.length());
        String string4 = n2 < 16 ? "   0x0" : "   0x";
        return SCodeValidator.tHS(n) + "  " + string4 + SCodeValidator.tHS(n2) + "   : " + string + string3;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            System.out.println("usage: SCodeValidator <file> [bix]");
            return;
        }
        if (stringArray.length > 1) {
            System.out.println("Decoding method in file " + stringArray[0] + " at bix " + stringArray[1]);
            int n = Integer.parseInt(stringArray[1], 16);
            new SCodeValidator().parseMethodStandalone(new File(stringArray[0]), n);
            return;
        }
        System.out.println("\n\nDecoding " + stringArray[0] + ":\n");
        new SCodeValidator().parse(new File(stringArray[0]));
    }

    private final /* synthetic */ void this() {
        this.hdr = new SHeader();
        this.sysKitBix = -1;
        this.endTypeBix = -1;
        this.endSlotBix = -1;
        this.endLogBix = -1;
    }

    public SCodeValidator() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class SHeader {
        public boolean bigEndian;
        public int vmMagic;
        public int majorVer;
        public int minorVer;
        public int blockSize;
        public int refSize;
        public int imageSize;
        public int dataSize;
        public int bootBix;
        public int testTabBix;
        public int kitTabBix;
        public int numKits;

        public void parse(Buf buf) throws IOException {
            buf.pos = 0;
            this.vmMagic = SCodeValidator.this.i4aligned(buf);
            if (this.vmMagic != 1590737415) {
                this.bigEndian = false;
                buf.bigEndian = false;
                buf.pos = 0;
                this.vmMagic = SCodeValidator.this.i4aligned(buf);
                if (this.vmMagic != 1590737415) {
                    throw new IOException("Invalid magic for scode");
                }
            }
            this.majorVer = buf.u1();
            this.minorVer = buf.u1();
            this.blockSize = buf.u1();
            this.refSize = buf.u1();
            if (this.majorVer != 1 || this.minorVer != 5) {
                throw new IOException("Unsupported scode version " + this.majorVer + '.' + this.minorVer);
            }
            this.imageSize = SCodeValidator.this.i4aligned(buf);
            this.dataSize = SCodeValidator.this.i4aligned(buf);
            this.bootBix = SCodeValidator.this.u2aligned(buf);
            this.testTabBix = SCodeValidator.this.u2aligned(buf);
            this.kitTabBix = SCodeValidator.this.u2aligned(buf);
            this.numKits = buf.u1();
        }

        public void print() {
            System.out.println("  Platform is " + (this.bigEndian ? "big" : "little") + " endian.");
            System.out.println("  vmMagic      = 0x" + SCodeValidator.tHS(this.vmMagic));
            System.out.println("  majorVer     = " + this.majorVer);
            System.out.println("  minorVer     = " + this.minorVer);
            System.out.println("  blockSize    = " + this.blockSize);
            System.out.println("  refSize      = " + this.refSize);
            System.out.println("  imageSize    = 0x" + SCodeValidator.tHS(this.imageSize) + "\t(" + this.imageSize + ')');
            System.out.println("  dataSize     = 0x" + SCodeValidator.tHS(this.dataSize) + "\t(" + this.dataSize + ')');
            System.out.println("  boot bix     = 0x" + SCodeValidator.tHS(this.bootBix));
            System.out.println("  test tab bix = 0x" + SCodeValidator.tHS(this.testTabBix));
            System.out.println("  kit tab bix  = 0x" + SCodeValidator.tHS(this.kitTabBix));
            System.out.println("  num kits     = " + this.numKits);
        }

        private final /* synthetic */ void this() {
            this.bigEndian = true;
        }

        SHeader() {
            this.this();
        }
    }
}

